/*
 * IBM Confidential
 * OCO Source Materials
 * JP720140001D
 * (C) Copyright IBM Corp. 2009
 */
package com.ibm.trinity.dsl.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.validation.Check;

import com.ibm.trinity.syncmodel.Dimension;
import com.ibm.trinity.syncmodel.EcoreImport;
import com.ibm.trinity.syncmodel.JoinedSyncTableDef;
import com.ibm.trinity.syncmodel.JoinedSyncTableSchema;
import com.ibm.trinity.syncmodel.LocalQuery;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.SyncTableDef;
import com.ibm.trinity.syncmodel.TypedSyncTable;

public class SyncModelJavaValidator extends AbstractSyncModelJavaValidator {
    @Check
    public void checkEcoreImport(EcoreImport ecoreImport) {
        if (ecoreImport == null) return; // Default case
        // We prohibit the use of "http://www.nomagic.com/magicdraw/UML/2.5.0"
        String iri = ecoreImport.getIRI();
        if ("http://www.nomagic.com/magicdraw/UML/2.5.0".equals(iri)) {
        	error("You must not use http://www.nomagic.com/magicdraw/UML/2.5.0,"
                  + "use http://www.nomagic.com/magicdraw/UML/2.5 instead",
                  ecoreImport,
                  SyncModelPackage.eINSTANCE.getEcoreImport_IRI());
        }
        EPackage epkg = EPackage.Registry.INSTANCE.getEPackage(iri);
        if (epkg == null) {
        	error("Ecore:" + iri + " is missing",
                  ecoreImport,
                  SyncModelPackage.eINSTANCE.getEcoreImport_IRI());
        }
    }

	@Check
	public void checkDimension(Dimension dim) {
		if (dim.getKeyColumns() == null || dim.getKeyColumns().size() == 0) {
			error("No key column is defined. Dimension must have at least one key column", null);
		}
	}
	
	@Check
	public void checkLocalQuery(LocalQuery lq) {
		if (lq.hasIndex() && !lq.isMany()) {
			error("Non-many feature cannot have an index in its qualifier", null);
		}
	}
	
	@Check
	public void checkJoinedSyncTableDef(JoinedSyncTableDef jstd) {
		JoinedSyncTableSchema schema = jstd.getSchema();
		EList<TypedSyncTable> tss = schema.getTargetTypes();
		EList<SyncTableDef> targets = jstd.getSynctableDefs();
		int size = tss.size();
		if (size != targets.size()) {
			error("The number of arguments is mismatched:" + size + " != " + targets.size(), null);
		}
		for (int i = 0; i < size; i++) {
			TypedSyncTable ts = tss.get(i);
			SyncTableDef std = targets.get(i);
			if (!ts.equals(std.getType())) {
				error("Type mismatch at " + i + " " + ts + " " + std.getType(), null);
			}
		}
	}

}
