/*
 * IBM Confidential
 * OCO Source Materials
 * JP720140001D
 * (C) Copyright IBM Corp. 2009
 */
/*
* generated by Xtext
*/
package com.ibm.trinity.dsl.scoping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.SimpleScope;

import com.google.inject.Inject;
import com.ibm.trinity.syncmodel.AbstractDimension;
import com.ibm.trinity.syncmodel.AttributeFilter;
import com.ibm.trinity.syncmodel.AttributeProposition;
import com.ibm.trinity.syncmodel.ChainedDataSourceDef;
import com.ibm.trinity.syncmodel.Column;
import com.ibm.trinity.syncmodel.CountProposition;
import com.ibm.trinity.syncmodel.DataSourceDef;
import com.ibm.trinity.syncmodel.Dimension;
import com.ibm.trinity.syncmodel.DimensionMember;
import com.ibm.trinity.syncmodel.EcoreImport;
import com.ibm.trinity.syncmodel.Grouper;
import com.ibm.trinity.syncmodel.InequalityProposition;
import com.ibm.trinity.syncmodel.KeyColumn;
import com.ibm.trinity.syncmodel.KeyViewColumn;
import com.ibm.trinity.syncmodel.LocalQuery;
import com.ibm.trinity.syncmodel.MPAdapterDiscovery;
import com.ibm.trinity.syncmodel.MappedViewColumn;
import com.ibm.trinity.syncmodel.MatrixIndexViewLayout;
import com.ibm.trinity.syncmodel.NonkeyViewColumn;
import com.ibm.trinity.syncmodel.ObjectQueryPath;
import com.ibm.trinity.syncmodel.PrimaryViewLayout;
import com.ibm.trinity.syncmodel.Proposition;
import com.ibm.trinity.syncmodel.PropositionType;
import com.ibm.trinity.syncmodel.Qualifier;
import com.ibm.trinity.syncmodel.ReferenceDecomposition;
import com.ibm.trinity.syncmodel.ReferenceFilter;
import com.ibm.trinity.syncmodel.ReferenceProposition;
import com.ibm.trinity.syncmodel.ReferrableSyncTable;
import com.ibm.trinity.syncmodel.RootDimension;
import com.ibm.trinity.syncmodel.SubsetProposition;
import com.ibm.trinity.syncmodel.SuccessiveDimension;
import com.ibm.trinity.syncmodel.SyncModel;
import com.ibm.trinity.syncmodel.SyncTableDef;
import com.ibm.trinity.syncmodel.SyncTableParam;
import com.ibm.trinity.syncmodel.SyncTableSchema;
import com.ibm.trinity.syncmodel.TypedSyncTable;
import com.ibm.trinity.syncmodel.ViewColumn;
import com.ibm.trinity.syncmodel.ViewColumnType;
import com.ibm.trinity.syncmodel.ViewLayout;
import com.ibm.trinity.syncmodel.WorksheetTemplate;
import com.ibm.trinity.syncmodel.WorksheetTemplateParam;

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping on how and when
 * to use it
 *
 */
public class SyncModelScopeProvider extends org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider {

	/*
	 * Logging is disabled for the time being to avoid the AssertionError (Cyclic
	 * resolution of lazy links) thrown by Xtext. This AssertionError is caused by
	 * implementations of #toString() for some SyncModel.ecore classes.
	 */
	protected static final Logger LOGGER = Logger.getLogger(SyncModelScopeProvider.class);

	@Inject
	IResourceDescriptions resDescriptions;

	private EcoreImport getDefaultEcoreImport(EObject ctx) {
		EObject container = ctx;
		SyncModel syncModel = null;
		while (container != null) {
			if (container instanceof SyncModel) {
				syncModel = (SyncModel) container;
				break;
			}
			container = container.eContainer();
		}
		if (syncModel == null)
			return null;
		return syncModel.getDefaultEcoreImport();
	}

	private EPackage getEPackage(EObject context, String iri, String defaultIRI) {
		Resource r = context.eResource();
		ResourceSet rset = r.getResourceSet();
		EPackage.Registry registry = rset.getPackageRegistry();
		if (registry instanceof MPAdapterDiscovery) {
			MPAdapterDiscovery discovery = (MPAdapterDiscovery) registry;
			return discovery.getEPackage(context, iri, defaultIRI);
		}

//        String iri = ecoreImport.getIRI();
		if ("http://www.nomagic.com/magicdraw/UML/2.5.0".equals(iri)) {
			// We prohibit the use of "http://www.nomagic.com/magicdraw/UML/2.5.0"
			return null;
		}

		EPackage epkg = EPackage.Registry.INSTANCE.getEPackage(iri);
		if (epkg != null)
			return epkg;

		if ("http://www.nomagic.com/magicdraw/UML/2.5".equals(iri)) {
			// Special Treatment because No Magic Ecore definitions contradict
			// EPackage Registry is http://www.nomagic.com/magicdraw/UML/2.5
			// org.eclipse.emf.ecore.generated_package is
			// http://www.nomagic.com/magicdraw/UML/2.5.0
			EPackage.Registry.INSTANCE.getEPackage("http://www.nomagic.com/magicdraw/UML/2.5.0");
			return EPackage.Registry.INSTANCE.getEPackage(iri);
		}

		return registry.getEPackage(iri);
	}

	private EPackage getEPackage(EcoreImport ecoreImport, EObject context) {
		String iri = null;
		String defaultIRI = null;
		EcoreImport defaultEcoreImport = getDefaultEcoreImport(context);
		if (defaultEcoreImport != null) {
			defaultIRI = defaultEcoreImport.getIRI();
		}
		if (ecoreImport == null) {
			iri = defaultIRI;
		} else {
			iri = ecoreImport.getIRI();
		}
		return getEPackage(context, iri, defaultIRI);
	}

	private EClassifier getVirtualFeatureClass(EcoreImport ecoreImport, EObject context) {
		EPackage pkg = getEPackage(ecoreImport, context);
		if (pkg == null)
			return null;
		switch (pkg.getNsURI()) {
		case "http://maplembse.maplesoft.com/capella/1.0":
			return pkg.getEClassifier("CapellaClass");
		case "http://maplembse.maplesoft.com/common/1.0":
			//TODO when we have common vf then this need to rework
			Optional<EPackage> opt = pkg.getESubpackages().stream().filter(p->"http://maplembse.maplesoft.com/twc/1.0".equals(p.getNsURI())).findAny();
			if (!opt.isPresent())
				throw new IllegalStateException("Twc virtual feature not found.");
			pkg = opt.get();
			// no break in order to execute from common the twc case and create an alias for common.
		case "http://maplembse.maplesoft.com/twc/1.0":
			return pkg.getEClassifier("TwcClass");
		default:
			throw new UnsupportedOperationException("The URI used for virtual feature is not supported.");
		}
	}

	private List<EClassifier> getAllClassifier(EPackage pkg) {
		List<EClassifier> result = new ArrayList<EClassifier>(pkg.getEClassifiers());
		for (EPackage p : pkg.getESubpackages())
			result.addAll(p.getEClassifiers());
		return result;
	}

	private IScope getScopeForEClassifier(EObject context, EcoreImport ecoreImport, Class<?> type) {
		EPackage pkg = getEPackage(ecoreImport, context);
		if (pkg == null)
			return IScope.NULLSCOPE;

		List<EClassifier> classifiers = getAllClassifier(pkg);
		List<EClassifier> result;
		if (type.equals(EClassifier.class)) {
			result = classifiers;
		} else {
			result = new ArrayList<EClassifier>(classifiers.size());
			for (EClassifier c : classifiers) {
				if (type.isInstance(c)) {
					result.add(c);
				}
			}
		}
		return Scopes.scopeFor(result);
	}

	private IScope getScopeFor(EClassifier classifier) {
		if (classifier instanceof EClass) {
			Iterable<IEObjectDescription> descs = resDescriptions.getExportedObjectsByType((EClass) classifier);
			return new SimpleScope(descs);
		} else if (classifier instanceof EDataType) {
			// TODO: Handle EDataType
			return IScope.NULLSCOPE;
		} else {
			return IScope.NULLSCOPE;
		}
	}

	private IScope getReferenceScopeFor(EClassifier classifier) {
		if (!(classifier instanceof EClass)) {
			return IScope.NULLSCOPE;
		}
		EClass type = (EClass) classifier;
		EList<EReference> refs = type.getEAllReferences();
		return Scopes.scopeFor(refs);
	}

	private IScope getAttributeScopeFor(EClassifier classifier) {
		if (classifier instanceof EClass) {
			EClass type = (EClass) classifier;
			return Scopes.scopeFor(type.getEAllAttributes());
		}
		return IScope.NULLSCOPE;
	}

	private IScope getFeaturesScopeFor(EClassifier classifier) {
		if (classifier instanceof EClass) {
			EClass type = (EClass) classifier;
			return Scopes.scopeFor(type.getEAllStructuralFeatures());
		}
		return IScope.NULLSCOPE;
	}

	private Set<EClassifier> initClassifierSet() {
		Set<EClassifier> classifiers = new HashSet<EClassifier>();
		// classifiers.add(MSEPackage.eINSTANCE.getCommonClass());
		return classifiers;
	}

	private IScope getStructuralFeatureScopeFor(Set<EClassifier> classifiers, LocalQuery localQuery) {
		Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();
		for (EClassifier classifier : classifiers) {
			if (classifier instanceof EClass) {
				EClass type = (EClass) classifier;
				switch (localQuery.getType()) {
				case CONTAINMENT:
					features.addAll(type.getEAllAttributes());
					for (EReference ref : type.getEAllReferences()) {
						if (ref.isContainment()) {
							features.add(ref);
						}
					}
					break;
				case REFERENCE:
					for (EReference ref : type.getEAllReferences()) {
						if (!ref.isContainment()) {
							features.add(ref);
						}
					}
				}
			}
		}
		return Scopes.scopeFor(features);
	}

	private IScope getReverseStructuralFeatureScopeFor(Set<EClassifier> classifiers, LocalQuery localQuery) {
		Qualifier qualifier = localQuery.getQualifier();
		EcoreImport ecoreImport = null;
		if (qualifier != null) {
			ecoreImport = qualifier.getEcorePackage();
		}
		if (ecoreImport == null) {
			// TODO: We may want to collect all EcoreImports defined in the SyncModel.
			ecoreImport = getDefaultEcoreImport(localQuery);
		}

		List<EClassifier> sources = null;
		EPackage pkg = getEPackage(ecoreImport, localQuery);
		if (pkg != null) {
			sources = pkg.getEClassifiers();
		}
		if (sources == null) {
			return IScope.NULLSCOPE;
		}

		// First, collect all EStructuralFeatures of the source EClassifiers
		Set<EStructuralFeature> allFeatures = new HashSet<EStructuralFeature>();
		for (EClassifier source : sources) {
			if (source instanceof EClass) {
				allFeatures.addAll(((EClass) source).getEAllStructuralFeatures());
			}
		}

		// Next, collect EStructuralFeatures whose type is a target classifier or a
		// super type of the target classifier.
		Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();
		for (EClassifier target : classifiers) {
			if (target instanceof EClass) {
				EClass targetClass = (EClass) target;
				for (EStructuralFeature feature : allFeatures) {
					EClassifier c = feature.getEType();
					if (c instanceof EClass) {
						EClass cls = (EClass) c;
						if (cls.isSuperTypeOf(targetClass)) {
							features.add(feature);
						}
					}
				}
			} else if (target instanceof EDataType) {
				for (EStructuralFeature feature : allFeatures) {
					EClassifier c = feature.getEType();
					if (target.equals(c)) {
						features.add(feature);
					}
				}
			} else {
				// ignore. impossible
			}
		}
		return Scopes.scopeFor(features);
	}

	// ---------------------------
	// Scopes for LocalQuery
	// ---------------------------

	// It seems invalid because SuccessiveDimension does not directly have
	// LocalQuery
	public IScope scope_LocalQuery_eStructuralFeature(SuccessiveDimension context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_LocalQueryDef_feature: context=" + context + ", reference=" + reference);
//      }
		Set<EClassifier> classifiers = initClassifierSet();
		for (AbstractDimension pred : context.getPredecessors()) {
			for (Dimension predsTail : pred.getTailDimensions()) {
				EClassifier c = predsTail.getEClassifier();
				if (c != null) {
					classifiers.add(c);
				}
			}
		}
		Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();
		for (EClassifier c : classifiers) {
			if (c instanceof EClass) {
				features.addAll(((EClass) c).getEAllStructuralFeatures());
			}
		}
		return Scopes.scopeFor(features);
	}

	public IScope scope_LocalQuery_eStructuralFeature(LocalQuery context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_LocalQueryDef_feature: context=" + context + ", reference=" + reference);
//      }

		Set<EClassifier> classifiers = initClassifierSet();
		EcoreImport ecoreImport = context.getEcorePackage();

		if (ecoreImport == null) {

			LocalQuery prev = context.getPrev();
			if (prev != null) {
				// Returns the classifier prescribed by the previous Qualifier
				EClassifier c = prev.getResultsEClassifier();
				if (c != null) {
					classifiers.add(c);
				}
			} else {
				// The context LocalQueryDef is the first element of the ObjectQueryPath
				// Looks for classifier prescribed by the parent of the ObjectQueryPath
				EObject localQueryOwner = context.eContainer();
				if (!(localQueryOwner instanceof ObjectQueryPath)) {
					return null;
				}
				ObjectQueryPath queryPath = (ObjectQueryPath) localQueryOwner;
				EObject queryPathContainer = queryPath.eContainer();
				if (queryPathContainer instanceof ChainedDataSourceDef) {
					ChainedDataSourceDef dsDef = (ChainedDataSourceDef) queryPathContainer;
					DataSourceDef parentDs = dsDef.getParentDataSource();
					EClassifier c = parentDs.getElementsEClassifier();
					if (c != null) {
						classifiers.add(c);
					}
				} else if (queryPathContainer instanceof SuccessiveDimension) {
					SuccessiveDimension dim = (SuccessiveDimension) queryPathContainer;
					for (Dimension pred : dim.getPredecessors()) {
						EClassifier c = pred.getEClassifier();
						classifiers.add(c);
					}
				} else if (queryPathContainer instanceof DimensionMember) {
					Dimension fmapOwner = ((DimensionMember) queryPathContainer).getOwnerDimension();
					EClassifier c = fmapOwner.getEClassifier();
					if (c != null) {
						classifiers.add(c);
					}
				} else {
					throw new IllegalStateException(String.valueOf(queryPathContainer));
				}
			}
			if (context.isReverse()) {
				return getReverseStructuralFeatureScopeFor(classifiers, context);
			} else {
				return getStructuralFeatureScopeFor(classifiers, context);
			}
		} else {
			if (context.isReverse())
				return IScope.NULLSCOPE;
			EClassifier ecls = getVirtualFeatureClass(ecoreImport, context);
			if (ecls == null)
				return IScope.NULLSCOPE;
			classifiers.add(ecls);

			return getStructuralFeatureScopeFor(classifiers, context);
		}
	}

	public IScope scope_LocalQuery_referenceDecomposition(Dimension context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_LocalQueryDef_referenceDecomposition: context=" + context + ", reference=" + reference);
//      }
		List<ReferenceDecomposition> decompositions = new ArrayList<ReferenceDecomposition>(
				context.getMembers().size());
		for (DimensionMember member : context.getMembers()) {
			if (member instanceof ReferenceDecomposition) {
				decompositions.add((ReferenceDecomposition) member);
			}
		}
		return Scopes.scopeFor(decompositions);
	}

	// ---------------------------
	// Scopes for Qualifier
	// ---------------------------

	public IScope scope_Qualifier_eClassifier(Qualifier context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_Qualifier_eclassifier: context=" + context + ", reference=" + reference);
//      }
		return getScopeForEClassifier(context, context.getEcorePackage(), EClassifier.class);
	}

	public IScope scope_Qualifier_eClassifier(LocalQuery context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_Qualifier_eclassifier: context=" + context + ", reference=" + reference);
//      }
		EStructuralFeature feature = context.getEStructuralFeature();
		if (feature instanceof EReference) {
			EClass refType = ((EReference) feature).getEReferenceType();
			return getScopeFor(refType);
		} else if (feature instanceof EDataType) {
			// TODO: handle EDataType
			return IScope.NULLSCOPE;
		} else {
			return IScope.NULLSCOPE;
		}
	}

	public IScope scope_Qualifier_eClassifier(ReferenceFilter context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_Qualifier_eclassifier: context=" + context + ", reference=" + reference);
//      }
		EReference ref = context.getEReference();
		EClass refType = ref.getEReferenceType();
		return getScopeFor(refType);
	}

	public IScope scope_Qualifier_eClassifier(RootDimension context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_Qualifier_eclassifier: context=" + context + ", reference=" + reference);
//      }
		Iterable<IEObjectDescription> descs = resDescriptions
				.getExportedObjectsByType(EcorePackage.eINSTANCE.getEClass());
		return new SimpleScope(descs);
	}

	// ---------------------------
	// Scope for AttributeFilter
	// ---------------------------

	public IScope scope_AttributeFilter_eAttribute(Qualifier context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_AttributeFilterDef_attribute: context=" + context + ", reference=" + reference);
//      }
		EClassifier eclassifier = context.getEClassifier();
		return getAttributeScopeFor(eclassifier);
	}

	public IScope scope_AttributeFilter_eAttribute(AttributeFilter context, EReference reference) {
		EcoreImport ecoreImport = context.getEcorePackage();

		if (ecoreImport == null) {
			EObject owner = context.eContainer();
			if (owner instanceof Qualifier) {
				return scope_AttributeFilter_eAttribute((Qualifier) owner, reference);
			}
		} else {
			EClassifier ecls = getVirtualFeatureClass(ecoreImport, context);
			if (ecls == null)
				return IScope.NULLSCOPE;
			return getAttributeScopeFor(ecls);
		}

		return IScope.NULLSCOPE;
	}

	// ---------------------------
	// Scope for ReferenceFilter
	// ---------------------------

	public IScope scope_ReferenceFilter_eReference(ReferenceFilter context, EReference reference) {
		EList<EClassifier> eclassifiers = new BasicEList<EClassifier>();
		eclassifiers.add(((Qualifier) context.eContainer()).getEClassifier());
		EcoreImport ecore = context.getEcorePackage();
		if (ecore != null) {
			EClassifier ecls = getVirtualFeatureClass(ecore, context);
			if (ecls != null)
				eclassifiers.add(ecls);
		}
		return getReferenceScopeFor(eclassifiers);
	}

	private IScope getReferenceScopeFor(List<EClassifier> classifiers) {
		EList<EReference> refs = new BasicEList<EReference>();
		for (EClassifier classifier : classifiers) {
			if (!(classifier instanceof EClass))
				continue;
			EClass type = (EClass) classifier;
			refs.addAll(type.getEAllReferences());
		}
		return Scopes.scopeFor(refs);
	}

	// ---------------------------
	// Scope for Proposition in PredicateFilter
	// ---------------------------

	public IScope scope_Proposition_eClassifier(Proposition context, EReference reference) {
		return getScopeForEClassifier(context, context.getEcorePackage(), EClassifier.class);
	}

	public IScope scope_Proposition_eFeature(Proposition context, EReference reference) {
		PropositionType type = context.getType();
		EClassifier eClassifier = context.getEClassifier();
		EClass eClass = null;
		if (eClassifier instanceof EClass)
			eClass = (EClass) eClassifier;
		else
			eClass = (EClass) getVirtualFeatureClass(context.getEcorePackage(), context);

		if (!(context instanceof Proposition)) {
			return Scopes.scopeFor(eClass.getEAllStructuralFeatures());
		} else if (context instanceof AttributeProposition) {
			return Scopes.scopeFor(eClass.getEAllAttributes());
		} else if (context instanceof CountProposition) {
			List<EStructuralFeature> tmp = eClass.getEAllStructuralFeatures();
			tmp = tmp.stream()
					.filter(f -> f instanceof EAttribute ? type.equals(PropositionType.CONTAINMENT)
							: ((EReference) f).isContainment() ? type.equals(PropositionType.CONTAINMENT)
									: type.equals(PropositionType.REFERENCE))
					.collect(Collectors.toList());
			return Scopes.scopeFor(tmp);
		} else if (context instanceof InequalityProposition) {
			return Scopes.scopeFor(eClass.getEAllAttributes());
		} else if (context instanceof ReferenceProposition) {
			List<EReference> tmp = eClass.getEAllReferences();
			tmp = tmp.stream().filter(r -> r.isContainment() ? type.equals(PropositionType.CONTAINMENT)
					: type.equals(PropositionType.REFERENCE)).collect(Collectors.toList());
			return Scopes.scopeFor(tmp);
		} else if (context instanceof SubsetProposition) {
			return Scopes.scopeFor(eClass.getEAllAttributes());
		}

		return IScope.NULLSCOPE;
	}
	
	// -----------------
	// Scope for grouper
	// -----------------
	public IScope scope_Grouper_eStructuralFeature(Qualifier context, EReference reference) {
		EClassifier eclassifier;
		EcoreImport ecoreImport = context.getEcorePackage();
		if (ecoreImport == null) {
			eclassifier = context.getEClassifier();
		} else {
			eclassifier = getVirtualFeatureClass(ecoreImport, context);
		}
		return getAttributeScopeFor(eclassifier);
	}

	public IScope scope_Grouper_eStructuralFeature(Grouper context, EReference reference) {
		EClassifier eclassifier;
		EcoreImport ecoreImport = context.getEcorePackage();
		if (ecoreImport == null) {
			eclassifier = ((Qualifier) context.eContainer()).getEClassifier();
		} else {
			eclassifier = getVirtualFeatureClass(ecoreImport, context);
		}
		return getAttributeScopeFor(eclassifier);
	}

//	TODO one per type
//	public IScope scope_TypedProposition_eFeature(CountProposition context, EReference reference) {
//		return IScope.NULLSCOPE;
//	}

	// ---------------------------
	// Scope for ForeignColumn
	// ---------------------------

	public IScope scope_ForeignColumn_ref(ReferenceDecomposition context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_ForeignColumn_ref: context=" + context + ", reference=" + reference);
//      }
		ReferrableSyncTable table = context.getForeignTable();
		if (table != null) {
			EList<Column> columns = table.getColumns();
			return Scopes.scopeFor(columns);
		}
		return IScope.NULLSCOPE;
	}

	// ---------------------------
	// Scopes for ReferenceDecomposition
	// ---------------------------

	public IScope scope_ReferenceDecomposition_foreignTable(SyncModel context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_ReferenceDecomposition_foreignTable: context=" + context + ", reference=" + reference);
//      }
		return Scopes.scopeFor(context.getSyncTableDefs());
	}

	public IScope scope_ReferenceDecomposition_foreignTable(SyncTableSchema context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_ReferenceDecomposition_foreignTable: context=" + context + ", reference=" + reference);
//      }
		// Get the list of SyncTableDefs from the SyncModel.
		List<SyncTableDef> syncTableDefs = Collections.emptyList();
		EObject container = context.eContainer();
		while (container != null) {
			if (container instanceof SyncModel) {
				SyncModel syncModel = (SyncModel) container;
				syncTableDefs = syncModel.getSyncTableDefs();
				break;
			}
			container = container.eContainer();
		}

		// Get the list of SyncTableParams from the context (SyncTableSchema.)
		EList<SyncTableParam> params = context.getParameters();
		List<ReferrableSyncTable> tables = new ArrayList<ReferrableSyncTable>(params.size() + syncTableDefs.size());
		tables.addAll(params);

		// Remember name of SyncTableParams to avoid adding SyncTableDefs of the same
		// name
		Set<String> paramNames = new HashSet<String>();
		for (SyncTableParam p : params) {
			paramNames.add(p.getName());
		}

		// Add SyncTableDefs to the scope objects list.
		for (SyncTableDef t : syncTableDefs) {
			if (!paramNames.contains(t.getName())) {
				tables.add(t);
			}
		}

		return Scopes.scopeFor(tables);
	}

	public IScope scope_MappedViewColumn_column(NonkeyViewColumn context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_MappedViewColumn_column: context=" + context + ", reference=" + reference);
//      }
		ViewLayout viewLayout = context.getOwner();
		WorksheetTemplateParam param = viewLayout.getSource();
		if (param == null) {
			return IScope.NULLSCOPE;
		}
		TypedSyncTable ts = param.getType();
		List<Column> columns = ts.getColumns();
		return Scopes.scopeFor(columns);
	}

	public IScope scope_MappedViewColumn_column(KeyViewColumn context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_MappedViewColumn_column: context=" + context + ", reference=" + reference);
//      }
		ViewLayout viewLayout = context.getOwner();
		WorksheetTemplateParam param = viewLayout.getSource();
		if (param == null) {
			return IScope.NULLSCOPE;
		}
		TypedSyncTable ts = param.getType();
		List<Column> columns = ts.getColumns();

		if (viewLayout instanceof PrimaryViewLayout) {
			return Scopes.scopeFor(columns);
		} else if (viewLayout instanceof MatrixIndexViewLayout) {
			WorksheetTemplateParam ownerParam = ((MatrixIndexViewLayout) viewLayout).getOwner().getSource();
			if (ownerParam == null) {
				return IScope.NULLSCOPE;
			}
			TypedSyncTable ownerTS = ownerParam.getType();
			List<KeyColumn> ownerColumns = ownerTS.getKeyColumns();
			Set<String> ownerColumnNames = new HashSet<String>();
			for (KeyColumn c : ownerColumns) {
				ownerColumnNames.add(c.getName());
			}

			// Lists key columns of the source table schema,
			// except for no key column of the same name is not defined in the matrix table
			// (ownerColumnNames)
			List<Column> result = new ArrayList<Column>(columns.size());
			for (Column c : columns) {
				String name = c.getName();
				if (ownerColumnNames.contains(name)) {
					result.add(c);
				}
			}
			return Scopes.scopeFor(result);
		} else {
			throw new IllegalStateException("Unexpected ViewLayout class: " + viewLayout);
		}
	}

	public IScope scope_SortKey_column(ViewLayout context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_SortKey_column: context=" + context + ", reference=" + reference);
//      }
		EList<ViewColumn> columns = context.getColumns();
		List<ViewColumn> result = new ArrayList<ViewColumn>(columns.size());
		for (ViewColumn c : columns) {
			if (c instanceof MappedViewColumn) {
				result.add((MappedViewColumn) c);
			}
		}
		return Scopes.scopeFor(result);
	}

	public IScope scope_ViewLayout_source(WorksheetTemplate context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_ViewLayout_source: context=" + context + ", reference=" + reference);
//      }
		EList<WorksheetTemplateParam> params = context.getParameters();
		return Scopes.scopeFor(params);
	}

	public IScope scope_MatrixIndexViewLayout_source(WorksheetTemplate context, EReference reference) {
//      if (LOGGER.isDebugEnabled()) {
//          LOGGER.debug("scope_MatrixIndexViewLayout_source: context=" + context + ", reference=" + reference);
//      }
		EList<WorksheetTemplateParam> params = context.getParameters();
		return Scopes.scopeFor(params);
	}

	static String getFeatureName(EObject obj, EStructuralFeature feature) {
		List<INode> nodes = NodeModelUtils.findNodesForFeature(obj, feature);
		INode first = nodes.get(0);
		return NodeModelUtils.getTokenText(first);
	}

	@Inject
	IQualifiedNameProvider qualifiedNameProvider;

	/*
	 * public IScope scope_MappedViewColumn(TableViewLayout context, EReference
	 * reference) { if (LOGGER.isDebugEnabled()) {
	 * LOGGER.debug("scope_MappedViewColumn: context=" + context + ", reference=" +
	 * reference); } List<MappedViewColumn> columns = new
	 * ArrayList<MappedViewColumn>(context.getColumns().size()); for (ViewColumn c :
	 * context.getColumns()) { if (c instanceof MappedViewColumn) {
	 * columns.add((MappedViewColumn) c); } } IScope scope = Scopes.scopeFor(
	 * columns, new Function<MappedViewColumn, QualifiedName>() {
	 * 
	 * @Override public QualifiedName apply(MappedViewColumn from) { return
	 * qualifiedNameProvider.getFullyQualifiedName(from); } }, IScope.NULLSCOPE);
	 * return scope; }
	 * 
	 * public IScope scope_NonkeyViewColumn(MatrixIndexViewLayout context,
	 * EReference reference) { if (LOGGER.isDebugEnabled()) {
	 * LOGGER.debug("scope_NonkeyViewColumn: context=" + context + ", reference=" +
	 * reference); } context.getSource().getSchema();
	 * 
	 * List<NonkeyViewColumn> columns = new
	 * ArrayList<NonkeyViewColumn>(context.getColumns().size()); for (ViewColumn c :
	 * context.getColumns()) { if (c instanceof MappedViewColumn) {
	 * columns.add((MappedViewColumn) c); } } IScope scope = Scopes.scopeFor(
	 * columns, new Function<MappedViewColumn, QualifiedName>() {
	 * 
	 * @Override public QualifiedName apply(MappedViewColumn from) { Column col =
	 * from.getColumn(); if (col != null) { return
	 * QualifiedName.create(col.getName()); } else { return null; } } },
	 * IScope.NULLSCOPE); return scope; }
	 * 
	 * public IScope scope_KeyViewColumn(MatrixIndexViewLayout context, EReference
	 * reference) { if (LOGGER.isDebugEnabled()) {
	 * LOGGER.debug("scope_KeyViewColumn: context=" + context + ", reference=" +
	 * reference); } MatrixViewLayout matrix = context.getOwner();
	 * List<MappedViewColumn> columns = new
	 * ArrayList<MappedViewColumn>(context.getColumns().size()); for (ViewColumn c :
	 * context.getColumns()) { if (c instanceof MappedViewColumn) {
	 * columns.add((MappedViewColumn) c); } } IScope scope = Scopes.scopeFor(
	 * columns, new Function<MappedViewColumn, QualifiedName>() {
	 * 
	 * @Override public QualifiedName apply(MappedViewColumn from) { Column col =
	 * from.getColumn(); if (col != null) { return
	 * QualifiedName.create(col.getName()); } else { return null; } } },
	 * IScope.NULLSCOPE); return scope; }
	 */
	// ---------------------------
	// Scopes for ViewColumnType
	// ---------------------------

	public IScope scope_ViewColumnType_datatype(ViewColumnType vct, EReference reference) {
		return getScopeForEClassifier(vct, null, EClassifier.class);
	}

}
