/*
 * IBM Confidential
 * OCO Source Materials
 * JP720140001D
 * (C) Copyright IBM Corp. 2009
 */
package com.ibm.trinity.dsl;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

import com.google.inject.Inject;
import com.ibm.trinity.syncmodel.MappedViewColumn;
import com.ibm.trinity.syncmodel.SyncModelPackage;
import com.ibm.trinity.syncmodel.SyncTableParam;

public class SyncModelQualifiedNameProvider extends DefaultDeclarativeQualifiedNameProvider {
	
//	public QualifiedName qualifiedName(FieldDef field) {
//		if (field.getName() == null || !(field.eContainer() instanceof PrimitiveViewDecl)) {
//			return null;
//		}
//		String viewName = ((PrimitiveViewDecl) field.eContainer()).getName();
//		QualifiedName qname = QualifiedName.create(viewName, field.getName());
//		System.out.println(qname.toString());
//		return qname;
//	}

	public QualifiedName qualifiedName(SyncTableParam param) {
		List<INode> nodes = NodeModelUtils.findNodesForFeature(param, SyncModelPackage.Literals.SYNC_TABLE_PARAM__OWNER);
		INode first = nodes.get(0);
		String schemaName = NodeModelUtils.getTokenText(first);
//		return converter.toQualifiedName(name);
//		SyncTableSchema schema = param.getSchema();
		QualifiedName qname = QualifiedName.create(schemaName, param.getName());
		return qname;
	}
	
/*	public QualifiedName qualifiedName(ContainerTable table) {
		String parentName = null;
		EObject container = table.eContainer();
		while (container != null) {
			if (container instanceof SyncTableSchema) {
				parentName = ((SyncTableSchema) container).getName();
				break;
			} else if (container instanceof ChainedDataSourceDef) {
				parentName = ((ChainedDataSourceDef) container).getName();
				break;
			}
			container = container.eContainer();
		}
		if (parentName == null) {
			throw new IllegalStateException();
		}
		List<INode> nodes = NodeModelUtils.findNodesForFeature(table, SyncModelPackage.Literals.CONTAINER_TABLE__FOREIGN_TABLE);
		INode first = nodes.get(0);
		String name = NodeModelUtils.getTokenText(first);
//		return QualifiedName.create(parentName, name);
		return QualifiedName.create(name);
//		return getConverter().toQualifiedName(name);

//		ReferrableSyncTable foreignTable = table.getForeignTable();
//		if (foreignTable != null) {
//			return getConverter().toQualifiedName(foreignTable.getName());
//		} else {
//			return null;
//		}
	}*/
	
	protected String getFeatureName(EObject obj, EStructuralFeature feature) {
		List<INode> nodes = NodeModelUtils.findNodesForFeature(obj, feature);
		INode first = nodes.get(0);
		return NodeModelUtils.getTokenText(first);
	}
	
	@Inject
	private IQualifiedNameConverter qualifiedNameConverter;
	
	public QualifiedName qualifiedName(MappedViewColumn viewColumn) {
		String columnName = getFeatureName(viewColumn, SyncModelPackage.Literals.MAPPED_VIEW_COLUMN__COLUMN);
		QualifiedName qname = qualifiedNameConverter.toQualifiedName(columnName);
/*		EObject obj = viewColumn;
		while (obj.eContainer() != null) {
			obj = obj.eContainer();
			QualifiedName parentsQualifiedName = getFullyQualifiedName(obj);
			if (parentsQualifiedName != null)
				return parentsQualifiedName.append(qname);
		}*/
		return qname;
	}

//	public QualifiedName getFullyQualifiedName(final EObject obj) {
//		QualifiedName qname = super.getFullyQualifiedName(obj);
//		System.out.println("getFullyQualifiedName(" + obj.getClass().getName() + ")=" + qname);
//		return qname;
//	}

}
