/*
 * IBM Confidential
 * OCO Source Materials
 * JP720140001D
 * (C) Copyright IBM Corp. 2009
 */
package com.ibm.trinity.dsl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;

public class EClassifierUtil {

	public static Set<EClassifier> getCommonSupertypes(Set<? extends EClassifier> types) {
		// Step 1. Calculates a common set of eAllSuperTypes of all type     
		Set<EClassifier> allSuperTypes = null;
		for (EClassifier t : types) {
			if (t instanceof EClass) {
				EClass c = (EClass) t;
				EList<EClass> superTypes = c.getEAllSuperTypes();
				if (allSuperTypes == null) {
					allSuperTypes = new HashSet<EClassifier>(superTypes);
				} else {
					allSuperTypes.retainAll(superTypes);
				}
			} else {
				if (allSuperTypes == null) {
					allSuperTypes = new HashSet<EClassifier>();
					allSuperTypes.add(t);
				} else {
					allSuperTypes.add(t);
				}
			}
		}
		if (allSuperTypes == null) {
			return Collections.emptySet();
		}
		
		// Step 2. Calculates lower bounds of the set calculated in step 1.
		return removeSupertypes(allSuperTypes);
	}
	
	private static Set<EClassifier> removeSupertypes(Set<EClassifier> types) {
		if (types.size() <= 1) {
			return types;
		}
		
		Set<EClassifier> result = new HashSet<EClassifier>();
		for (EClassifier t : types) {
			if (t instanceof EClass) {
				EClass c = (EClass) t;
				boolean noSuperType = true;
				for (EClassifier other : types) {
					if (other instanceof EClass) {
						if (c != other && c.isSuperTypeOf((EClass) other)) {
							noSuperType = false;
							break;
						}
					}
				}
				if (noSuperType) {
					result.add(c);
				}
			} else {
				result.add(t);
			}
		}
		return result;
	}

}
