Const ID_SEPARATOR As String = ","

Public Function GetRefersToR1C1(sh As Worksheet, rangeName As String) As String
    On Error GoTo NONAME
    sheetRangeName = "'" & sh.Name & "'!" & rangeName
    n = sh.names(rangeName)
    GetRefersToR1C1 = n.RefersToR1C1
NONAME:
    GetRefersToR1C1 = Empty
End Function

Public Sub SetRangeName(sh As Worksheet, topLeft As String, bottomRight As String, rangeName As String)
    Dim r As Range
    
    Set r = sh.Range(topLeft, bottomRight)
    r.Name = "'" & sh.Name & "'!" & rangeName
End Sub

Public Function GetCellIDs(sh As Worksheet, rows() As Integer, cols() As Integer, idIndex As Integer) As Variant
    Dim ids() As String
    
    numCells = UBound(rows) - LBound(rows) + 1
    ReDim ids(numCells)
    
    For i = 0 To numCells - 1
        r = rows(LBound(rows) + i)
        c = cols(LBound(cols) + i)
        ids(LBound(ids) + i) = GetID(sh.Cells(r, c).id, idIndex)
    Next i
    GetCellIDs = ids
End Function

Public Sub SetCellIDs(sh As Worksheet, rows() As Integer, cols() As Integer, ids() As Variant, idIndex As Integer)
    numCells = UBound(rows) - LBound(rows) + 1
    For i = 0 To numCells - 1
        r = rows(LBound(rows) + i)
        c = cols(LBound(cols) + i)
        
        sh.Cells(r, c).id = ReplaceId(sh.Cells(r, c).id, ids(LBound(ids) + i), idIndex)
    Next i
End Sub

Private Function GetID(id As String, idIndex As Integer) As String
    If idIndex >= 0 Then
        Dim ids() As String
        ids = Split(id, ID_SEPARATOR)
        
        If idIndex <= UBound(ids) - LBound(ids) Then
            GetID = ids(idIndex - LBound(ids))
        Else
            GetID = ""
        End If
    Else
        GetID = id
    End If
End Function

Private Function ReplaceId(id As String, newId As Variant, idIndex As Integer) As String
    If idIndex >= 0 Then
        Dim ids() As String
        ids = Split(id, ID_SEPARATOR)
        
        If idIndex <= UBound(ids) - LBound(ids) Then
            ids(idIndex - LBound(ids)) = newId
        Else
            ReDim Preserve ids(idIndex)
            ids(idIndex) = newId
        End If
        ReplaceId = Join$(ids, ID_SEPARATOR)
    Else
        ReplaceId = newId
    End If
End Function


Public Function GetMatrixCellIDs(sh As Worksheet, rowIndices() As Integer, colIndices() As Integer) As Variant
    Dim ids() As String
    
    numRows = UBound(rowIndices) - LBound(rowIndices) + 1
    numCols = UBound(colIndices) - LBound(colIndices) + 1
    numCells = numRows * numCols
    
    ReDim ids(numCells)
    
    x = LBound(ids)
    For i = 0 To numRows - 1
        r = rowIndices(LBound(rowIndices) + i)
        For j = 0 To numCols - 1
            c = colIndices(LBound(colIndices) + j)
            ids(x) = sh.Cells(r, c).id
            x = x + 1
        Next j
    Next i
    GetMatrixCellIDs = ids
End Function

Public Sub ClearCells(sh As Worksheet, rows() As Integer, cols() As Integer, clearMetas() As Boolean)
    Dim numCells As Integer
    Dim r As Range
        
    numCells = UBound(rows) - LBound(rows) + 1
    
    For i = 0 To numCells - 1
        Row = rows(LBound(rows) + i)
        Col = cols(LBound(cols) + i)
        Set r = sh.Cells(Row, Col)
        r.ClearContents
        
        If clearMetas(i) = True Then
            r.ClearComments
            r.id = ""
        End If
    Next i
End Sub

'Unused
Public Function GetCellValues(sh As Worksheet, rowIndices() As Integer, colIndices() As Integer) As Variant
    Dim Values() As Variant
    Dim numIndices As Integer
    Dim Row, Col As Integer
    
    numIndices = UBound(rowIndices) - LBound(rowIndices) + 1
    ReDim Values(numIndices)
    
    For i = 0 To numIndices - 1
        Row = rowIndices(LBound(rowIndices) + i)
        Col = colIndices(LBound(colIndices) + i)
        Values(LBound(Values) + i) = sh.Cells(Row, Col).Value
    Next i
    GetCellValues = Values
End Function

Public Function SetCellValues(sh As Worksheet, rowIndices() As Integer, colIndices() As Integer, Values() As Variant) As Variant
    Dim Updated() As Variant
    Dim numIndices As Integer
    Dim Row, Col As Integer
    Dim r As Range
    
    numIndices = UBound(rowIndices) - LBound(rowIndices) + 1
    
    ReDim Updated(numIndices)
    
    For i = 0 To numIndices - 1
        Row = rowIndices(LBound(rowIndices) + i)
        Col = colIndices(LBound(colIndices) + i)
        Set r = sh.Cells(Row, Col)
        If r.HasFormula Then
            Updated(i) = False
        ElseIf IsEmpty(Values(LBound(Values) + i)) Then
            r.ClearContents
            Updated(i) = True
        Else
            r.Value = Values(LBound(Values) + i)
            Updated(i) = True
        End If
    Next i
    SetCellValues = Updated
End Function

Public Sub SetRangeCellFormat(sh As Worksheet, rows() As Integer, cols() As Integer, _
        numberFormat As String, _
        fontSpecified As Boolean, _
        fontBold As Boolean, fontItalic As Boolean, fontSize As Double, fontColor As Variant, fontName As String, _
        colWidth As Double, rowHeight As Double, _
        hAlign As Integer, vAlign As Integer, _
        orientation As Integer, shrinkToFit As Boolean, wrapText As Boolean, _
        interiorColor() As Variant, interiorPattern() As Integer, interiorPatternColor() As Variant)
    
    Dim numIndices As Integer
    Dim r As Range
    
    numIndices = UBound(rows) - LBound(rows) + 1
    
    For i = 0 To numIndices - 1
        Row = rows(LBound(rows) + i)
        Col = cols(LBound(cols) + i)
        Set r = sh.Cells(Row, Col)
        If Not IsEmpty(numberFormat) And Len(numberFormat) > 0 Then
            r.numberFormat = numberFormat
        End If
        If fontSpecified Then
            With r.Font
                .Bold = fontBold
                .Italic = fontItalic
                If fontSize > 0 Then
                    .Size = fontSize
                End If
            End With
            If Not IsEmpty(fontColor) Then
                r.Font.Color = fontColor
            End If
        End If
        If colWidth > 0 Then
            r.ColumnWidth = colWidth
        End If
        If rowHeight > 0 Then
            r.rowHeight = rowHeight
        End If
        If hAlign <> 0 Then
            r.HorizontalAlignment = hAlign
        End If
        If vAlign <> 0 Then
            r.VerticalAlignment = vAlign
        End If
        If orientation <> 0 Then
            r.orientation = orientation
        End If
        r.shrinkToFit = shrinkToFit
        r.wrapText = wrapText
        If Not IsEmpty(interiorColor) Then
            numInteriors = UBound(interiorColor) - LBound(interiorColor) + 1
            For n = 0 To numInteriors - 1
                c = interiorColor(LBound(interiorColor) + n)
                pat = interiorPattern(LBound(interiorPattern) + n)
                patCol = interiorPatternColor(LBound(interiorPatternColor) + n)
                If Not IsEmpty(c) Then
                    r.Interior.Color = c
                End If
                If Not IsEmpty(patCol) Then
                    Debug.Print "interiorPatternColor=" & patCol
                    r.Interior.PatternColor = patCol
                End If
                'If Not IsEmpty(pat) Then
                'End If
            Next n
        End If
    Next i
    
End Sub

Public Sub SetStyle(sh As Worksheet, topLeft As String, bottomRight As String, _
    borderIndices() As XlBordersIndex, _
    lineStyles() As XlLineStyle, weight() As XlBorderWeight)

    Dim r As Range
    Dim b As Border
    
    Set r = sh.Range(topLeft, bottomRight)
    
    numBorders = UBound(borderIndices) - LBound(borderIndices) + 1
    
    For n = 0 To numBorders - 1
        Set b = r.Borders(borderIndices(n))
        If Not IsEmpty(lineStyles(n)) Then
            b.LineStyle = lineStyles(n)
            If Not lineStyles(n) = xlLineStyleNone And Not IsEmpty(weight(n)) Then
                b.weight = weight(n)
            End If
        End If
    Next n
    
End Sub


