/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class StereotypeUtil {
    public static Logger LOGGER = Logger.getLogger(StereotypeUtil.class);
    public static final String ATTACHED_FILE = "UML Standard Profile::MagicDraw Profile::AttachedFile";
    public static final String BINDING_CONNECTOR = "SysML::Blocks::BindingConnector";
    public static final String BLOCK = "SysML::Blocks::Block";
    public static final String CONSTRAINT_BLOCK = "SysML::ConstraintBlocks::ConstraintBlock";
    public static final String CONSTRAINT_PARAMETER = "MD Customization for SysML::additional_stereotypes::ConstraintParameter";
    public static final String CONSTRAINT_PROPERTY = "MD Customization for SysML::additional_stereotypes::deprecated elements::ConstraintProperty";
    public static final String NESTED_CONNECTOR_END = "SysML::Blocks::NestedConnectorEnd";
    public static final String PART_PROPERTY_STEREOTYPE = "MD Customization for SysML::additional_stereotypes::PartProperty";
    public static final String PROPERTY_PROPERTY_STEREOTYPE = "SysML::Blocks::ElementPropertyPath::propertyPath";
    public static final String VALUE_PROPERTY_STEREOTYPE = "MD Customization for SysML::additional_stereotypes::ValueProperty";
    public static final String REFERENCE_PROPERTY_STEREOTYPE = "MD Customization for SysML::additional_stereotypes::ReferenceProperty";
    public static final String MBPLE_FEATURE_STEREOTYPE = "MBPLE Profile::Feature";
    public static final String EXISTENCE_VARIATION_POINT_STEREOTYPE = "MBPLE Profile::ExistenceVariationPoint";
    public static final String INVISIBLE_STEREOTYPE = "UML Standard Profile::MagicDraw Profile::InvisibleStereotype";
    public static final String FEATURE_IMPACT_STEREOTYPE = "MBPLE Profile::FeatureImpact";
    public static final String IMPACTED_VARIATION_POINTS_SLOT_DF_QNAME = "MBPLE Profile::FeatureImpact::impactedVariationPoints";
    public static final String FEATURE_IMPACTS_SLOT_DF_QNAME = "MBPLE Profile::VariationPoint::featureImpacts";
    private static StereoTypeStrategy STRATEGY;

    private StereotypeUtil(MPBaseAdapter adapter, StereoTypeStrategy stereoTypeStrategy) {
        STRATEGY = stereoTypeStrategy;
    }

    public static void init(StereoTypeStrategy strategy) {
        STRATEGY = strategy;
    }

    @Deprecated
    public static EObject addStereotype(MPBaseAdapter adapter, EObject eo, String qName) throws MPException {
        Objects.requireNonNull(STRATEGY, "Please init this class before call the Stereotype");
        return STRATEGY.addStereotype((TwcAdapter)adapter, eo, qName);
    }

    public static EObject addStereotype(EObject eo, String qName) throws MPException {
        Objects.requireNonNull(STRATEGY, "Please init this class before call the Stereotype");
        return STRATEGY.addStereotype(eo, qName);
    }

    @Deprecated
    public static void addStereotypes(MPBaseAdapter adapter, EObject eo, String[] qNames) throws MPException {
        Objects.requireNonNull(STRATEGY, "Please init this class before call the Stereotype");
        STRATEGY.addStereotypes((TwcAdapter)adapter, eo, qNames);
    }

    public static void addStereotypes(EObject eo, String[] qNames) throws MPException {
        Objects.requireNonNull(STRATEGY, "Please init this class before call the Stereotype");
        STRATEGY.addStereotypes(eo, qNames);
    }

    public static List<EObject> getStereotypes(EObject eo) {
        return STRATEGY.getStereotypes(eo);
    }

    public static EObject hasStereotype(EObject eObj, String qName) {
        Objects.requireNonNull(STRATEGY, "Please init this class before call the Stereotype");
        return STRATEGY.getStereotype(eObj, qName);
    }

    protected static boolean hasAttachFileStereotype(EObject eObject) {
        return StereotypeUtil.hasStereotype(eObject, ATTACHED_FILE) != null;
    }

    public static boolean isConstraintBlock(EObject block) {
        EObject st = Util.isInstanceOf((Object)block, (EClass)M2Element.Class) ? StereotypeUtil.hasStereotype(block, CONSTRAINT_BLOCK) : null;
        return st != null;
    }

    public static boolean isBlock(EObject block) {
        EObject st = Util.isInstanceOf((Object)block, (EClass)M2Element.Class) ? StereotypeUtil.hasStereotype(block, BLOCK) : null;
        return st != null;
    }

    public static boolean isConstraintParameter(EObject param) {
        EObject st = StereotypeUtil.hasStereotype(param, CONSTRAINT_PARAMETER);
        return st != null;
    }

    public static boolean isConstraintProperty(EObject prop) {
        EObject st = Util.isInstanceOf((Object)prop, (EClass)M2Element.Property) ? StereotypeUtil.hasStereotype(prop, CONSTRAINT_PROPERTY) : null;
        return st != null;
    }

    public static boolean isPartProperty(EObject prop) {
        if (prop == null) {
            return false;
        }
        EObject st = Util.isInstanceOf((Object)prop, (EClass)M2Element.Property) ? StereotypeUtil.hasStereotype(prop, PART_PROPERTY_STEREOTYPE) : null;
        return st != null;
    }

    public static boolean isValueProperty(EObject prop) {
        EObject st = Util.isInstanceOf((Object)prop, (EClass)M2Element.Property) ? StereotypeUtil.hasStereotype(prop, VALUE_PROPERTY_STEREOTYPE) : null;
        return st != null;
    }

    public static void setBindingConnector(MPBaseAdapter adapter, EObject c) throws MPException {
        StereotypeUtil.addStereotype(adapter, c, BINDING_CONNECTOR);
    }

    public static void setReferencePropertyStereoType(MPBaseAdapter adapter, EObject eObject) throws MPException {
        StereotypeUtil.addStereotype(adapter, eObject, REFERENCE_PROPERTY_STEREOTYPE);
    }

    public static boolean isMbpleFeature(EObject prop) {
        EObject st = Util.isInstanceOf((Object)prop, (EClass)M2Element.Property) ? StereotypeUtil.hasStereotype(prop, MBPLE_FEATURE_STEREOTYPE) : null;
        return st != null;
    }

    public static String getStereotypeNames(EObject element) {
        return StereotypeUtil.getStereotypes(element).stream().map(e -> (String)e.eGet(M2Element.NamedElement$qualifiedName)).collect(Collectors.joining(","));
    }

    public static interface StereoTypeStrategy {
        public EObject getStereotype(EObject var1, String var2);

        public List<EObject> getStereotypes(EObject var1);

        default public List<EObject> getAllStereotypes(TwcAdapter adapter) {
            return ((TwcResource)adapter.getResource()).getStereotypes();
        }

        default public EObject getModelStereotype(TwcAdapter adapter, String qName) {
            return ((TwcResource)adapter.getResource()).getStereotype(qName);
        }

        @Deprecated
        public EObject addStereotype(TwcAdapter var1, EObject var2, String var3);

        public EObject addStereotype(EObject var1, String var2);

        @Deprecated
        public void addStereotypes(TwcAdapter var1, EObject var2, String[] var3);

        public void addStereotypes(EObject var1, String[] var2);
    }

    public static class Stereotype2021
    implements StereoTypeStrategy {
        private final TwcAdapter adapter;

        public Stereotype2021(TwcAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public EObject getStereotype(EObject element, String qName) {
            if (qName == null) {
                return null;
            }
            EObject st = this.getModelStereotype(this.adapter, qName);
            if (st == null) {
                return null;
            }
            List stereotypes = Util.getEList((EObject)element, (EStructuralFeature)TwcConstants.Element$appliedStereotype);
            if (stereotypes == null) {
                return null;
            }
            if (stereotypes.contains(st)) {
                return st;
            }
            return null;
        }

        @Override
        public List<EObject> getStereotypes(EObject element) {
            if (element == null) {
                return Collections.emptyList();
            }
            List stereotypes = Util.getEList((EObject)element, (EStructuralFeature)TwcConstants.Element$appliedStereotype);
            if (stereotypes == null || stereotypes.isEmpty()) {
                return Collections.emptyList();
            }
            return new BasicEList((Collection)stereotypes);
        }

        @Override
        @Deprecated
        public EObject addStereotype(TwcAdapter adapter, EObject element, String qName) {
            if (!Util.isInstanceOf((Object)element, (EClass)M2Element.Element)) {
                return null;
            }
            EObject st = this.getModelStereotype(adapter, qName);
            if (st == null) {
                return null;
            }
            List stereotypes = Util.getEList((EObject)element, (EStructuralFeature)TwcConstants.Element$appliedStereotype);
            if (stereotypes.contains(st)) {
                return null;
            }
            adapter.doAdd(element, TwcConstants.Element$appliedStereotype, st);
            return st;
        }

        @Override
        public EObject addStereotype(EObject element, String qName) {
            if (!Util.isInstanceOf((Object)element, (EClass)M2Element.Element)) {
                return null;
            }
            EObject st = this.getModelStereotype(this.adapter, qName);
            if (st == null) {
                return null;
            }
            List stereotypes = Util.getEList((EObject)element, (EStructuralFeature)TwcConstants.Element$appliedStereotype);
            if (stereotypes.contains(st)) {
                return null;
            }
            this.adapter.doAdd(element, TwcConstants.Element$appliedStereotype, st);
            return st;
        }

        @Override
        @Deprecated
        public void addStereotypes(TwcAdapter adapter, EObject eo, String[] qNames) {
            for (String qName : qNames) {
                this.addStereotype(adapter, eo, qName);
            }
        }

        @Override
        public void addStereotypes(EObject eo, String[] qNames) {
            for (String qName : qNames) {
                this.addStereotype(eo, qName);
            }
        }
    }

    public static class Stereotype19
    implements StereoTypeStrategy {
        private final TwcAdapter adapter;

        public Stereotype19(TwcAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public EObject getStereotype(EObject element, String qName) {
            if (qName == null) {
                return null;
            }
            EObject st = this.getModelStereotype(this.adapter, qName);
            if (st == null) {
                return null;
            }
            List<EObject> classifiers = this.getStereotypes(element);
            if (classifiers.contains(st)) {
                return st;
            }
            return null;
        }

        @Override
        public List<EObject> getStereotypes(EObject element) {
            if (element == null) {
                return Collections.emptyList();
            }
            EObject instanceSpecification = (EObject)element.eGet(TwcConstants.Element$appliedStereotypeInstance);
            if (instanceSpecification == null) {
                return Collections.emptyList();
            }
            List classifiers = Util.getEList((EObject)instanceSpecification, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
            if (classifiers == null) {
                return Collections.emptyList();
            }
            return new BasicEList((Collection)classifiers);
        }

        @Override
        @Deprecated
        public EObject addStereotype(TwcAdapter adapter, EObject eo, String qName) {
            if (!Util.isInstanceOf((Object)eo, (EClass)M2Element.Element)) {
                return null;
            }
            EObject st = this.getModelStereotype(adapter, qName);
            if (st == null) {
                return null;
            }
            EObject is = this.getInstanceSpecification(eo);
            List stereotypes = Util.getEList((EObject)is, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
            if (stereotypes.contains(st)) {
                return st;
            }
            adapter.doAdd(is, TwcConstants.InstanceSpecification$classifier, st);
            return st;
        }

        @Override
        public EObject addStereotype(EObject eo, String qName) {
            if (!Util.isInstanceOf((Object)eo, (EClass)M2Element.Element)) {
                return null;
            }
            EObject st = this.getModelStereotype(this.adapter, qName);
            if (st == null) {
                return null;
            }
            EObject is = this.getInstanceSpecification(eo);
            List stereotypes = Util.getEList((EObject)is, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
            if (stereotypes.contains(st)) {
                return st;
            }
            this.adapter.doAdd(is, TwcConstants.InstanceSpecification$classifier, st);
            return st;
        }

        @Override
        @Deprecated
        public void addStereotypes(TwcAdapter adapter, EObject eo, String[] qNames) {
            if (!Util.isInstanceOf((Object)eo, (EClass)M2Element.Element)) {
                return;
            }
            EObject is = this.getInstanceSpecification(eo);
            for (String qName : qNames) {
                this.addStereotype(adapter, is, qName);
            }
        }

        @Override
        public void addStereotypes(EObject eo, String[] qNames) {
            if (!Util.isInstanceOf((Object)eo, (EClass)M2Element.Element)) {
                return;
            }
            EObject is = this.getInstanceSpecification(eo);
            for (String qName : qNames) {
                this.addStereotype(is, qName);
            }
        }

        private EObject getInstanceSpecification(EObject eo) {
            EObject is = null;
            if (!Util.isInstanceOf((Object)eo, (EClass)TwcConstants.InstanceSpecification)) {
                is = (EObject)eo.eGet(TwcConstants.Element$appliedStereotypeInstance);
                if (is == null) {
                    is = Util.instantiateEClass((EClass)TwcConstants.InstanceSpecification);
                    this.adapter.doSet(eo, TwcConstants.Element$appliedStereotypeInstance, is, null);
                }
            } else {
                is = eo;
            }
            return is;
        }
    }
}

