/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import com.maplesoft.maplembse.special.twc.adapter.mpm.ElementUtil;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.modifier.MPAbstractNotificationModifier;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMSlotValue
extends MPAbstractModifier {
    public static final Logger LOGGER = Logger.getLogger(MPMSlotValue.class);

    public MPMSlotValue(MPBaseAdapter adapter) throws MPException {
        super(adapter);
    }

    public EModelElement getModificationCriteria() {
        return TwcPackage.eINSTANCE.getTwcClass_SlotValue();
    }

    public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
        if (!Util.isInstanceOf((Object)eobj, (EClass)TwcConstants.Slot)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eobj);
        }
        List values = Util.getEList((EObject)eobj, (EStructuralFeature)TwcConstants.Slot$value);
        if (values.isEmpty()) {
            return "";
        }
        EObject value = (EObject)values.get(0);
        ValueSpecificationStrategy strategy = ValueSpecificationStrategy.getStrategy(value);
        return strategy.getValue(this.adapter, value);
    }

    public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
        ValueSpecificationStrategy strategy;
        EObject valueSpecification;
        if (!Util.isInstanceOf((Object)eObj, (EClass)TwcConstants.Slot)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eObj);
        }
        EObject definingFeature = (EObject)eObj.eGet(TwcConstants.Slot$definingFeature);
        if (!Util.isInstanceOf((Object)definingFeature, (EClass)M2Element.StructuralFeature)) {
            throw new MPInvalidException("Slot must set a defining feature before adding the feature " + feature);
        }
        String str = null;
        if (value instanceof String) {
            str = (String)value;
            str = str.trim();
        }
        if (str == null || str.isEmpty()) {
            List values = Util.getEList((EObject)eObj, (EStructuralFeature)TwcConstants.Slot$value);
            if (values.size() <= 1) {
                this.adapter.delete(eObj);
            } else {
                this.doRemove(eObj, TwcConstants.Slot$value, values.get(0));
            }
            return;
        }
        if (!(value instanceof String)) {
            throw new MPInvalidException("Invalid for value type for" + value);
        }
        List values = Util.getEList((EObject)eObj, (EStructuralFeature)TwcConstants.Slot$value);
        if (values.isEmpty()) {
            if (oldValue != null && ((String)oldValue).isEmpty()) {
                oldValue = null;
            }
            valueSpecification = this.addSlotValue(eObj);
            strategy = ValueSpecificationStrategy.getStrategy(valueSpecification);
            str = strategy.sanitizeString(str, definingFeature);
        } else {
            valueSpecification = (EObject)values.get(0);
            strategy = ValueSpecificationStrategy.getStrategy(valueSpecification);
        }
        strategy.addValue(this.adapter, valueSpecification, definingFeature, str, oldValue);
    }

    private EObject addSlotValue(EObject slot) throws MPException {
        EObject definingFeature = (EObject)slot.eGet(TwcConstants.Slot$definingFeature);
        EObject valueSpecification = null;
        if (StereotypeUtil.isPartProperty(definingFeature)) {
            valueSpecification = Util.instantiateEClass((EClass)TwcConstants.InstanceValue);
        } else {
            valueSpecification = ElementUtil.createValueSpecification(definingFeature, this.adapter);
            if (valueSpecification == null && ElementUtil.isAttachment(definingFeature)) {
                valueSpecification = Util.instantiateEClass((EClass)TwcConstants.ElementValue);
            }
        }
        this.doAdd(slot, TwcConstants.Slot$value, valueSpecification, -1);
        return valueSpecification;
    }

    private static boolean NotNullCheck(Object oldValue) {
        return oldValue != null && !oldValue.toString().isEmpty();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ValueSpecificationStrategy implements UtilityCommands
    {
        LITERAL_BOOLEAN(M2Element.LiteralBoolean, M2Element.LiteralBoolean$value, "false"){

            @Override
            public Object castValue(String str) throws MPInvalidException {
                if (!"true".equalsIgnoreCase(str) && !"false".equalsIgnoreCase(str)) {
                    throw new MPInvalidException("unable to convert string " + str + " to boolean");
                }
                return Boolean.valueOf(str);
            }
        }
        ,
        LITERAL_INTEGER(M2Element.LiteralInteger, M2Element.LiteralInteger$value, "0"){

            @Override
            public Object castValue(String str) throws MPInvalidException {
                try {
                    return Integer.valueOf(str.split("\\.")[0]);
                }
                catch (Exception e) {
                    throw new MPInvalidException("unable to convert string " + str + " to Integer");
                }
            }
        }
        ,
        LITERAL_REAL(M2Element.LiteralReal, M2Element.LiteralReal$value, "0.0"){

            @Override
            public Object castValue(String str) throws MPInvalidException {
                try {
                    return Double.valueOf(str);
                }
                catch (Exception e) {
                    throw new MPInvalidException("unable to convert string " + str + " to double");
                }
            }
        }
        ,
        LITERAL_STRING(M2Element.LiteralString, M2Element.LiteralString$value, ""),
        LITERAL_UNLIMITED_NATURAL(M2Element.LiteralUnlimitedNatural, M2Element.LiteralUnlimitedNatural$value, "0"){

            @Override
            public Object castValue(String str) throws MPInvalidException {
                return LITERAL_INTEGER.castValue(str);
            }
        }
        ,
        ELEMENT_VALUE(TwcConstants.ElementValue, TwcConstants.ElementValue$element, ""){

            @Override
            public String getValue(MPBaseAdapter adapter, EObject value) {
                MPMSlotValue.addNotificationModifier((Notifier)((Notifier)value), (MPNotificationModifier)this.getModifier());
                EObject element = (EObject)value.eGet(TwcConstants.ElementValue$element);
                if (element == null) {
                    return "Invaild Attachment";
                }
                try {
                    return (String)adapter.get(element, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_AttachedFile());
                }
                catch (MPException e) {
                    return "";
                }
            }

            @Override
            public void addValue(MPBaseAdapter adapter, EObject valueSpecification, EObject definingFeature, String str, Object oldValue) throws MPInvalidException {
                String attachmentFileSelection;
                TwcResource twcResource = (TwcResource)adapter.getResource();
                EObject modelFile = twcResource.fileSearchAndGetObject(attachmentFileSelection = twcResource.attachmentFileSelection(str));
                if (modelFile == null) {
                    String message = "Unable to find the file please type again please delete the slot manually";
                    LOGGER.error((Object)message);
                    throw new MPInvalidException(message);
                }
                adapter.doSet(valueSpecification, this.getFeature(), (Object)modelFile, valueSpecification.eGet(this.getFeature()));
            }
        }
        ,
        INSTANCE_VALUE(TwcConstants.InstanceValue, TwcConstants.InstanceValue$instance, ""){

            @Override
            public String getValue(MPBaseAdapter adapter, EObject value) {
                MPMSlotValue.addNotificationModifier((Notifier)((Notifier)value), (MPNotificationModifier)this.getModifier());
                EObject instance = (EObject)value.eGet(TwcConstants.InstanceValue$instance);
                if (instance != null) {
                    if (Util.isInstanceOf((Object)instance, (EClass)M2Element.EnumerationLiteral) && Util.isInstanceOf((Object)instance.eContainer(), (EClass)M2Element.Enumeration)) {
                        Optional<String> opt = Util.getEList((EObject)instance.eContainer(), (EStructuralFeature)M2Element.Enumeration$ownedLiteral).stream().map(e -> (String)e.eGet(M2Element.NamedElement$name)).reduce((r, c) -> r + "," + c);
                        String enumValues = opt.isPresent() ? opt.get() : "";
                        String enumValue = (String)instance.eGet(M2Element.NamedElement$name);
                        return String.format("enum:%s\ncurrent:%s", enumValues, enumValue);
                    }
                    return (String)instance.eGet(M2Element.NamedElement$qualifiedName);
                }
                EObject prop = (EObject)value.eContainer().eGet(TwcConstants.Slot$definingFeature);
                if (prop == null || Util.isInstanceOf((Object)prop.eGet(M2Element.TypedElement$type), (EClass)M2Element.Enumeration)) {
                    return "Invalid Enumeration";
                }
                return "";
            }

            @Override
            public String sanitizeString(String str, EObject definingFeature) throws MPException {
                String value = str;
                EObject type = (EObject)definingFeature.eGet(M2Element.TypedElement$type);
                EObject defaultValue = (EObject)definingFeature.eGet(M2Element.Property$defaultValue);
                List values = new ArrayList();
                if (StereotypeUtil.isPartProperty(definingFeature)) {
                    return str;
                }
                if (Util.isInstanceOf((Object)type, (EClass)M2Element.Enumeration)) {
                    values = Util.getEList((EObject)type, (EStructuralFeature)M2Element.Enumeration$ownedLiteral);
                } else if (defaultValue != null && Util.isInstanceOf((Object)defaultValue, (EClass)M2Element.InstanceValue)) {
                    EObject _enum = (EObject)((EObject)defaultValue.eGet(M2Element.InstanceValue$instance)).eGet(M2Element.EnumerationLiteral$enumeration);
                    values.addAll(Util.getEList((EObject)_enum, (EStructuralFeature)M2Element.Enumeration$ownedLiteral));
                } else {
                    LOGGER.error((Object)"EnumerationLiteral is not valid");
                    throw new MPInvalidException("EnumerationLiteral is not valid");
                }
                if (values.isEmpty()) {
                    LOGGER.error((Object)"EnumerationLiteral is not valid");
                    throw new MPInvalidException("EnumerationLiteral is not valid");
                }
                Optional<EObject> eObject = values.stream().filter(s -> s.eGet(M2Element.NamedElement$name).equals(value)).findFirst();
                if (!eObject.isPresent() && !values.isEmpty()) {
                    str = (String)((EObject)values.get(0)).eGet(M2Element.NamedElement$name);
                }
                return str;
            }

            private void addEnumeration(MPBaseAdapter adapter, EObject valueSpecification, EObject enumType, String str) throws MPInvalidException {
                assert (str != null && !str.isEmpty());
                Object oldValue = valueSpecification.eGet(this.getFeature());
                List values = Util.getEList((EObject)enumType, (EStructuralFeature)M2Element.Enumeration$ownedLiteral);
                Optional<EObject> enumValue = values.stream().filter(s -> s.eGet(M2Element.NamedElement$name).equals(str)).findFirst();
                if (!enumValue.isPresent()) {
                    throw new MPInvalidException("The slot vlaue " + str + " not found in the model");
                }
                adapter.doSet(valueSpecification, this.getFeature(), (Object)enumValue.get(), oldValue);
            }

            @Override
            public void addValue(MPBaseAdapter adapter, EObject valueSpecification, EObject definingFeature, String str, Object oldValue) throws MPInvalidException {
                EObject defaultInstance;
                if (Util.isInstanceOf((Object)definingFeature.eGet(M2Element.TypedElement$type), (EClass)M2Element.Enumeration)) {
                    EObject enumType = (EObject)definingFeature.eGet(M2Element.TypedElement$type);
                    this.addEnumeration(adapter, valueSpecification, enumType, str);
                    return;
                }
                Object defaultValue = definingFeature.eGet(M2Element.Property$defaultValue);
                if (Util.isInstanceOf((Object)defaultValue, (EClass)TwcConstants.InstanceValue) && Util.isInstanceOf((Object)(defaultInstance = (EObject)((EObject)defaultValue).eGet(TwcConstants.InstanceValue$instance)), (EClass)M2Element.EnumerationLiteral)) {
                    EObject enumType = defaultInstance.eContainer();
                    this.addEnumeration(adapter, valueSpecification, enumType, str);
                    return;
                }
                if (!StereotypeUtil.isPartProperty(definingFeature)) {
                    throw new UnsupportedOperationException("doesn't support other model element");
                }
                EObject instance = ElementUtil.getEObjectByQualifiedName(str, ((TwcResource)adapter.getResource()).getModel());
                if (!Util.isInstanceOf((Object)instance, (EClass)TwcConstants.InstanceSpecification)) {
                    String msg = str + " not a found as a valid reference to an InstanceSpecification";
                    LOGGER.info((Object)msg);
                    throw new MPInvalidException(msg);
                }
                if (!Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier).contains(definingFeature.eGet(M2Element.TypedElement$type))) {
                    String msg = "The instances " + str + " is not a valid type for this reference.";
                    LOGGER.info((Object)msg);
                    throw new MPInvalidException(msg);
                }
                adapter.doSet(valueSpecification, TwcConstants.InstanceValue$instance, (Object)instance, valueSpecification.eGet(TwcConstants.InstanceValue$instance));
            }
        }
        ,
        LITERAL_NULL(M2Element.LiteralNull, M2Element.NamedElement$name, null){

            @Override
            public String getValue(MPBaseAdapter adapter, EObject value) {
                return "";
            }

            @Override
            public void addValue(MPBaseAdapter adapter, EObject valueSpecification, EObject definingFeature, String str, Object oldValue) {
                throw new UnsupportedOperationException("Not supported data-type");
            }
        };

        private final EClass eClass;
        private final EStructuralFeature feature;
        private final MPNotificationModifier modifier;
        private final String defaultValue;

        private ValueSpecificationStrategy(EClass eClass, EStructuralFeature feature, String defaultValue) {
            this.eClass = eClass;
            this.feature = feature;
            this.defaultValue = defaultValue;
            this.modifier = new MPAbstractNotificationModifier(feature){

                protected void changed(Object obj, Notification msg, boolean isAdded) {
                    EObject valueSpecification = (EObject)msg.getNotifier();
                    EObject owner = valueSpecification.eContainer();
                    if (Util.isInstanceOf((Object)owner, (EClass)TwcConstants.Slot)) {
                        this.send(owner, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_SlotValue(), obj, isAdded);
                    } else if (Util.isInstanceOf((Object)owner, (EClass)M2Element.Property)) {
                        this.send(owner, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_PropertyDefaultValue(), obj, isAdded);
                    }
                }
            };
        }

        static ValueSpecificationStrategy getStrategy(EObject value) {
            for (ValueSpecificationStrategy e : ValueSpecificationStrategy.values()) {
                if (!Util.isInstanceOf((Object)value, (EClass)e.eClass)) continue;
                return e;
            }
            return LITERAL_NULL;
        }

        @Override
        public MPNotificationModifier getModifier() {
            return this.modifier;
        }

        @Override
        public EStructuralFeature getFeature() {
            return this.feature;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }

    private static interface UtilityCommands {
        default public String getValue(MPBaseAdapter adapter, EObject value) {
            MPMSlotValue.addNotificationModifier((Notifier)((Notifier)value), (MPNotificationModifier)this.getModifier());
            Object tmp = value.eGet(this.getFeature());
            return String.valueOf(tmp);
        }

        default public void addValue(MPBaseAdapter adapter, EObject valueSpecification, EObject definingFeature, String str, Object oldValue) throws MPInvalidException {
            if (MPMSlotValue.NotNullCheck(oldValue)) {
                oldValue = this.castValue((String)oldValue);
            }
            Object b = this.castValue(str);
            adapter.doSet(valueSpecification, this.getFeature(), b, oldValue);
        }

        default public Object castValue(String str) throws MPInvalidException {
            return str;
        }

        default public String sanitizeString(String str, EObject definingFeature) throws MPException {
            try {
                return this.castValue(str).toString();
            }
            catch (Exception e) {
                return this.getDefaultValue();
            }
        }

        public MPNotificationModifier getModifier();

        public EStructuralFeature getFeature();

        public String getDefaultValue();
    }
}

