/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.common.models.MSEPackage;
import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.dialog.SharedInstanceDialog;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialogManager;
import com.maplesoft.maplembse.special.twc.adapter.mpm.ElementUtil;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.modifier.MPAbstractNotificationModifier;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMShareInstance {
    public static Logger LOGGER = Logger.getLogger(MPMShareInstance.class);

    public static class ShareInstance
    extends MPAbstractModifier {
        ShareInstanceNotification shareInstanceNM;
        private String nameWithSquareAndNumber;
        final Pattern pattern;

        public ShareInstance(MPBaseAdapter adapter) throws MPException {
            super(adapter);
            this.shareInstanceNM = new ShareInstanceNotification((TwcAdapter)this.adapter);
            this.nameWithSquareAndNumber = "\\[[0-9]\\]$";
            this.pattern = Pattern.compile(this.nameWithSquareAndNumber);
        }

        public EModelElement getModificationCriteria() {
            return MSEPackage.eINSTANCE.getInternalClass_ShareInstance();
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj;
        }

        private EObject getInstanceToShare(EObject instance, List<String> path) throws MPException {
            List instanceClassifier = Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
            if (instanceClassifier.isEmpty()) {
                throw new MPInvalidException("Instance doesn't have a classifier. Please check the instance " + instance);
            }
            EObject topBlock = (EObject)instanceClassifier.get(0);
            EObject block = null;
            block = this.getSharingInstanceClassifier(topBlock, this.removeIndexesFromPath(path));
            if (block == null) {
                throw new MPInvalidException("Unable to find the classifier for the instance to share");
            }
            List classifierInstances = Util.getEList((EObject)block, (EStructuralFeature)TwcConstants.Classifier$_instanceSpecificationOfClassifier);
            HashMap<String, EObject> availableInstances = new HashMap<String, EObject>();
            for (EObject eObject : classifierInstances) {
                String name = (String)eObject.eGet(M2Element.NamedElement$qualifiedName);
                if (availableInstances.containsKey(name)) continue;
                availableInstances.put(name, eObject);
            }
            SharedInstanceDialog instanceDialog = new SharedInstanceDialog(availableInstances);
            try {
                TwcDialogManager dManager = new TwcDialogManager();
                dManager.open(instanceDialog, null);
            }
            catch (Throwable e) {
                LOGGER.error((Object)e);
            }
            EObject dinstance = instanceDialog.getSelection();
            return dinstance;
        }

        private List<String> removeIndexesFromPath(List<String> path) {
            ArrayList<String> tmpValue = new ArrayList<String>();
            tmpValue.addAll(path);
            for (int i = 0; i < tmpValue.size(); ++i) {
                String s = (String)tmpValue.get(i);
                if (!this.pattern.matcher(s).find()) continue;
                s = s.replaceAll(this.nameWithSquareAndNumber, "");
                tmpValue.set(i, s);
            }
            return tmpValue;
        }

        private EObject getSharingInstanceClassifier(EObject topBlock, List<String> tmpValue) {
            Stack<Object> needToVisit = new Stack<Object>();
            needToVisit.add(topBlock);
            EObject block = null;
            block0: for (int i = 0; i < tmpValue.size() - 1; ++i) {
                while (!needToVisit.isEmpty()) {
                    EObject tmp1 = (EObject)needToVisit.pop();
                    String name = (String)tmp1.eGet(M2Element.NamedElement$name);
                    if (!tmpValue.get(i).equals(name)) continue;
                    List cls = ElementUtil.getAllPropertiesFromBlock(tmp1).stream().filter(p -> StereotypeUtil.isPartProperty(p) || StereotypeUtil.isMbpleFeature(p)).map(p -> (EObject)p.eGet(M2Element.TypedElement$type)).collect(Collectors.toList());
                    needToVisit.clear();
                    needToVisit.addAll(cls);
                    block = tmp1;
                    continue block0;
                }
            }
            return block;
        }

        public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
            int i;
            if (!Util.isInstanceOf((Object)eObj, (EClass)TwcConstants.InstanceSpecification) || !(value instanceof List)) {
                return;
            }
            EObject instance = eObj;
            List<String> path = (List<String>)value;
            EObject instancetoShare = this.getInstanceToShare(instance, path = path.stream().filter(Objects::nonNull).collect(Collectors.toList()));
            if (instancetoShare == null) {
                LOGGER.error((Object)"Instance is not shared or user canceled the operation");
                return;
            }
            for (i = 1; i < path.size() - 2 && instance != null; ++i) {
                String instanceMatchesIndex = path.get(i);
                EObject tmp = ElementUtil.findInstanceSpecification(instance, instanceMatchesIndex);
                if (tmp == null) {
                    tmp = this.createInstance(instance, instanceMatchesIndex);
                }
                instance = tmp;
            }
            while (i < path.size() - 1 && instance != null) {
                EObject tmp;
                String blockName = path.get(i);
                int count = 0;
                if (this.pattern.matcher(blockName).find()) {
                    String[] split = blockName.split("\\[");
                    count = Integer.valueOf(split[1].split("\\]")[0]);
                }
                if ((tmp = ElementUtil.findInstanceSpecification(instance, blockName)) != null) {
                    TwcAdapter.getDialogManager().messageBox("Please unshare the existing instance", 33);
                } else if (tmp == null) {
                    tmp = this.shareInstance(instance, this.getPartProperty(instance, blockName.replaceAll(this.nameWithSquareAndNumber, "")), instancetoShare, count, blockName);
                    break;
                }
                ++i;
            }
        }

        private EObject createInstance(EObject instance, String name) throws MPException {
            String[] split = name.split("\\[");
            String nameBeforeIndex = split[0];
            EObject classifier = (EObject)Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier).get(0);
            List blocks = (List)this.adapter.get(classifier, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_RecursivePartProperties());
            Optional<EObject> block = blocks.stream().filter(b -> nameBeforeIndex.equals(b.eGet(M2Element.NamedElement$name))).findFirst();
            assert (block.isPresent());
            Optional<EObject> definingFeature = ElementUtil.getAllPropertiesFromBlock(classifier).stream().filter(p -> StereotypeUtil.isPartProperty(p) || StereotypeUtil.isMbpleFeature(p)).filter(p -> ((EObject)block.get()).equals(p.eGet(M2Element.TypedElement$type))).findFirst();
            assert (definingFeature.isPresent());
            Optional<EObject> oSlot = Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$slot).stream().filter(s -> ((EObject)definingFeature.get()).equals(s.eGet(TwcConstants.Slot$definingFeature))).findFirst();
            EObject slot = null;
            slot = oSlot.isPresent() ? oSlot.get() : Util.instantiateEClass((EClass)TwcConstants.Slot);
            assert (slot != null);
            if (split.length > 1) {
                int count = Integer.valueOf(split[1].split("\\]")[0]);
                int currentNumber = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value).size();
                this.createEmptyInstances(slot, currentNumber, count, instance, definingFeature, block, nameBeforeIndex);
            }
            EObject instanceValue = Util.instantiateEClass((EClass)TwcConstants.InstanceValue);
            EObject inst = Util.instantiateEClass((EClass)TwcConstants.InstanceSpecification);
            this.doAdd(inst, TwcConstants.InstanceSpecification$classifier, block.get());
            ShareInstance.addNotificationModifier((Notifier)instanceValue, (MPNotificationModifier)this.shareInstanceNM);
            this.doSet(instanceValue, TwcConstants.InstanceValue$instance, inst, null);
            this.doAdd(instance.eContainer(), M2Element.Package$packagedElement, inst);
            this.doSet(slot, TwcConstants.Slot$definingFeature, definingFeature.get(), null);
            this.adapter.add(instance, TwcConstants.InstanceSpecification$slot, (Object)slot, -1);
            this.doAdd(slot, TwcConstants.Slot$value, instanceValue);
            this.adapter.doSet(inst, M2Element.NamedElement$name, (Object)(instance.eGet(M2Element.NamedElement$name) + "." + name.toLowerCase()), null);
            return inst;
        }

        private void createEmptyInstances(EObject slot, int currentNumber, int count, EObject instance, Optional<EObject> definingFeature, Optional<EObject> block, String nameBeforeIndex) {
            for (int i = currentNumber + 1; i < count; ++i) {
                EObject instanceValue = Util.instantiateEClass((EClass)TwcConstants.InstanceValue);
                EObject inst = Util.instantiateEClass((EClass)TwcConstants.InstanceSpecification);
                this.doAdd(instance.eContainer(), M2Element.Package$packagedElement, inst);
                ShareInstance.addNotificationModifier((Notifier)instanceValue, (MPNotificationModifier)this.shareInstanceNM);
                this.doSet(instanceValue, TwcConstants.InstanceValue$instance, inst, null);
                this.doAdd(slot, TwcConstants.Slot$value, instanceValue);
                this.doSet(slot, TwcConstants.Slot$definingFeature, definingFeature.get(), null);
                this.doAdd(inst, TwcConstants.InstanceSpecification$classifier, block.get());
                this.doAdd(instance, TwcConstants.InstanceSpecification$slot, slot);
                this.doSet(inst, M2Element.NamedElement$name, instance.eGet(M2Element.NamedElement$name) + "." + nameBeforeIndex.toLowerCase() + "[" + i + "]", null);
            }
        }

        private EObject shareInstance(EObject instance, EObject partProperty, EObject targetInstance, int number, String blockName) throws MPException {
            Optional<EObject> oSlot = Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$slot).stream().filter(s -> partProperty.equals(s.eGet(TwcConstants.Slot$definingFeature))).findFirst();
            EObject slot = null;
            EObject valueSpecification = null;
            Object oldValue = null;
            if (oSlot.isPresent()) {
                slot = oSlot.get();
                List slotValues = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value);
                int mutliplicityValue = (Integer)partProperty.eGet(M2Element.MultiplicityElement$upper);
                if (slotValues.isEmpty() || mutliplicityValue == -1 || slotValues.size() < mutliplicityValue) {
                    if (number > slotValues.size() + 1) {
                        this.createEmptyInstances(slot, slotValues.size(), number, instance, Optional.of(partProperty), Optional.of((EObject)partProperty.eGet(M2Element.TypedElement$type)), blockName);
                    }
                    valueSpecification = Util.instantiateEClass((EClass)TwcConstants.InstanceValue);
                    this.adapter.doAdd(slot, TwcConstants.Slot$value, (Object)valueSpecification);
                } else {
                    valueSpecification = (EObject)slotValues.get(0);
                    oldValue = valueSpecification.eGet(TwcConstants.InstanceValue$instance);
                }
            } else {
                slot = Util.instantiateEClass((EClass)TwcConstants.Slot);
                this.adapter.doAdd(instance, TwcConstants.InstanceSpecification$slot, (Object)slot);
                this.adapter.doSet(slot, TwcConstants.Slot$definingFeature, (Object)partProperty, null);
                valueSpecification = Util.instantiateEClass((EClass)TwcConstants.InstanceValue);
                this.adapter.doAdd(slot, TwcConstants.Slot$value, (Object)valueSpecification);
            }
            ShareInstance.addNotificationModifier((Notifier)valueSpecification, (MPNotificationModifier)this.shareInstanceNM);
            this.adapter.doSet(valueSpecification, TwcConstants.InstanceValue$instance, (Object)targetInstance, oldValue);
            return targetInstance;
        }

        private EObject getPartProperty(EObject instance, String name) {
            EObject context = (EObject)Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier).get(0);
            EObject orElse = ElementUtil.getAllPropertiesFromBlock(context).stream().filter(p -> StereotypeUtil.isPartProperty(p) || StereotypeUtil.isMbpleFeature(p)).filter(p -> ((EObject)p.eGet(M2Element.TypedElement$type)).eGet(M2Element.NamedElement$name).equals(name)).findFirst().orElse(null);
            return orElse;
        }
    }

    public static class ShareInstanceNotification
    extends MPAbstractNotificationModifier {
        private Map<EObject, EObject> valueSpecification_SlotMap = new HashMap<EObject, EObject>();
        private Map<EObject, Set<EObject>> instanceValue_InstancesMap = new HashMap<EObject, Set<EObject>>();
        private TwcAdapter adapter;

        protected ShareInstanceNotification(TwcAdapter adapter) {
            super(TwcConstants.InstanceValue$instance);
            this.adapter = adapter;
        }

        protected void changed(Object obj, Notification msg, boolean isAdded) {
            try {
                EObject slot;
                EObject targetInstance = (EObject)obj;
                EObject valueSpecification = (EObject)msg.getNotifier();
                EObject eObject = slot = valueSpecification.eContainer() == null && this.valueSpecification_SlotMap.containsKey(valueSpecification) ? this.valueSpecification_SlotMap.get(valueSpecification) : valueSpecification.eContainer();
                if (targetInstance == null || slot == null) {
                    return;
                }
                Set<Object> instances = new HashSet();
                HashSet slots = new HashSet();
                if (valueSpecification.eContainer() != null) {
                    this.valueSpecification_SlotMap.put(valueSpecification, slot);
                }
                this.send(slot, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_SlotValue(), obj, isAdded);
                instances.addAll((Collection)this.adapter.get(slot, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_InstanceTree()));
                instances = instances.stream().filter(Objects::nonNull).collect(Collectors.toSet());
                if (isAdded) {
                    this.instanceValue_InstancesMap.put(valueSpecification, instances);
                } else if (instances == null || instances.isEmpty()) {
                    instances = this.instanceValue_InstancesMap.get(valueSpecification);
                }
                if (instances == null) {
                    this.send(targetInstance, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_Slots(), slot, isAdded);
                    return;
                }
                slots.addAll((Collection)this.adapter.get(targetInstance, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_Slots()));
                for (EObject eObject2 : instances) {
                    for (EObject eObject22 : slots) {
                        this.send(eObject2, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_Slots(), eObject22, isAdded);
                    }
                }
            }
            catch (MPException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public static class UnshareInstance
    extends MPAbstractModifier {
        ShareInstanceNotification shareInstanceNM;

        public UnshareInstance(MPBaseAdapter adapter) throws MPException {
            super(adapter);
            this.shareInstanceNM = new ShareInstanceNotification((TwcAdapter)this.adapter);
        }

        public EModelElement getModificationCriteria() {
            return MSEPackage.eINSTANCE.getInternalClass_UnsharedInstance();
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj;
        }

        public void unset(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
            if (!Util.isInstanceOf((Object)eObj, (EClass)TwcConstants.InstanceSpecification) || !(value instanceof List)) {
                return;
            }
            EObject instance = eObj;
            List path = (List)value;
            path = path.stream().filter(Objects::nonNull).collect(Collectors.toList());
            for (int i = 1; i < path.size() - 1 && instance != null; ++i) {
                boolean unsetInstanceCondition;
                String name = (String)path.get(i);
                EObject tmp = ElementUtil.findInstanceSpecification(instance, name);
                boolean bl = unsetInstanceCondition = tmp != null && path.size() - 2 == i;
                if (!unsetInstanceCondition) {
                    instance = tmp;
                    continue;
                }
                if (!this.deleteSlotOrUnsetInstnaceValue(instance, tmp)) continue;
                return;
            }
        }

        private boolean deleteSlotOrUnsetInstnaceValue(EObject instance, EObject tmp) throws MPException {
            assert (instance != null);
            assert (tmp != null);
            List classifiers = Util.getEList((EObject)tmp, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
            assert (!classifiers.isEmpty());
            EObject classifier = (EObject)classifiers.get(0);
            assert (classifier != null);
            for (EObject s : Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$slot)) {
                EObject df = (EObject)s.eGet(TwcConstants.Slot$definingFeature);
                if (!StereotypeUtil.isPartProperty(df) && !StereotypeUtil.isMbpleFeature(df) || !classifier.equals(df.eGet(M2Element.TypedElement$type))) continue;
                List sValues = Util.getEList((EObject)s, (EStructuralFeature)TwcConstants.Slot$value);
                if (sValues.size() > 1) {
                    TwcAdapter.getDialogManager().messageBox("Unshare for multiplicity > 1 is not supported yet", 33);
                    return false;
                }
                for (EObject sv : sValues) {
                    if (!Util.isInstanceOf((Object)sv, (EClass)TwcConstants.InstanceValue) || !tmp.equals(sv.eGet(TwcConstants.InstanceValue$instance))) continue;
                    UnshareInstance.addNotificationModifier((Notifier)sv, (MPNotificationModifier)this.shareInstanceNM);
                    this.adapter.unset(sv, TwcConstants.InstanceValue$instance, (Object)tmp);
                    if (sValues.size() == 1) {
                        this.adapter.delete(s);
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

