/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.modifier.MPAbstractNotificationModifier;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMMultiplicityOfInstance
extends MPAbstractModifier {
    public static Logger LOGGER = Logger.getLogger(MPMMultiplicityOfInstance.class);
    private final int MAX_INSTANCE_CREATION = 10;
    private final InstanceValuetNotification notification = new InstanceValuetNotification();

    public MPMMultiplicityOfInstance(MPBaseAdapter adapter) throws MPException {
        super(adapter);
    }

    public EModelElement getModificationCriteria() {
        return TwcPackage.eINSTANCE.getTwcClass_MultiplicityOfInstance();
    }

    public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
        EObject slot = eobj.eContainer();
        if (!Util.isInstanceOf((Object)eobj, (EClass)TwcConstants.InstanceValue) || !Util.isInstanceOf((Object)slot, (EClass)TwcConstants.Slot)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eobj);
        }
        List instanceValues = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value);
        for (EObject instanceValue : instanceValues) {
            MPMMultiplicityOfInstance.addNotificationModifier((Notifier)instanceValue, (MPNotificationModifier)this.notification);
        }
        int size = instanceValues.size();
        return String.valueOf(size);
    }

    private int convertStringToInt(Object value) throws MPInvalidException {
        try {
            return Double.valueOf((String)value).intValue();
        }
        catch (NumberFormatException e) {
            throw new MPInvalidException("Invalid value.");
        }
    }

    public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
        EObject slot = eObj.eContainer();
        if (!Util.isInstanceOf((Object)slot, (EClass)TwcConstants.Slot)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eObj);
        }
        int newMultiValue = this.convertStringToInt(value);
        int currentMultiValue = this.convertStringToInt(oldValue);
        if (newMultiValue <= 0) {
            throw new MPInvalidException("Invalid value. The value must be greater than 0");
        }
        if (newMultiValue > currentMultiValue) {
            int createInstance = newMultiValue - currentMultiValue;
            int remaining = this.checkMultiplicity(slot);
            if (remaining < createInstance) {
                LOGGER.error((Object)"Invalid value. The value must be greater than 0 and less than 10");
                throw new MPInvalidException("Invalid value. The value must be greater than 0 and less than 10");
            }
            for (int i = 1; i <= createInstance; ++i) {
                this.createInstanceSpecificationAndAddToSlot(slot, currentMultiValue + i);
            }
        } else if (currentMultiValue == newMultiValue + 1) {
            int lowerValue = this.checkLowerMutliplicityValue(slot);
            if (newMultiValue < lowerValue) {
                LOGGER.error((Object)("Invalid value. Mutliplicity cannot be lower than " + lowerValue));
                throw new MPInvalidException("Invalid value. Mutliplicity cannot be lower than " + lowerValue);
            }
            this.deleteLastInstanceSpecification(slot);
        } else {
            LOGGER.error((Object)"Invalid action. You cannot reduce the multiplicity by more than 1");
            throw new MPInvalidException("Invalid action. You cannot reduce the multiplicity by more than 1");
        }
    }

    private int checkLowerMutliplicityValue(EObject slot) {
        EObject definingFeature = (EObject)slot.eGet(TwcConstants.Slot$definingFeature);
        Object lower = definingFeature.eGet(M2Element.MultiplicityElement$lowerValue);
        if (lower == null) {
            return 1;
        }
        EObject eObject = (EObject)lower;
        Integer eGet = (Integer)eObject.eGet(M2Element.LiteralInteger$value);
        return eGet;
    }

    private int checkMultiplicity(EObject slot) throws MPInvalidException {
        EObject definingFeature = (EObject)slot.eGet(TwcConstants.Slot$definingFeature);
        Object upper = definingFeature.eGet(M2Element.MultiplicityElement$upperValue);
        if (upper == null) {
            return 0;
        }
        Integer multiUpperValue = (Integer)((EObject)upper).eGet(M2Element.LiteralUnlimitedNatural$value);
        int currentValue = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value).size();
        if (multiUpperValue.equals(-1)) {
            return 10;
        }
        int remainingValue = multiUpperValue - currentValue;
        assert (remainingValue >= 0);
        return remainingValue;
    }

    public void deleteLastInstanceSpecification(EObject slot) throws MPException {
        List values = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value);
        EObject instanceV1 = (EObject)values.get(values.size() - 1);
        EObject instance = (EObject)instanceV1.eGet(TwcConstants.InstanceValue$instance);
        EObject classifier = (EObject)Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier).get(0);
        this.adapter.remove(instance, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_RecursiveInstanceWithSlots(), (Object)classifier);
        this.adapter.unset(instanceV1, TwcConstants.InstanceValue$instance, (Object)instance);
        MPMMultiplicityOfInstance.addNotificationModifier((Notifier)instanceV1, (MPNotificationModifier)this.notification);
        this.adapter.remove(slot, TwcConstants.Slot$value, (Object)instanceV1);
    }

    private void createInstanceSpecificationAndAddToSlot(EObject slot, int number) throws MPException {
        EObject owingInstance = slot.eContainer();
        EObject classifier = (EObject)((EObject)slot.eGet(TwcConstants.Slot$definingFeature)).eGet(M2Element.TypedElement$type);
        String owingInstanceName = (String)owingInstance.eGet(M2Element.NamedElement$name);
        Object classifierName = classifier.eGet(M2Element.NamedElement$name);
        String newName = String.format("%s.%s[%d]", owingInstanceName, classifierName, number);
        EObject ownerPackage = owingInstance.eContainer();
        EObject instance = Util.instantiateEClass((EClass)TwcConstants.InstanceSpecification);
        this.doSet(instance, M2Element.NamedElement$name, newName, null);
        EObject newInstanceValue = Util.instantiateEClass((EClass)TwcConstants.InstanceValue);
        this.doAdd(slot, TwcConstants.Slot$value, newInstanceValue, -1);
        this.doAdd(ownerPackage, M2Element.Package$packagedElement, instance, -1);
        MPMMultiplicityOfInstance.addNotificationModifier((Notifier)newInstanceValue, (MPNotificationModifier)this.notification);
        this.doSet(newInstanceValue, TwcConstants.InstanceValue$instance, instance, null);
        this.adapter.add(instance, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_RecursiveInstanceWithSlots(), (Object)classifier, -1);
    }

    private class InstanceValuetNotification
    extends MPAbstractNotificationModifier {
        private Map<EObject, List<EObject>> trackValues;

        public InstanceValuetNotification() {
            super(TwcConstants.InstanceValue$instance);
            this.trackValues = new HashMap<EObject, List<EObject>>();
        }

        protected void changed(Object obj, Notification msg, boolean isAdded) {
            EObject instanceValue = (EObject)msg.getNotifier();
            EObject slot = instanceValue.eContainer();
            List<EObject> values = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value);
            if (isAdded && !values.isEmpty()) {
                this.trackValues.put(instanceValue, values.stream().filter(v -> !v.equals(instanceValue)).collect(Collectors.toList()));
            } else if (!isAdded && slot == null) {
                values = this.trackValues.get(instanceValue);
            }
            int size = values.size();
            for (EObject eObject : values) {
                this.send(eObject, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_MultiplicityOfInstance(), "" + size, isAdded);
            }
            if (!isAdded) {
                return;
            }
            try {
                List instances = (List)MPMMultiplicityOfInstance.this.adapter.get(slot, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_InstanceTree());
                HashSet slots = new HashSet();
                for (EObject instance : instances) {
                    List eos = (List)MPMMultiplicityOfInstance.this.adapter.get(instance, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_Slots());
                    slots.addAll(eos);
                }
                for (EObject s : slots) {
                    for (EObject in : instances) {
                        this.send(in, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_Slots(), s, isAdded);
                    }
                }
            }
            catch (MPException e) {
                LOGGER.error((Object)e);
            }
        }
    }
}

