/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public abstract class MPMMultipleObjects
extends MPAbstractModifier {
    public MPMMultipleObjects(MPBaseAdapter adapter) throws MPException {
        super(adapter);
    }

    private static List<String> splitByTerminator(String str, int termiator) {
        int beginIndex = 0;
        boolean lastOneFound = false;
        LinkedList<String> result = new LinkedList<String>();
        while (!lastOneFound) {
            int index = str.indexOf(termiator, beginIndex);
            if (index == str.length() - 1) {
                lastOneFound = true;
            } else if (index == -1) {
                lastOneFound = true;
                index = str.length();
            }
            result.add(str.substring(beginIndex, index));
            beginIndex = index + 1;
        }
        return result;
    }

    private static List<String> getStereotypeList(String str) {
        List<String> result = MPMMultipleObjects.splitByTerminator(str, 59);
        for (int i = 0; i < result.size(); ++i) {
            if (!result.get(i).contains(",")) continue;
            List<String> subSplits = Arrays.asList(result.get(i).split(","));
            subSplits.sort(String::compareTo);
            result.set(i, String.join((CharSequence)",", subSplits));
        }
        result.sort(String::compareTo);
        return result;
    }

    private static void diff(String oldVal, String newVal, List<String> toAdd, List<String> toRemove) {
        String currentNew;
        toAdd.clear();
        toRemove.clear();
        if (oldVal.equals(newVal)) {
            return;
        }
        List<String> oldList = MPMMultipleObjects.getStereotypeList(oldVal);
        List<String> newList = MPMMultipleObjects.getStereotypeList(newVal);
        Iterator<String> oldIt = oldList.iterator();
        Iterator<String> newIt = newList.iterator();
        String currentOld = oldIt.hasNext() ? oldIt.next() : null;
        String string = currentNew = newIt.hasNext() ? newIt.next() : null;
        while (currentOld != null && currentNew != null) {
            int c = currentOld.compareTo(currentNew);
            if (c == 0) {
                currentOld = oldIt.hasNext() ? oldIt.next() : null;
                currentNew = newIt.hasNext() ? newIt.next() : null;
                continue;
            }
            if (c < 0) {
                toRemove.add(currentOld);
                currentOld = oldIt.hasNext() ? oldIt.next() : null;
                continue;
            }
            toAdd.add(currentNew);
            currentNew = newIt.hasNext() ? newIt.next() : null;
        }
        if (currentOld != null) {
            toRemove.add(currentOld);
        }
        while (oldIt.hasNext()) {
            toRemove.add(oldIt.next());
        }
        if (currentNew != null) {
            toAdd.add(currentNew);
        }
        while (newIt.hasNext()) {
            toAdd.add(newIt.next());
        }
    }

    private static List<EObject> getSisterDependencies(EObject dependency) {
        try {
            EObject client = (EObject)Util.getEList((EObject)dependency, (EStructuralFeature)M2Element.Dependency$client).get(0);
            EObject supplier = (EObject)Util.getEList((EObject)dependency, (EStructuralFeature)M2Element.Dependency$supplier).get(0);
            LinkedList<EObject> tmp = new LinkedList<EObject>();
            tmp.add(dependency);
            for (EObject d : Util.getEList((EObject)client, (EStructuralFeature)M2Element.NamedElement$clientDependency)) {
                if (d == dependency || !Util.getEList((EObject)d, (EStructuralFeature)M2Element.Dependency$supplier).contains(supplier)) continue;
                tmp.add(d);
            }
            return tmp;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static class ClientDependency
    extends MPMMultipleObjects {
        public ClientDependency(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return TwcPackage.eINSTANCE.getTwcClass_MultipleObjects();
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            if (!Util.isInstanceOf((Object)eobj, (EClass)M2Element.Dependency)) {
                throw new MPInvalidException("Invalid for " + feature + " " + eobj);
            }
            List<EObject> deps = MPMMultipleObjects.getSisterDependencies(eobj);
            ArrayList<String> streotypes = new ArrayList<String>(deps.size());
            for (EObject dep : deps) {
                String tmp = this.adapter.get(dep, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_StereotypeNames()).toString();
                streotypes.add(tmp);
            }
            int size = streotypes.size();
            if (size >= 1 && ((String)streotypes.get(size - 1)).isEmpty()) {
                streotypes.set(size - 1, ";");
            }
            return String.join((CharSequence)";", streotypes);
        }

        public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
            List tmp;
            if (!Util.isInstanceOf((Object)eObj, (EClass)M2Element.Dependency)) {
                throw new MPInvalidException("Invalid for " + feature + " " + eObj);
            }
            if (!(value instanceof String)) {
                throw new MPInvalidException("A string encoding stereotypes was expected here");
            }
            if (";".equals(oldValue)) {
                String multipleSterotypes;
                String[] depsSplit = value.toString().split(";");
                if (depsSplit.length == 0) {
                    depsSplit = new String[]{""};
                }
                if (!(multipleSterotypes = depsSplit[0]).trim().isEmpty()) {
                    String[] stereotypes = multipleSterotypes.split(",");
                    for (int i = 0; i < stereotypes.length; ++i) {
                        StereotypeUtil.addStereotype(this.adapter, eObj, stereotypes[i]);
                    }
                    oldValue = multipleSterotypes;
                }
            }
            if ((tmp = Util.getEList((EObject)eObj, (EStructuralFeature)M2Element.Dependency$client)).size() != 1) {
                throw new MPInvalidException("Invalid for corrupted element " + eObj);
            }
            EObject client = (EObject)tmp.get(0);
            tmp = Util.getEList((EObject)eObj, (EStructuralFeature)M2Element.Dependency$supplier);
            if (tmp.size() != 1) {
                throw new MPInvalidException("Invalid for corrupted element " + eObj);
            }
            EObject supplier = (EObject)tmp.get(0);
            ArrayList<String> toAdd = new ArrayList<String>();
            final ArrayList<String> toRemove = new ArrayList<String>();
            MPMMultipleObjects.diff(oldValue.toString(), value.toString(), toAdd, toRemove);
            for (String str : toAdd) {
                EObject dep = this.adapter.instantiate(M2Element.Dependency, Collections.singletonMap(TwcPackage.eINSTANCE.getTwcClass_StereotypeNames(), str));
                this.doAdd(client.eContainer(), M2Element.Package$packagedElement, dep);
                this.doAdd(dep, M2Element.Dependency$client, client);
                this.doAdd(dep, M2Element.Dependency$supplier, supplier);
            }
            if (toRemove.isEmpty()) {
                return;
            }
            Predicate<EObject> isMarked = new Predicate<EObject>(){

                @Override
                public boolean test(EObject dependency) {
                    try {
                        Object stereotype = adapter.get(dependency, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_StereotypeNames());
                        if (stereotype.toString().isEmpty()) {
                            return toRemove.remove("");
                        }
                        return toRemove.remove(stereotype);
                    }
                    catch (MPException e) {
                        return true;
                    }
                }
            };
            List sistersToDelete = MPMMultipleObjects.getSisterDependencies(eObj).stream().filter(isMarked).collect(Collectors.toList());
            for (EObject dep : sistersToDelete) {
                ((TwcAdapter)this.adapter).dispose(dep);
            }
        }
    }
}

