/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.magicdraw.plugin.api.DiagramInfo;
import com.maplesoft.maplembse.magicdraw.plugin.api.MagicDrawServices;
import com.maplesoft.maplembse.special.twc.adapter.MagicDrawServiceUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public abstract class MPMDiagram
extends MPAbstractModifier {
    public static final Logger LOGGER = Logger.getLogger(MPMDiagram.class);
    protected TwcAdapter twcAdapter;
    private static Map<Object, DiagramInfo> downloadedDiagrams = new HashMap<Object, DiagramInfo>();

    protected MPMDiagram(MPBaseAdapter adapter) throws MPException {
        super(adapter);
        this.twcAdapter = (TwcAdapter)this.adapter;
    }

    public static void clearValues() {
        downloadedDiagrams.clear();
    }

    public static class MPMDiagramType
    extends MPMDiagram {
        public MPMDiagramType(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return TwcPackage.eINSTANCE.getTwcClass_DiagramType();
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            if (eobj == null || !Util.isInstanceOf((Object)eobj, (EClass)TwcConstants.Diagram)) {
                throw new MPInvalidException("Invalid for " + feature + " " + eobj);
            }
            if (downloadedDiagrams.containsKey(eobj)) {
                return downloadedDiagrams.get(eobj).getType();
            }
            return null;
        }
    }

    public static class MPMDownloadDiagram
    extends MPMDiagram {
        public MPMDownloadDiagram(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return TwcPackage.eINSTANCE.getTwcClass_DownloadDiagram();
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            if (eobj == null || !Util.isInstanceOf((Object)eobj, (EClass)TwcConstants.Diagram)) {
                throw new MPInvalidException("Invalid for " + feature + " " + eobj);
            }
            if (downloadedDiagrams.containsKey(eobj)) {
                return this.getHyperlink(downloadedDiagrams.get(eobj));
            }
            Optional<MagicDrawServices> connection = this.twcAdapter.getMagicDrawConnection();
            if (!connection.isPresent()) {
                throw new MPInvalidException("Unable to connect to the MapleMBSE Plugin . Check if the right project is open by the current user");
            }
            LOGGER.info((Object)"========================== Downloading the diagram ====================================");
            DiagramInfo diagramInfo = MagicDrawServiceUtil.downloadDiagram(connection.get(), eobj);
            LOGGER.info((Object)"========================== Diagram downloaded =============================");
            downloadedDiagrams.put(eobj, diagramInfo);
            return this.getHyperlink(diagramInfo);
        }

        private String getHyperlink(DiagramInfo info) {
            return "=HYPERLINK(\"file://" + info.getFile().getAbsolutePath() + "\", \"" + info.getName() + "\")";
        }
    }
}

