/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPIllegalStateException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMActivitySync {
    public static final Enumerator PARAMETER_IN = MPMActivitySync.getDirection("in");
    public static final Enumerator PARAMETER_INOUT = MPMActivitySync.getDirection("inout");
    public static final Enumerator PARAMETER_OUT = MPMActivitySync.getDirection("out");
    public static final Enumerator PARAMETER_RETURN = MPMActivitySync.getDirection("return");

    private static Enumerator getDirection(String str) {
        return M2Element.ParameterDirectionKind.getEEnumLiteral(str).getInstance();
    }

    private static List<Param> initParamList(Object behavior) {
        if (behavior == null) {
            return Collections.emptyList();
        }
        return Util.getEList((EObject)((EObject)behavior), (EStructuralFeature)M2Element.Behavior$ownedParameter).stream().map(Param::valueOf).collect(Collectors.toList());
    }

    private static void createAndAddPin(MPBaseAdapter adapter, EObject owner, EStructuralFeature feature, Param param) throws MPException {
        EClass eClass = M2Element.CallAction$result.equals(feature) ? M2Element.OutputPin : M2Element.InputPin;
        HashMap<EStructuralFeature, String> inits = new HashMap<EStructuralFeature, String>();
        inits.put(M2Element.NamedElement$name, param.name);
        inits.put(M2Element.Element$syncElement, (String)param.param);
        if (param.isTypeSet) {
            inits.put(M2Element.TypedElement$type, (String)param.type);
        }
        EObject pin = adapter.instantiate(eClass, inits);
        adapter.doAdd(owner, feature, (Object)pin);
    }

    private static class Param {
        private EObject param;
        private String name;
        private Enumerator direction;
        private EObject type;
        private boolean isTypeSet;

        private Param() {
        }

        static Param valueOf(EObject param) {
            Param p = new Param();
            p.param = param;
            p.name = (String)param.eGet(M2Element.NamedElement$name);
            p.direction = (Enumerator)param.eGet(M2Element.Parameter$direction);
            p.isTypeSet = param.eIsSet(M2Element.TypedElement$type);
            p.type = (EObject)param.eGet(M2Element.TypedElement$type);
            return p;
        }

        static boolean isRightType(Object type) {
            return PARAMETER_IN.equals(type) || PARAMETER_INOUT.equals(type) || PARAMETER_OUT.equals(type) || PARAMETER_RETURN.equals(type);
        }

        boolean isInParam() {
            return PARAMETER_IN.equals(this.direction) || PARAMETER_INOUT.equals(this.direction);
        }

        boolean isOutParam() {
            return PARAMETER_OUT.equals(this.direction) || PARAMETER_INOUT.equals(this.direction) || PARAMETER_RETURN.equals(this.direction);
        }
    }

    public static class Name
    extends MPAbstractModifier {
        public Name(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.NamedElement$name;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(feature);
        }

        public EObject init(EObject eObj, EStructuralFeature initFeature, Object initFeatureValue) throws MPException {
            this.doSet(eObj, initFeature, initFeatureValue, null);
            return eObj;
        }

        public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
            if (Util.isInstanceOf((Object)eObj, (EClass)TwcConstants.InstanceSpecification)) {
                List slots = Util.getEList((EObject)eObj, (EStructuralFeature)TwcConstants.InstanceSpecification$slot);
                for (EObject slot : slots) {
                    List instances;
                    EObject definingFeature = (EObject)slot.eGet(TwcConstants.Slot$definingFeature);
                    if (!StereotypeUtil.isPartProperty(definingFeature) && (!StereotypeUtil.isMbpleFeature(definingFeature) || definingFeature.eGet(M2Element.Property$association) == null) || (instances = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value).stream().map(v -> (EObject)v.eGet(TwcConstants.InstanceValue$instance)).collect(Collectors.toList())).isEmpty()) continue;
                    Object upperValue = definingFeature.eGet(M2Element.MultiplicityElement$upper);
                    boolean isMultiple = upperValue instanceof Integer && !upperValue.equals(1);
                    int idx = 1;
                    for (EObject instance : instances) {
                        if (instance == null || instance.eIsSet(M2Element.NamedElement$name)) continue;
                        EObject classifier = (EObject)Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier).get(0);
                        String idxSuffix = isMultiple ? String.format("[%d]", idx++) : "";
                        String name = value + "." + classifier.eGet(M2Element.NamedElement$name) + idxSuffix;
                        this.adapter.set(instance, M2Element.NamedElement$name, (Object)name);
                    }
                }
            } else if (Util.isInstanceOf((Object)eObj, (EClass)M2Element.Parameter)) {
                for (EObject apn : Util.getEList((EObject)eObj, (EStructuralFeature)M2Element.Parameter$_activityParameterNodeOfParameter)) {
                    this.doSet(apn, feature, value, oldValue);
                }
                for (EObject pin : Util.getEList((EObject)eObj, (EStructuralFeature)M2Element.Element$_elementOfSyncElement)) {
                    String name;
                    if (!Util.isInstanceOf((Object)pin, (EClass)M2Element.Pin) || !Objects.equals(name = (String)pin.eGet(feature), oldValue)) continue;
                    this.doSet(pin, feature, value, oldValue);
                }
            }
            this.doSet(eObj, feature, value, oldValue);
        }
    }

    public static class Result
    extends MPAbstractModifier {
        public Result(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.CallAction$result;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(feature);
        }

        public void add(EObject eObj, EStructuralFeature feature, Object value, int index) throws MPException {
            if (!Util.isInstanceOf((Object)value, (EClass)M2Element.OutputPin)) {
                throw new MPInvalidException(String.format("Element %s, feature %s, and value %s are not compatible", eObj, feature, value));
            }
            this.doAdd(eObj, feature, value, index);
            if (!Util.isInstanceOf((Object)eObj, (EClass)M2Element.CallBehaviorAction)) {
                return;
            }
            EObject behavior = (EObject)eObj.eGet(M2Element.CallBehaviorAction$behavior);
            if (behavior == null) {
                return;
            }
            Map<EStructuralFeature, Enumerator> inits = Collections.singletonMap(M2Element.Parameter$direction, PARAMETER_OUT);
            EObject parameter = this.adapter.instantiate(M2Element.Parameter, inits);
            this.doAdd(behavior, M2Element.Behavior$ownedParameter, parameter);
            this.doSet((EObject)value, M2Element.Element$syncElement, parameter, null);
            inits = Collections.singletonMap(M2Element.ActivityParameterNode$parameter, parameter);
            EObject paramNode = this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
            this.doAdd(behavior, M2Element.Activity$node, paramNode);
            inits = Collections.singletonMap(M2Element.Element$syncElement, parameter);
            for (EObject action : Util.getEList((EObject)behavior, (EStructuralFeature)M2Element.Behavior$_callBehaviorActionOfBehavior)) {
                if (action.equals(eObj)) continue;
                EObject pin = this.adapter.instantiate(M2Element.OutputPin, inits);
                this.doAdd(action, M2Element.CallAction$result, pin);
            }
        }
    }

    public static class Argument
    extends MPAbstractModifier {
        public Argument(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.InvocationAction$argument;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(feature);
        }

        public void add(EObject eObj, EStructuralFeature feature, Object value, int index) throws MPException {
            if (!Util.isInstanceOf((Object)value, (EClass)M2Element.InputPin)) {
                throw new MPInvalidException(String.format("Element %s, feature %s, and value %s are not compatible", eObj, feature, value));
            }
            this.doAdd(eObj, feature, value, index);
            if (!Util.isInstanceOf((Object)eObj, (EClass)M2Element.CallBehaviorAction)) {
                return;
            }
            EObject behavior = (EObject)eObj.eGet(M2Element.CallBehaviorAction$behavior);
            if (behavior == null) {
                return;
            }
            Map<EStructuralFeature, Enumerator> inits = Collections.singletonMap(M2Element.Parameter$direction, PARAMETER_IN);
            EObject parameter = this.adapter.instantiate(M2Element.Parameter, inits);
            this.doAdd(behavior, M2Element.Behavior$ownedParameter, parameter);
            this.doSet((EObject)value, M2Element.Element$syncElement, parameter, null);
            inits = Collections.singletonMap(M2Element.ActivityParameterNode$parameter, parameter);
            EObject paramNode = this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
            this.doAdd(behavior, M2Element.Activity$node, paramNode);
            inits = Collections.singletonMap(M2Element.Element$syncElement, parameter);
            for (EObject action : Util.getEList((EObject)behavior, (EStructuralFeature)M2Element.Behavior$_callBehaviorActionOfBehavior)) {
                if (action.equals(eObj)) continue;
                EObject pin = this.adapter.instantiate(M2Element.InputPin, inits);
                this.doAdd(action, M2Element.InvocationAction$argument, pin);
            }
        }

        public void remove(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
            super.remove(eObj, feature, value);
        }
    }

    public static class Direction
    extends MPAbstractModifier {
        public static boolean isSetting = false;

        public Direction(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.Parameter$direction;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(feature);
        }

        public EObject init(EObject eObj, EStructuralFeature initFeature, Object initFeatureValue) throws MPException {
            this.doSet(eObj, initFeature, initFeatureValue, null);
            return eObj;
        }

        public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
            isSetting = true;
            EObject param = eObj;
            if (!Param.isRightType(value) || !Param.isRightType(oldValue)) {
                throw new MPInvalidException(String.format("Element %s, feature %s, and value %s are not compatible", param, feature, value));
            }
            this.doSet(param, feature, value, oldValue);
            Param oldParam = Param.valueOf(param);
            oldParam.direction = (Enumerator)oldValue;
            Param newParam = Param.valueOf(param);
            newParam.direction = (Enumerator)value;
            EObject behavior = param.eContainer();
            List actions = Util.getEList((EObject)behavior, (EStructuralFeature)M2Element.Behavior$_callBehaviorActionOfBehavior);
            ArrayList pins = new ArrayList(Util.getEList((EObject)param, (EStructuralFeature)M2Element.Element$_elementOfSyncElement));
            if (!oldParam.isInParam() && newParam.isInParam()) {
                for (EObject action : actions) {
                    MPMActivitySync.createAndAddPin(this.adapter, action, M2Element.InvocationAction$argument, newParam);
                }
            }
            if (!oldParam.isOutParam() && newParam.isOutParam()) {
                for (EObject action : actions) {
                    MPMActivitySync.createAndAddPin(this.adapter, action, M2Element.CallAction$result, newParam);
                }
            }
            if (oldParam.isInParam() && !newParam.isInParam()) {
                List inputPins = pins.stream().filter(p -> Util.isInstanceOf((Object)p, (EClass)M2Element.InputPin)).collect(Collectors.toList());
                for (EObject pin : inputPins) {
                    ((TwcAdapter)this.adapter).deleteElement(pin);
                }
            }
            if (oldParam.isOutParam() && !newParam.isOutParam()) {
                List outputPins = pins.stream().filter(p -> Util.isInstanceOf((Object)p, (EClass)M2Element.OutputPin)).collect(Collectors.toList());
                for (EObject pin : outputPins) {
                    ((TwcAdapter)this.adapter).deleteElement(pin);
                }
            }
            this.syncActivityParameterNode(param, oldParam, newParam);
            isSetting = false;
        }

        private void syncActivityParameterNode(EObject param, Param oldParam, Param newParam) throws MPException {
            block18: {
                HashMap<EStructuralFeature, Object> inits;
                int nNodes;
                block19: {
                    EObject unusedNode;
                    block20: {
                        EObject duplicateNode;
                        EObject outNode;
                        EObject inNode;
                        block16: {
                            block17: {
                                if (Objects.equals(newParam.direction, oldParam.direction)) {
                                    return;
                                }
                                List nodes = Util.getEList((EObject)param, (EStructuralFeature)M2Element.Parameter$_activityParameterNodeOfParameter);
                                if (nodes.size() > 2 || PARAMETER_INOUT.equals(oldParam.direction) && nodes.size() != 2) {
                                    throw new MPIllegalStateException(param + " and " + nodes + " are not in sync.");
                                }
                                inNode = null;
                                outNode = null;
                                unusedNode = null;
                                duplicateNode = null;
                                nNodes = 0;
                                for (EObject node : nodes) {
                                    ++nNodes;
                                    List outgoing = Util.getEList((EObject)node, (EStructuralFeature)M2Element.ActivityNode$outgoing);
                                    List incoming = Util.getEList((EObject)node, (EStructuralFeature)M2Element.ActivityNode$incoming);
                                    if (!outgoing.isEmpty()) {
                                        if (inNode == null) {
                                            inNode = node;
                                        } else {
                                            duplicateNode = node;
                                        }
                                        if (incoming.isEmpty()) continue;
                                        throw new MPIllegalStateException(node + " has both incoming and outgoing object flows.");
                                    }
                                    if (!incoming.isEmpty()) {
                                        if (outNode == null) {
                                            outNode = node;
                                            continue;
                                        }
                                        duplicateNode = node;
                                        continue;
                                    }
                                    if (unusedNode == null) {
                                        unusedNode = node;
                                        continue;
                                    }
                                    duplicateNode = unusedNode;
                                }
                                inits = new HashMap<EStructuralFeature, Object>();
                                inits.put(M2Element.ActivityParameterNode$parameter, param);
                                inits.put(M2Element.ActivityNode$activity, param.eContainer());
                                inits.put(M2Element.NamedElement$name, param.eGet(M2Element.NamedElement$name));
                                if (!PARAMETER_IN.equals(newParam.direction)) break block16;
                                if (outNode != null) {
                                    ((TwcAdapter)this.adapter).deleteElement(outNode);
                                }
                                if (duplicateNode != null) {
                                    ((TwcAdapter)this.adapter).deleteElement(duplicateNode);
                                }
                                if (inNode == null) break block17;
                                if (unusedNode != null) {
                                    ((TwcAdapter)this.adapter).deleteElement(unusedNode);
                                }
                                break block18;
                            }
                            if (unusedNode != null) break block18;
                            this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
                            break block18;
                        }
                        if (!PARAMETER_OUT.equals(newParam.direction) && !PARAMETER_RETURN.equals(newParam.direction)) break block19;
                        if (inNode != null) {
                            ((TwcAdapter)this.adapter).deleteElement(inNode);
                        }
                        if (duplicateNode != null) {
                            ((TwcAdapter)this.adapter).deleteElement(duplicateNode);
                        }
                        if (outNode == null) break block20;
                        if (unusedNode != null) {
                            ((TwcAdapter)this.adapter).deleteElement(unusedNode);
                        }
                        break block18;
                    }
                    if (unusedNode != null) break block18;
                    this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
                    break block18;
                }
                while (nNodes < 2) {
                    this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
                    ++nNodes;
                }
            }
        }
    }

    public static class Parameter
    extends MPAbstractModifier {
        public Parameter(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.Behavior$ownedParameter;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(feature);
        }

        public void add(EObject eObj, EStructuralFeature feature, Object value, int index) throws MPException {
            EObject node;
            if (!Util.isInstanceOf((Object)eObj, (EClass)M2Element.Behavior) || !Util.isInstanceOf((Object)value, (EClass)M2Element.Parameter)) {
                throw new MPInvalidException(String.format("Element %s, feature %s, and value %s are not compatible", eObj, feature, value));
            }
            this.doAdd(eObj, feature, value);
            Param param = Param.valueOf((EObject)value);
            Map<EStructuralFeature, Object> inits = Collections.singletonMap(M2Element.ActivityParameterNode$parameter, value);
            if (param.isInParam()) {
                node = this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
                this.doAdd(eObj, M2Element.Activity$node, node);
            }
            if (param.isOutParam()) {
                node = this.adapter.instantiate(M2Element.ActivityParameterNode, inits);
                this.doAdd(eObj, M2Element.Activity$node, node);
            }
            List actions = Util.getEList((EObject)eObj, (EStructuralFeature)M2Element.Behavior$_callBehaviorActionOfBehavior);
            for (EObject action : actions) {
                if (param.isInParam()) {
                    MPMActivitySync.createAndAddPin(this.adapter, action, M2Element.InvocationAction$argument, param);
                }
                if (!param.isOutParam()) continue;
                MPMActivitySync.createAndAddPin(this.adapter, action, M2Element.CallAction$result, param);
            }
        }
    }

    public static class Behavior
    extends MPAbstractModifier {
        public Behavior(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.CallBehaviorAction$behavior;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(feature);
        }

        public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
            if (!Util.isInstanceOf((Object)eObj, (EClass)M2Element.CallBehaviorAction) || value != null && !Util.isInstanceOf((Object)value, (EClass)M2Element.Behavior)) {
                String message = String.format("The feature %s cannot set value %s to %s", feature, value, eObj);
                throw new MPInvalidException(message);
            }
            this.doSet(eObj, feature, value, oldValue);
            List<Param> params = MPMActivitySync.initParamList(value);
            boolean syncInputPins = true;
            boolean syncOutputPins = false;
            this.syncPins(eObj, params, true);
            this.syncPins(eObj, params, false);
        }

        private void syncPins(EObject eObj, List<Param> params, boolean isInParam) throws MPException {
            Param param;
            EObject pin;
            int i;
            EStructuralFeature feature = isInParam ? M2Element.InvocationAction$argument : M2Element.CallAction$result;
            Predicate<Param> predicate = isInParam ? Param::isInParam : Param::isOutParam;
            ArrayList pins = new ArrayList(Util.getEList((EObject)eObj, (EStructuralFeature)feature));
            List filteredParams = params.stream().filter(predicate).collect(Collectors.toList());
            int nParams = filteredParams.size();
            int nPins = pins.size();
            for (i = 0; i < nPins && i < nParams; ++i) {
                pin = (EObject)pins.get(i);
                param = (Param)filteredParams.get(i);
                this.doSet(pin, M2Element.NamedElement$name, param.name, pin.eGet(M2Element.NamedElement$name));
                this.doSet(pin, M2Element.Element$syncElement, param.param, pin.eGet(M2Element.Element$syncElement));
                this.doSet(pin, M2Element.TypedElement$type, param.type, pin.eGet(M2Element.TypedElement$type));
            }
            if (nParams < nPins) {
                for (i = 0; i < nPins - nParams; ++i) {
                    pin = (EObject)pins.get(nPins - i - 1);
                    Object tmp = pin.eGet(M2Element.Element$syncElement);
                    this.doUnset(eObj, M2Element.Element$syncElement, tmp);
                    pin.eUnset(M2Element.Element$syncElement);
                    ((TwcAdapter)this.adapter).deleteElement(pin);
                    pin.eSet(M2Element.Element$syncElement, tmp);
                    this.doUnset(pin, M2Element.Element$syncElement, tmp);
                }
            } else {
                for (i = 0; i < nParams - nPins; ++i) {
                    int index = nPins + i;
                    param = (Param)filteredParams.get(index);
                    MPMActivitySync.createAndAddPin(this.adapter, eObj, feature, param);
                }
            }
        }
    }

    public static class Type
    extends MPAbstractModifier {
        protected Type(MPBaseAdapter adapter) throws MPException {
            super(adapter);
        }

        public EModelElement getModificationCriteria() {
            return M2Element.TypedElement$type;
        }

        public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
            return eobj.eGet(M2Element.TypedElement$type);
        }

        public EObject init(EObject eObj, EStructuralFeature initFeature, Object initFeatureValue) throws MPException {
            this.doSet(eObj, initFeature, initFeatureValue, null);
            return eObj;
        }

        public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
            if (!this.isNeedingSync(eObj)) {
                this.doSet(eObj, feature, value, oldValue);
                return;
            }
            EObject parameter = this.getParameter(eObj);
            if (!Util.isInstanceOf((Object)parameter, (EClass)M2Element.Parameter)) {
                throw new MPInvalidException("Parameter was not found");
            }
            this.changeActivityParameterNodeType(parameter, value, oldValue);
            this.changePinsType(parameter, value, oldValue);
            this.doSet(parameter, feature, value, oldValue);
        }

        private boolean isNeedingSync(EObject eObj) {
            boolean result = Util.isInstanceOf((Object)eObj, (EClass)M2Element.Parameter) || Util.isInstanceOf((Object)eObj, (EClass)M2Element.ActivityParameterNode) || Util.isInstanceOf((Object)eObj, (EClass)M2Element.Pin);
            return result;
        }

        private EObject getParameter(EObject eObj) {
            if (Util.isInstanceOf((Object)eObj, (EClass)M2Element.Parameter)) {
                return eObj;
            }
            if (Util.isInstanceOf((Object)eObj, (EClass)M2Element.ActivityParameterNode)) {
                return (EObject)eObj.eGet(M2Element.ActivityParameterNode$parameter);
            }
            if (Util.isInstanceOf((Object)eObj, (EClass)M2Element.Pin)) {
                return (EObject)eObj.eGet(M2Element.Element$syncElement);
            }
            return null;
        }

        private void changeActivityParameterNodeType(EObject parameter, Object value, Object oldValue) {
            for (EObject apn : Util.getEList((EObject)parameter, (EStructuralFeature)M2Element.Parameter$_activityParameterNodeOfParameter)) {
                this.doSet(apn, M2Element.TypedElement$type, value, oldValue);
            }
        }

        private void changePinsType(EObject parameter, Object value, Object oldValue) {
            for (EObject pin : Util.getEList((EObject)parameter, (EStructuralFeature)M2Element.Element$_elementOfSyncElement)) {
                this.doSet(pin, M2Element.TypedElement$type, value, oldValue);
            }
        }
    }
}

