/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter.mpm;

import com.maplesoft.maplembse.common.models.twc.MultipleDependencies;
import com.maplesoft.maplembse.common.models.twc.TwcFactory;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import com.maplesoft.maplembse.special.twc.adapter.mpm.dependency.MPMMultipleDependencies;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class ElementUtil {
    private static final Pattern instanceNamePattern = Pattern.compile("([a-zA-Z0-9. ]+)\\[([0-9]+)\\]");
    private static final Function<EObject, String> getName = new Function<EObject, String>(){

        @Override
        public String apply(EObject instance) {
            List classifiers = Util.getEList((EObject)instance, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
            if (classifiers.isEmpty()) {
                return null;
            }
            return (String)((EObject)classifiers.get(0)).eGet(M2Element.NamedElement$name);
        }
    };

    public static Set<EObject> getAllPropertiesFromBlock(EObject block) {
        if (!Util.isInstanceOf((Object)block, (EClass)M2Element.StructuredClassifier)) {
            return Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        Set<EObject> superclasses = ElementUtil.getAllSuperClasses(block);
        for (EObject _class : superclasses) {
            List listToClean = Util.getEList((EObject)_class, (EStructuralFeature)M2Element.StructuredClassifier$ownedAttribute);
            for (EObject property : listToClean) {
                EObject association;
                List elements = Util.getEList((EObject)property, (EStructuralFeature)M2Element.RedefinableElement$redefinedElement);
                if (!elements.isEmpty() || (association = (EObject)property.eGet(M2Element.Property$association)) != null && !(elements = Util.getEList((EObject)association, (EStructuralFeature)M2Element.RedefinableElement$redefinedElement)).isEmpty()) continue;
                result.add(property);
            }
        }
        return result;
    }

    private static Set<EObject> getAllSuperClasses(EObject block) {
        HashSet<EObject> result = new HashSet<EObject>();
        Stack<EObject> classifiersToVisit = new Stack<EObject>();
        classifiersToVisit.push(block);
        while (!classifiersToVisit.isEmpty()) {
            EObject c = (EObject)classifiersToVisit.pop();
            result.add(c);
            for (EObject tmp : Util.getEList((EObject)c, (EStructuralFeature)M2Element.Classifier$general)) {
                classifiersToVisit.push(tmp);
            }
        }
        return result;
    }

    public static EObject createValueSpecification(EObject property, MPBaseAdapter adapter) throws MPInvalidException {
        if (adapter == null) {
            if (ElementUtil.isAttachment(property)) {
                return Util.instantiateEClass((EClass)TwcConstants.ElementValue);
            }
            return Util.instantiateLiteral((EObject)property);
        }
        if (!ElementUtil.isAttachment(property)) {
            return Util.instantiateLiteralWithDefaultValue((EObject)property, (MPBaseAdapter)adapter);
        }
        EObject valueSpecification = Util.instantiateEClass((EClass)TwcConstants.ElementValue);
        EObject defaultValue = (EObject)property.eGet(M2Element.Property$defaultValue);
        if (defaultValue == null || !Util.isInstanceOf((Object)defaultValue, (EClass)TwcConstants.ElementValue)) {
            return null;
        }
        if (!Util.isInstanceOf((Object)defaultValue.eGet(TwcConstants.ElementValue$element), (EClass)M2Element.Comment)) {
            return null;
        }
        adapter.doSet(valueSpecification, TwcConstants.ElementValue$element, defaultValue.eGet(TwcConstants.ElementValue$element), null);
        return valueSpecification;
    }

    public static boolean isAttachment(EObject property) {
        Object type = property.eGet(M2Element.TypedElement$type);
        EObject defaultValue = (EObject)property.eGet(M2Element.Property$defaultValue);
        return type instanceof EObject && ((EObject)type).eGet(M2Element.NamedElement$qualifiedName).equals("UML Standard Profile::UML2 Metamodel::Element") || Util.isInstanceOf((Object)defaultValue, (EClass)TwcConstants.ElementValue);
    }

    public static EObject getEObjectByQualifiedName(String qname, EObject model) {
        if (!(qname instanceof String) || !Util.isInstanceOf((Object)model, (EClass)M2Element.Model)) {
            return null;
        }
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!Util.isInstanceOf((Object)obj, (EClass)M2Element.NamedElement) || !obj.eGet(M2Element.NamedElement$qualifiedName).equals(qname)) continue;
            return obj;
        }
        return null;
    }

    public static EObject setStereotype(MPBaseAdapter adapter, EObject e, String qName) throws MPException {
        EObject is = (EObject)e.eGet(TwcConstants.Element$appliedStereotypeInstance);
        if (is == null) {
            is = Util.instantiateEClass((EClass)TwcConstants.InstanceSpecification);
            StereotypeUtil.addStereotype(adapter, is, qName);
            adapter.doSet(e, TwcConstants.Element$appliedStereotypeInstance, (Object)is, null);
        } else {
            StereotypeUtil.addStereotype(adapter, is, qName);
        }
        return is;
    }

    public static void setNestedConnectorEndStereotype(MPBaseAdapter adapter, EObject end, EObject value) throws MPException {
        if (TwcConstants.Element$appliedStereotype != null) {
            EObject st = StereotypeUtil.addStereotype(adapter, end, "SysML::Blocks::NestedConnectorEnd");
            EObject elementtaggedvalue = Util.instantiateEClass((EClass)TwcConstants.ElementTaggedValue);
            Optional<EObject> definingFeature = ElementUtil.getAllPropertiesFromBlock(st).stream().filter(p -> "SysML::Blocks::ElementPropertyPath::propertyPath".equals(p.eGet(M2Element.NamedElement$qualifiedName))).findFirst();
            assert (definingFeature.isPresent());
            adapter.doSet(elementtaggedvalue, TwcConstants.TaggedValue$tagDefinition, (Object)definingFeature.get(), null);
            adapter.doSet(elementtaggedvalue, TwcConstants.TaggedValue$taggedValueOwner, (Object)end, null);
            adapter.doAdd(elementtaggedvalue, TwcConstants.ElementTaggedValue$value, (Object)value);
        } else if (TwcConstants.Element$appliedStereotypeInstance != null) {
            EObject is = ElementUtil.setStereotype(adapter, end, "SysML::Blocks::NestedConnectorEnd");
            EObject slot = ElementUtil.addSlot(adapter, is, end, "SysML::Blocks::ElementPropertyPath::propertyPath");
            EObject specification = Util.instantiateEClass((EClass)TwcConstants.ElementValue);
            adapter.doSet(specification, TwcConstants.ElementValue$element, (Object)value, null);
            adapter.doAdd(slot, TwcConstants.Slot$value, (Object)specification);
        }
    }

    public static EObject addSlot(MPBaseAdapter adapter, EObject is, EObject e, String qName) {
        Objects.requireNonNull(is);
        EObject s = ElementUtil.getSlot(is, qName);
        if (s != null) {
            return s;
        }
        TwcResource resourceWrapper = (TwcResource)adapter.getResource();
        EObject p = resourceWrapper.getProperty(qName);
        if (p == null) {
            return null;
        }
        if (qName == null) {
            return null;
        }
        s = Util.instantiateEClass((EClass)TwcConstants.Slot);
        adapter.doSet(s, TwcConstants.Slot$definingFeature, (Object)p, null);
        adapter.doAdd(is, TwcConstants.InstanceSpecification$slot, (Object)s);
        return s;
    }

    public static EObject addSlot(MPBaseAdapter adapter, EObject owner, EObject property) {
        EObject s;
        Objects.requireNonNull(property);
        EObject is = (EObject)owner.eGet(TwcConstants.Element$appliedStereotypeInstance);
        if (is == null) {
            is = Util.instantiateEClass((EClass)TwcConstants.InstanceSpecification);
            adapter.doAdd(owner, TwcConstants.Element$appliedStereotypeInstance, (Object)is);
        }
        if ((s = ElementUtil.getSlot(is, property)) != null) {
            return s;
        }
        s = Util.instantiateEClass((EClass)TwcConstants.Slot);
        adapter.doSet(s, TwcConstants.Slot$definingFeature, (Object)property, null);
        adapter.doAdd(is, TwcConstants.InstanceSpecification$slot, (Object)s);
        return s;
    }

    public static EObject getSlot(EObject is, String qName) {
        Objects.requireNonNull(TwcConstants.Element$appliedStereotypeInstance);
        if (qName == null || qName.trim().isEmpty()) {
            return null;
        }
        List slots = Util.getEList((EObject)is, (EStructuralFeature)TwcConstants.InstanceSpecification$slot);
        for (EObject s : slots) {
            EObject sf = (EObject)s.eGet(TwcConstants.Slot$definingFeature);
            if (sf == null || !qName.equals(sf.eGet(M2Element.NamedElement$qualifiedName))) continue;
            return s;
        }
        return null;
    }

    public static EObject getSlot(EObject is, EObject property) {
        Objects.requireNonNull(TwcConstants.Element$appliedStereotypeInstance);
        Objects.requireNonNull(property);
        List slots = Util.getEList((EObject)is, (EStructuralFeature)TwcConstants.InstanceSpecification$slot);
        for (EObject s : slots) {
            EObject sf = (EObject)s.eGet(TwcConstants.Slot$definingFeature);
            if (sf == null || !property.equals(sf)) continue;
            return s;
        }
        return null;
    }

    public static EObject getTagValue(EObject element, String propertyQName) {
        Objects.requireNonNull(TwcConstants.Element$appliedStereotype);
        List tags = Util.getEList((EObject)element, (EStructuralFeature)TwcConstants.Element$taggedValue);
        if (tags.isEmpty()) {
            return null;
        }
        return tags.stream().filter(t -> {
            EObject tdf = (EObject)t.eGet(TwcConstants.TaggedValue$tagDefinition);
            if (tdf == null) {
                return false;
            }
            return tdf.eGet(M2Element.NamedElement$qualifiedName).equals(propertyQName);
        }).findFirst().orElse(null);
    }

    public static EObject getTagValue(EObject element, EObject property) {
        Objects.requireNonNull(TwcConstants.Element$appliedStereotype);
        List tags = Util.getEList((EObject)element, (EStructuralFeature)TwcConstants.Element$taggedValue);
        if (tags.isEmpty()) {
            return null;
        }
        return tags.stream().filter(t -> {
            EObject tdf = (EObject)t.eGet(TwcConstants.TaggedValue$tagDefinition);
            if (tdf == null) {
                return false;
            }
            return tdf.equals(property);
        }).findFirst().orElse(null);
    }

    public static void addTagValue(MPBaseAdapter adapter, EObject element, EObject property, Object value) {
        EObject tag = ElementUtil.getTagValue(element, property);
        if (tag == null) {
            tag = Util.instantiateEClass((EClass)TwcConstants.ElementTaggedValue);
            adapter.doSet(tag, TwcConstants.TaggedValue$tagDefinition, (Object)property, null);
            adapter.doSet(tag, TwcConstants.TaggedValue$taggedValueOwner, (Object)element, null);
        }
        assert (Util.isInstanceOf((Object)tag, (EClass)TwcConstants.ElementTaggedValue));
        adapter.doAdd(tag, TwcConstants.ElementTaggedValue$value, value);
    }

    public static void addSlotElementValue(MPBaseAdapter adapter, EObject slot, EObject value) {
        EObject elementValue = Util.instantiateEClass((EClass)TwcConstants.ElementValue);
        adapter.doSet(elementValue, TwcConstants.ElementValue$element, (Object)value, null);
        adapter.doAdd(slot, TwcConstants.Slot$value, (Object)elementValue, -1);
    }

    public static boolean objectEqualCheck(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (!(obj1 instanceof EObject) || !(obj2 instanceof EObject)) {
            return Objects.deepEquals(obj1, obj2);
        }
        EObject eo1 = (EObject)obj1;
        EObject eo2 = (EObject)obj2;
        if (!Util.isInstanceOf((Object)eo1, (EClass)M2Element.NamedElement) || !Util.isInstanceOf((Object)eo2, (EClass)M2Element.NamedElement)) {
            return false;
        }
        Object eo1Name = eo1.eGet(M2Element.NamedElement$qualifiedName);
        Object eo2Name = eo2.eGet(M2Element.NamedElement$qualifiedName);
        return Objects.equals(eo1Name, eo2Name);
    }

    public static EObject findInstanceSpecification(EObject context, String name) {
        Matcher matcher = instanceNamePattern.matcher(name);
        boolean isFind = matcher.find();
        int index = isFind ? Integer.valueOf(matcher.group(2)) - 1 : 0;
        String tmp = isFind ? matcher.group(1) : name;
        Map map = Util.getEList((EObject)context, (EStructuralFeature)TwcConstants.InstanceSpecification$slot).stream().filter(s -> StereotypeUtil.isPartProperty((EObject)s.eGet(TwcConstants.Slot$definingFeature)) || StereotypeUtil.isMbpleFeature((EObject)s.eGet(TwcConstants.Slot$definingFeature))).map(s -> {
            try {
                return (EObject)Util.getEList((EObject)s, (EStructuralFeature)TwcConstants.Slot$value).get(index);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(v -> Util.isInstanceOf((Object)v, (EClass)TwcConstants.InstanceValue)).map(v -> (EObject)v.eGet(TwcConstants.InstanceValue$instance)).filter(Objects::nonNull).filter(in -> !Util.isInstanceOf((Object)in, (EClass)M2Element.EnumerationLiteral)).collect(Collectors.toMap(getName, Function.identity()));
        return (EObject)map.get(tmp);
    }

    public static List<EObject> getTopLevelInstances(EObject instance) {
        Stack<EObject> needToVisit = new Stack<EObject>();
        needToVisit.push(instance);
        ArrayList<EObject> visited = new ArrayList();
        while (!needToVisit.isEmpty()) {
            EObject tmp = (EObject)needToVisit.pop();
            if (visited.contains(tmp)) continue;
            for (EObject v : Util.getEList((EObject)tmp, (EStructuralFeature)TwcConstants.InstanceSpecification$_instanceValueOfInstance)) {
                EObject owSlot = (EObject)v.eGet(TwcConstants.ValueSpecification$owningSlot);
                if (owSlot == null) continue;
                needToVisit.push((EObject)owSlot.eGet(TwcConstants.Slot$owningInstance));
            }
            visited.add(tmp);
        }
        visited = visited.stream().filter(in -> Util.getEList((EObject)in, (EStructuralFeature)TwcConstants.InstanceSpecification$_instanceValueOfInstance).isEmpty()).filter(Objects::nonNull).collect(Collectors.toList());
        return visited;
    }

    public static MultipleDependencies lookupDepOrCreate(Map<MPMMultipleDependencies.MultipleDependencyInternal, MultipleDependencies> multipleDependencies, EObject client, EObject supplier, EObject _package) {
        MultipleDependencies mdp;
        MPMMultipleDependencies.MultipleDependencyInternal key = new MPMMultipleDependencies.MultipleDependencyInternal(_package, client, supplier);
        if (!multipleDependencies.isEmpty() && (mdp = multipleDependencies.get(key)) != null) {
            return mdp;
        }
        MultipleDependencies createMultipleDependencies = TwcFactory.eINSTANCE.createMultipleDependencies();
        createMultipleDependencies.setClient(client);
        createMultipleDependencies.setSupplier(supplier);
        createMultipleDependencies.setOwner(_package);
        multipleDependencies.put(key, createMultipleDependencies);
        return createMultipleDependencies;
    }
}

