/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.special.twc.adapter.TwcParameters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPException;

public abstract class TwcResource
implements Resource.Internal {
    public static final Logger LOGGER = Logger.getLogger(TwcResource.class);
    protected static final String ID_PREFIX = "_MapleMBSE_";
    protected BasicNotifierImpl.EAdapterList<Adapter> adapters = new BasicNotifierImpl.EAdapterList((Notifier)this);
    protected boolean isLoading;
    protected Resource resource;
    private boolean failedToAccquireLockForSnapshot = false;
    private String attachedFilePath = null;
    private static String userDefinedPath = System.getProperty("com.maplesoft.maplembse.adapter.file.attachement.path");
    private String mapleMBSEDataFolder = userDefinedPath != null && !userDefinedPath.isEmpty() ? userDefinedPath : System.getenv("TMP") + "\\MapleMBSE.tmp\\data";

    public abstract void applySnapshot(String var1) throws MPException;

    public abstract void checkServerlatestRevision();

    public abstract boolean commit(TwcParameters var1, Map<MPAdapter.SaveOption, Object> var2) throws MPException;

    public abstract Set<EObject> getAddedObjects();

    public abstract String getBranchName();

    public abstract UUID getBranchUUID();

    public abstract Set<EObject> getDeletedObjects();

    public abstract String getID(Object var1);

    public abstract EObject getModel();

    public abstract List<EObject> getObjectsByClass(EClassifier var1);

    public abstract List<EObject> getProperties();

    public abstract EObject getProperty(String var1);

    public abstract UUID getResourceUUID();

    public abstract List<String> getSnapshotKeys();

    public abstract EObject getStereotype(String var1);

    public abstract List<EObject> getStereotypes();

    public abstract TransactionalEditingDomain getTransactionalEditingDomain();

    public abstract Set<EObject> getUpdatedObjects();

    public abstract void refresh();

    public abstract boolean reload(TwcParameters var1);

    public abstract void resetNotification();

    public static String generateID() {
        return ID_PREFIX + UUID.randomUUID().toString();
    }

    public void delete(Map<?, ?> options) throws IOException {
        this.resource.delete(options);
    }

    public EList<Adapter> eAdapters() {
        return this.adapters;
    }

    public boolean eDeliver() {
        return this.resource.eDeliver();
    }

    public void eNotify(Notification notification) {
        for (Adapter a : this.adapters) {
            a.notifyChanged(notification);
        }
    }

    public void eSetDeliver(boolean deliver) {
        this.resource.eSetDeliver(deliver);
    }

    public EObject getEObject(String uriFragment) {
        return this.resource.getEObject(uriFragment);
    }

    public EList<Resource.Diagnostic> getErrors() {
        return this.resource.getErrors();
    }

    public ResourceSet getResourceSet() {
        return this.resource.getResourceSet();
    }

    public long getTimeStamp() {
        return this.resource.getTimeStamp();
    }

    public String getURIFragment(EObject eObject) {
        return this.resource.getURIFragment(eObject);
    }

    public EList<Resource.Diagnostic> getWarnings() {
        return this.resource.getWarnings();
    }

    public boolean isLoaded() {
        return this.resource.isLoaded();
    }

    public boolean isModified() {
        try {
            return this.resource.isModified();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean isTrackingModification() {
        return this.resource.isTrackingModification();
    }

    public void load(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            this.isLoading = true;
            this.resource.load(inputStream, options);
        }
        finally {
            this.isLoading = false;
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        try {
            this.isLoading = true;
            this.resource.load(options);
        }
        finally {
            this.isLoading = false;
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        this.resource.save(options);
    }

    public void save(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.resource.save(outputStream, options);
    }

    public void setModified(boolean isModified) {
        this.resource.setModified(isModified);
    }

    public void setTimeStamp(long timeStamp) {
        this.resource.setTimeStamp(timeStamp);
    }

    public void setTrackingModification(boolean isTrackingModification) {
        this.resource.setTrackingModification(isTrackingModification);
    }

    public void setURI(URI uri) {
        this.resource.setURI(uri);
    }

    public void attached(EObject eObject) {
        if (this.resource instanceof Resource.Internal) {
            ((Resource.Internal)this.resource).attached(eObject);
        }
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        if (this.resource instanceof Resource.Internal) {
            return ((Resource.Internal)this.resource).basicSetResourceSet(resourceSet, notifications);
        }
        return null;
    }

    public void detached(EObject eObject) {
        if (this.resource instanceof Resource.Internal) {
            ((Resource.Internal)this.resource).detached(eObject);
        }
    }

    public boolean isLoading() {
        if (this.isLoading) {
            return true;
        }
        if (this.resource instanceof Resource.Internal) {
            ((Resource.Internal)this.resource).isLoading();
        }
        return false;
    }

    public Resource getResource() {
        return this.resource;
    }

    protected abstract Object reset();

    public boolean isFailedToAccquireLockForSnapshot() {
        return this.failedToAccquireLockForSnapshot;
    }

    public void setFailedToAccquireLockForSnapshot(boolean failedToAccquireLockForSnapshot) {
        this.failedToAccquireLockForSnapshot = failedToAccquireLockForSnapshot;
    }

    protected String downloadedFilePath() {
        if (this.attachedFilePath == null) {
            this.attachedFilePath = this.mapleMBSEDataFolder;
        }
        return this.attachedFilePath;
    }

    public abstract String getFilefromServer(EObject var1);

    public abstract EObject fileSearchAndGetObject(String var1);

    public abstract String attachmentFileSelection(String var1);

    public abstract String getCategory();
}

