/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class TwcParameters
extends Observable {
    public static final String BRANCH_UNSPECIFIED = "UNSPECIFIED";
    static final String DEFAULT_PORT = "3579";
    public static final Logger LOGGER = Logger.getLogger(TwcParameters.class);
    private String branch;
    private List<String> branches = Collections.emptyList();
    private boolean cancel;
    private Collection<String> categories = Collections.emptyList();
    private String category;
    private String host;
    private boolean isCacheEnabled;
    private boolean isCategoryFiltered = false;
    private boolean isCategoryListUpdated = false;
    private boolean isHeadRevision;
    private boolean loaded = false;
    private String message;
    private boolean isProjectListUpdated = false;
    private String password;
    private String port;
    private String project;
    private Collection<String> projects = Collections.emptySet();
    private Map<String, String> queryMap;
    private long revision = -1L;
    private boolean settingsSaved;
    private String sslKeyName;
    private String token;
    private String username;
    private boolean canLogin = true;

    public TwcParameters(URI uri) {
        if (uri != null) {
            this.setURI(uri);
        }
        this.clearChanged();
    }

    public void clearBranches() {
        this.branches.clear();
        this.setChanged();
    }

    public void clearLoaded() {
        this.loaded = false;
    }

    public void clearMessage() {
        this.message = "";
    }

    public void clearCategoryListChange() {
        this.isCategoryListUpdated = false;
    }

    public void clearProjectListChange() {
        this.isProjectListUpdated = false;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isSSO() {
        return this.token != null && !this.token.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TwcParameters)) {
            return false;
        }
        TwcParameters tmp = (TwcParameters)obj;
        if (!Objects.equals(this.branch, tmp.branch)) {
            return false;
        }
        if (!Objects.equals(this.host, tmp.host)) {
            return false;
        }
        if (!Objects.equals(this.password, tmp.password)) {
            return false;
        }
        if (!Objects.equals(this.port, tmp.port)) {
            return false;
        }
        if (!Objects.equals(this.project, tmp.project)) {
            return false;
        }
        if (this.revision != tmp.revision) {
            return false;
        }
        if (!Objects.equals(this.sslKeyName, tmp.sslKeyName)) {
            return false;
        }
        return Objects.equals(this.username, tmp.username);
    }

    public String getBranch() {
        if (this.branch == null) {
            this.branch = "";
        }
        return this.branch;
    }

    public List<String> getBranchList() {
        return this.branches;
    }

    public String getCatergory() {
        return this.category;
    }

    public Collection<String> getCategorytList() {
        return this.categories;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = "";
        }
        return this.host;
    }

    public String getHostPort() {
        String host = this.host == null ? "" : this.host;
        return host + ":" + this.port;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = "";
        }
        return this.message;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPort() {
        if (this.port == null) {
            this.port = DEFAULT_PORT;
        }
        return this.port;
    }

    public String getProject() {
        if (this.project == null) {
            this.project = "";
        }
        return this.project;
    }

    public Collection<String> getProjectList() {
        return this.projects;
    }

    private Map<String, String> getQueryMap() {
        if (this.hasChanged() || this.queryMap == null) {
            this.queryMap = new HashMap<String, String>();
            this.queryMap.put("branch", this.getBranch());
            this.queryMap.put("cache", String.valueOf(this.isCacheEnabled));
            this.queryMap.put("category", this.getCatergory());
            this.queryMap.put("password", this.password);
            this.queryMap.put("revision", String.valueOf(this.getRevision()));
            this.queryMap.put("settings_saved", String.valueOf(this.settingsSaved));
            this.queryMap.put("ssl", this.getSSLKeyName());
            this.queryMap.put("token", this.getToken());
            this.queryMap.put("username", this.getUsername());
        }
        return this.queryMap;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getSSLKeyName() {
        if (this.sslKeyName == null) {
            this.sslKeyName = "";
        }
        return this.sslKeyName;
    }

    public URI getURI(String format) {
        boolean revisionAsFragment = format.contains("#");
        if (revisionAsFragment) {
            format = format.substring(0, format.indexOf("#"));
        }
        StringBuilder sb = new StringBuilder();
        List<String> keys = Arrays.asList(format.split("&"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.getQueryMap());
        map.put("host", this.getHost());
        map.put("port", this.getPort());
        map.put("project", URI.encodeQuery((String)this.getProject(), (boolean)false));
        map.put("token", this.getToken());
        assert (map.keySet().containsAll(keys));
        sb.append(String.format("twc://%s:%s/%s?", map.get("host"), map.get("port"), map.get("project")));
        boolean first = true;
        for (String value : keys) {
            if ("host".equals(value) || "port".equals(value) || "project".equals(value) || !map.keySet().contains(value)) continue;
            sb.append(String.format("%s%s=%s", first ? "" : "&", value, URI.encodeQuery((String)((String)map.get(value)), (boolean)false)));
            first = false;
        }
        URI uri = URI.createURI((String)sb.toString());
        if (revisionAsFragment) {
            uri = uri.appendFragment(String.valueOf(this.revision));
        }
        return uri;
    }

    public String getUsername() {
        if (this.username == null) {
            this.username = "";
        }
        return this.username;
    }

    private boolean hasSameQuery(String query) {
        Map<String, String> map = TwcParameters.queryToMap(query);
        if (!this.getQueryMap().keySet().containsAll(map.keySet())) {
            return false;
        }
        for (String key : map.keySet()) {
            if (Objects.equals(this.queryMap.get(key), map.get(key)) || "port".equals(key) && map.get(key) == null && this.getPort().equals(DEFAULT_PORT)) continue;
            if ("revision".equals(key)) {
                long r = -1L;
                try {
                    r = Long.valueOf(map.get(key));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.revision == r) continue;
            }
            if (this.queryMap.get(key) == null && map.get(key).isEmpty()) continue;
            return false;
        }
        HashSet<String> missing = new HashSet<String>();
        missing.addAll(this.queryMap.keySet());
        missing.removeAll(map.keySet());
        return !missing.contains("username") && !missing.contains("password");
    }

    public boolean hasSameResource(URI uri) {
        String path = uri.path();
        if (path == null || path.equals("") || path.equals("/")) {
            path = "";
        }
        if (path.contains("/")) {
            path = path.replaceAll("/", "");
        }
        if (!Objects.equals(this.getProject(), URI.decode((String)path))) {
            return false;
        }
        String query = uri.query();
        if (query == null) {
            query = "";
        }
        Map<String, String> map = TwcParameters.queryToMap(query);
        long r = -1L;
        String revision = URI.decode((String)map.get("revision"));
        try {
            r = Long.valueOf(revision);
            if (r < -1L) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.revision != r) {
            return false;
        }
        String branchTmp = URI.decode((String)map.get("branch"));
        if (this.revision != -1L && "".equals(branchTmp)) {
            return true;
        }
        if (branchTmp == null || branchTmp.isEmpty()) {
            branchTmp = "trunk";
        }
        return Objects.equals(branchTmp, this.getBranch()) || this.branch.isEmpty() && "trunk".equals(branchTmp);
    }

    public boolean hasSameSession(URI uri) {
        String ssl;
        if (!Objects.equals(uri.host(), this.host)) {
            return false;
        }
        String tmpPort = uri.port();
        if (tmpPort == null) {
            tmpPort = DEFAULT_PORT;
        }
        if (!Objects.equals(tmpPort, this.port)) {
            return false;
        }
        String query = uri.query();
        if (query == null) {
            query = "";
        }
        Map<String, String> map = TwcParameters.queryToMap(query);
        if (this.isSSO()) {
            if (!this.getToken().equals(map.get("token"))) {
                return false;
            }
        } else {
            if (!Objects.equals(URI.decode((String)map.get("username")), this.username)) {
                return false;
            }
            if (!Objects.equals(URI.decode((String)map.get("password")), this.password)) {
                return false;
            }
        }
        if ((ssl = map.get("ssl")) == null || "none".equals(ssl)) {
            ssl = "";
        }
        return Objects.equals(ssl, this.getSSLKeyName());
    }

    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    boolean isCancelled() {
        return this.cancel;
    }

    public boolean isCategoryFiltered() {
        return this.isCategoryFiltered;
    }

    public boolean isCategoryListUpdated() {
        return this.isCategoryListUpdated;
    }

    public boolean isConnectable() {
        return this.host != null && !this.host.trim().isEmpty() && (this.token != null && !this.token.isEmpty() || this.username != null && !this.username.trim().isEmpty() && this.password != null && !this.password.isEmpty());
    }

    public boolean isHeadRevision() {
        return this.isHeadRevision;
    }

    public boolean isLoaded() {
        return !this.isCancelled() && this.loaded;
    }

    public boolean isProjectListUpdated() {
        return this.isProjectListUpdated;
    }

    public boolean isSettingsSaved() {
        return this.settingsSaved;
    }

    public boolean isSSLEnabled() {
        return this.sslKeyName != null && !this.sslKeyName.isEmpty();
    }

    public void setBranch(String branch) {
        String tmp2;
        if (Objects.equals(this.branch, branch)) {
            return;
        }
        String tmp = this.branch;
        if (tmp == null || tmp.isEmpty()) {
            tmp = "trunk";
        }
        if ((tmp2 = branch) == null || tmp2.isEmpty()) {
            tmp2 = "trunk";
        }
        this.branch = branch;
        if (!Objects.equals(tmp, tmp2)) {
            this.setChanged();
        }
    }

    public void setBranches(List<String> branchList) {
        this.branches = branchList;
    }

    public void setCacheEnabled(boolean isCacheEnabled) {
        if (this.isCacheEnabled == isCacheEnabled) {
            return;
        }
        this.isCacheEnabled = isCacheEnabled;
        this.setChanged();
    }

    private void setCancel() {
        this.cancel = true;
    }

    public void setCategory(String category) {
        if ("null".equals(category)) {
            category = null;
        }
        if (Objects.equals(this.category, category)) {
            return;
        }
        this.category = category;
        this.setChanged();
    }

    public void setCategoryFiltered(boolean isCategoryFiltered) {
        if (Objects.equals(this.isCategoryFiltered, isCategoryFiltered)) {
            return;
        }
        this.isCategoryFiltered = isCategoryFiltered;
        this.setChanged();
    }

    public void setCategoryList(Collection<String> categories) {
        this.categories = categories;
        this.isCategoryListUpdated = true;
    }

    public void setHost(String host) {
        if (Objects.equals(this.host, host)) {
            return;
        }
        this.host = host;
        this.setToken(null);
        this.canLogin = true;
        this.setChanged();
    }

    public void setLoaded() {
        this.setChanged();
        this.loaded = true;
    }

    public void setMessage(String message) {
        if (message != null) {
            message = message.replace("(null)", "").replace("()", "");
        }
        if (Objects.equals(this.message, message)) {
            return;
        }
        if ((this.username == null || this.username.isEmpty()) && !this.isSSO()) {
            message = "Please enter username";
        } else if ((this.password == null || this.password.isEmpty()) && !this.isSSO()) {
            message = "Please enter password";
        }
        this.message = message;
        this.setChanged();
    }

    public void setPassword(String password) {
        if (Objects.equals(this.password, password)) {
            return;
        }
        this.password = password;
        this.setChanged();
        this.setToken(null);
    }

    public void setPort(String port) {
        String tmp = DEFAULT_PORT;
        if (port == null) {
            if (DEFAULT_PORT.equals(this.port)) {
                return;
            }
        } else {
            if (port.equals(this.port)) {
                return;
            }
            tmp = port;
        }
        this.port = tmp;
        this.canLogin = true;
        this.setChanged();
    }

    public void setProject(String path) {
        String tmp;
        String p;
        if (path == null || path.isEmpty()) {
            if (this.project != null && !this.project.isEmpty()) {
                this.project = null;
                this.setChanged();
            }
            return;
        }
        if (path.charAt(0) == '/') {
            path = path.trim().substring(1);
        }
        if (Objects.equals(p = URI.decode((String)path), this.project)) {
            return;
        }
        String string = p == null ? null : (tmp = p.trim().isEmpty() ? null : p.trim());
        if (!Objects.equals(tmp, this.project)) {
            this.project = tmp;
            this.setChanged();
        }
    }

    public void setProjectList(Collection<String> projects) {
        this.projects = projects;
        this.isProjectListUpdated = true;
    }

    private void setQuery(String query) {
        if (this.hasSameQuery(query)) {
            return;
        }
        Map<String, String> queryMap = TwcParameters.queryToMap(query);
        if (queryMap.get("token") != null) {
            this.setToken(URI.decode((String)queryMap.get("token")));
        } else {
            this.setUsername(URI.decode((String)queryMap.get("username")));
            this.setPassword(URI.decode((String)queryMap.get("password")));
        }
        this.setCategory(URI.decode((String)queryMap.get("category")));
        this.setBranch(URI.decode((String)queryMap.get("branch")));
        this.setSSLKeyName(URI.decode((String)queryMap.get("ssl")));
        this.setCacheEnabled(Boolean.parseBoolean(URI.decode((String)queryMap.get("cache"))));
        this.settingsSaved = Boolean.valueOf(URI.decode((String)queryMap.get("settings_saved")));
        StringBuilder sb = new StringBuilder();
        try {
            byte[] hashInBytes;
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (byte b : hashInBytes = md.digest(URI.decode((String)queryMap.get("loaded")).getBytes(StandardCharsets.UTF_8))) {
                sb.append(String.format("%02x", b));
            }
        }
        catch (Exception e) {
            sb = new StringBuilder("");
        }
        if ("906784f9a814a42f3208af0b0471c0a4".equals(sb.toString())) {
            this.setLoaded();
        } else if ("f3ea013a9c6c91882a0adbd6297a74a6".equals(sb.toString())) {
            this.clearLoaded();
            this.setCancel();
        }
        long r = -1L;
        try {
            r = Long.parseLong(URI.decode((String)queryMap.get("revision")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setRevision(r);
        this.getQueryMap();
        this.setChanged();
    }

    void setRevision(long revision) {
        if (revision < -1L || revision == 0L) {
            this.setBranch(BRANCH_UNSPECIFIED);
            revision = -1L;
        }
        if (this.revision == revision || this.project == null || this.project.isEmpty()) {
            return;
        }
        this.revision = revision;
        this.setChanged();
    }

    void setSettingsSaved(boolean bool) {
        this.settingsSaved = bool;
    }

    public void setSSLKeyName(String keyName) {
        if ("none".equals(keyName)) {
            keyName = null;
        }
        if (Objects.equals(this.sslKeyName, keyName)) {
            return;
        }
        this.setChanged();
        this.canLogin = true;
        this.sslKeyName = keyName;
    }

    public void setURI(URI uri) {
        this.setHost(uri.host());
        this.setPort(uri.port());
        String path = uri.path();
        this.setProject(URI.decode((String)path));
        String tmp = uri.query() == null ? "" : uri.query();
        this.setQuery(tmp);
    }

    public void setUsername(String username) {
        if (Objects.equals(this.username, username)) {
            return;
        }
        this.username = username;
        this.setChanged();
        this.setToken(null);
    }

    public void updateToHeadRevision(TwcAdapter adapter) {
        this.setRevision(adapter.getTwcResourceBridge().getLatestRevision(adapter));
        this.isHeadRevision = true;
    }

    static String format(URI uri) {
        TwcParameters p = new TwcParameters(uri);
        StringBuilder sb = new StringBuilder();
        if (p.host != null) {
            sb.append("host");
        }
        if (p.port != null) {
            sb.append("&port");
        }
        if (p.project != null) {
            sb.append("&project");
        }
        String query = uri.query();
        String[] pairs = query.split("&");
        for (int i = 0; i < pairs.length; ++i) {
            sb.append("&" + pairs[i].split("=")[0]);
        }
        return sb.toString();
    }

    private static Map<String, String> queryToMap(String query) {
        Stream pairs = TwcParameters.split(query).stream();
        Map<String, String> map = pairs.map(TwcParameters::splitPairs).filter(Objects::nonNull).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        return map;
    }

    private static List<String> split(String query) {
        String[] params = query.split("\\&");
        ArrayList<String> list = new ArrayList<String>();
        if (query.isEmpty()) {
            return list;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].contains("username") || params[i].contains("password") || params[i].contains("branch") || params[i].contains("revision") || params[i].contains("ssl") || params[i].contains("cache") || params[i].contains("settings_saved") || params[i].contains("token") || params[i].contains("project") || params[i].contains("loaded") || params[i].contains("category")) {
                list.add(params[i]);
                continue;
            }
            String tmp = (String)list.get(list.size() - 1) + "&" + params[i];
            list.remove(list.get(list.size() - 1));
            list.add(tmp);
        }
        return list;
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> splitPairs(String str) {
        if (!str.contains("=")) {
            return null;
        }
        boolean emptyValue = str.indexOf(61) == str.length() - 1;
        String[] split = str.split("=");
        if (split.length == 2 && str.length() > str.indexOf(61)) {
            split[1] = str.substring(str.indexOf(61) + 1);
        }
        if (str.length() > str.indexOf(61) && split.length > 2) {
            String afterEqual;
            split[1] = afterEqual = str.substring(str.indexOf(61) + 1);
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(split[0], emptyValue ? "" : split[1]);
    }

    public boolean canLogin() {
        return this.canLogin;
    }

    public void setCannotLogin() {
        this.canLogin = false;
    }
}

