/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import com.maplesoft.maplembse.special.twc.adapter.TwcInitFactory;
import com.maplesoft.maplembse.special.twc.adapter.TwcInject;
import com.maplesoft.maplembse.special.twc.adapter.TwcManager;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import org.openmbee.mpspi.exceptions.MPException;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class TwcBridge {
    private static TwcInitFactory initFactory;
    private static TwcManager twcManager;
    private static TwcInject twcInject;

    public static void initializeFactory(String nsURI, Bundle thisBundle) throws MPException {
        if (initFactory != null) {
            return;
        }
        ServiceReference serviceReference = thisBundle.getBundleContext().getServiceReference(TwcInitFactory.class);
        try {
            initFactory = (TwcInitFactory)thisBundle.getBundleContext().getService(serviceReference);
        }
        catch (Exception e) {
            throw new IllegalStateException("Not yet initFactory is initialized. check the installation");
        }
        twcInject = initFactory.createInject(nsURI);
        twcInject.inject();
        twcManager = initFactory.createManager();
    }

    public static void initStereotypeUtil(String nsURI, TwcAdapter adapter) {
        switch (nsURI) {
            case "http://www.nomagic.com/magicdraw/UML/2.5.1": {
                StereotypeUtil.init(new StereotypeUtil.Stereotype19(adapter));
                break;
            }
            case "http://www.nomagic.com/magicdraw/UML/2.5.1.1": {
                StereotypeUtil.init(new StereotypeUtil.Stereotype2021(adapter));
            }
        }
    }

    public static TwcInitFactory getInitFactory() {
        if (initFactory == null) {
            throw new IllegalStateException("Not yet initFactory is initialized.");
        }
        return initFactory;
    }

    public static TwcManager getTwcManager() {
        if (twcManager == null) {
            twcManager = TwcBridge.getInitFactory().createManager();
        }
        return twcManager;
    }

    public static TwcInject getTwcInject() {
        if (twcInject == null) {
            throw new IllegalStateException("Not yet twcManager is initialized.");
        }
        return twcInject;
    }

    public static void clearTwcManager() {
        twcManager = null;
    }
}

