/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.special.twc.adapter.TwcAdapter;
import java.util.Timer;
import java.util.TimerTask;

public class TwcAutosave
extends TimerTask {
    private static final long autosaveInterval = 600000L;
    private static final long idleInterval = 60000L;
    private static final long executionInterval = Math.min(60000L, 600000L);
    private final TwcAdapter adapter;

    private TwcAutosave(TwcAdapter adapter) {
        this.adapter = adapter;
    }

    public static void start(TwcAdapter adapter) {
        TwcAutosave task = new TwcAutosave(adapter);
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)task, 0L, executionInterval);
    }

    private boolean needAutosave() {
        long currentTime = System.currentTimeMillis();
        long lastAutosave = this.adapter.getLastAutosave();
        long lastModelEdit = this.adapter.getLastModelEdit();
        long lastModelAccess = this.adapter.getLastModelAccess();
        if (lastAutosave >= lastModelEdit) {
            return false;
        }
        long lastAutosavePeriod = currentTime - lastAutosave;
        if (600000L > lastAutosavePeriod) {
            return false;
        }
        long idlePeriod = currentTime - Math.max(lastModelEdit, lastModelAccess);
        return 60000L <= idlePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TwcAdapter twcAdapter = this.adapter;
        synchronized (twcAdapter) {
            if (this.adapter.getTwcAccess() != null) {
                this.adapter.keepAlive();
                if (this.needAutosave()) {
                    this.adapter.autosave();
                }
            }
        }
    }
}

