/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.common.models.twc.MultipleDependencies;
import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPANM_GetRecursively;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMActivityControlFlow;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMActivityObjectFlow;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMActivityPartitionAllocation;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMActivitySwimlane;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMConnectorEndRole;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMDependencies;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMDurationConstraint;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMGetRecursively;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMMultiplicity;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMOtherAssociationEnd;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMPackageElement;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPMVertexTransition;
import com.maplesoft.maplembse.license.CheckLicense;
import com.maplesoft.maplembse.magicdraw.plugin.api.MagicDrawServices;
import com.maplesoft.maplembse.special.twc.adapter.Activator;
import com.maplesoft.maplembse.special.twc.adapter.MagicDrawServiceUtil;
import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import com.maplesoft.maplembse.special.twc.adapter.MessageUtil;
import com.maplesoft.maplembse.special.twc.adapter.TwcAccess;
import com.maplesoft.maplembse.special.twc.adapter.TwcAutosave;
import com.maplesoft.maplembse.special.twc.adapter.TwcBridge;
import com.maplesoft.maplembse.special.twc.adapter.TwcCacheManager;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import com.maplesoft.maplembse.special.twc.adapter.TwcLockManager;
import com.maplesoft.maplembse.special.twc.adapter.TwcPackageRegistry;
import com.maplesoft.maplembse.special.twc.adapter.TwcParameters;
import com.maplesoft.maplembse.special.twc.adapter.TwcResource;
import com.maplesoft.maplembse.special.twc.adapter.TwcResourceBridge;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialog;
import com.maplesoft.maplembse.special.twc.adapter.dialog.TwcDialogManager;
import com.maplesoft.maplembse.special.twc.adapter.formula.ConnectedFormulaElement;
import com.maplesoft.maplembse.special.twc.adapter.formula.ElementName;
import com.maplesoft.maplembse.special.twc.adapter.formula.ElementReach;
import com.maplesoft.maplembse.special.twc.adapter.formula.FormulaEvaluationContext;
import com.maplesoft.maplembse.special.twc.adapter.formula.FormulaInstance;
import com.maplesoft.maplembse.special.twc.adapter.formula.FormulaLanguage;
import com.maplesoft.maplembse.special.twc.adapter.formula.FormulaScopes;
import com.maplesoft.maplembse.special.twc.adapter.formula.FormulaString;
import com.maplesoft.maplembse.special.twc.adapter.formula.FormulaVariables;
import com.maplesoft.maplembse.special.twc.adapter.formula.VariableStorage;
import com.maplesoft.maplembse.special.twc.adapter.formula.VariableValue;
import com.maplesoft.maplembse.special.twc.adapter.mpm.ElementUtil;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMActivitySync;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMAssociatedProperty;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMAttachedFile;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMConnectedPortOrProperty;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMDiagram;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMElementType;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMEnumerationLabel;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMEnumerationName;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMFeatureImpact;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMFeatureName;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMForeignFieldGroup;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMGetAllProperties;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMID;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMInstance;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMInstanceTree;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMMetaclassName;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMMultipleInstance;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMMultipleObjects;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMMultiplicityOfInstance;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMNestedDirectedComposition;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMOtherConnectorEnd;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMOwnedComments;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMOwnedConnector;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMPartWithPort;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMPropertyDefaultValue;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMRecursivePartProperties;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMSetSlotOwner;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMShareInstance;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMSharedInstanceTypeCheck;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMSlotValue;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMSlots;
import com.maplesoft.maplembse.special.twc.adapter.mpm.MPMSpecificClass;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeNames;
import com.maplesoft.maplembse.special.twc.adapter.mpm.StereotypeUtil;
import com.maplesoft.maplembse.special.twc.adapter.mpm.dependency.MPMDependency;
import com.maplesoft.maplembse.special.twc.adapter.mpm.dependency.MPMDependencyClientSupplier;
import com.maplesoft.maplembse.special.twc.adapter.mpm.dependency.MPMMultipleDependencies;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPDataLoadException;
import org.openmbee.mpspi.exceptions.MPDisconnectionException;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPIllegalStateException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPModifier;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class TwcAdapter
extends MPBaseAdapter {
    private static TwcDialogManager dManager = new TwcDialogManager();
    private static TwcDialogManager doubleClickManager = new TwcDialogManager();
    public static final String CATEGORY_DELIMITER = "=== Select project from another category below ===";
    public static final String CATEGORY_UNCATEGORIZED = "Uncategorized";
    public static final Logger LOGGER = Logger.getLogger(TwcAdapter.class);
    private static final String SETTINGS_NAME = "twc.login.settings";
    private TwcAccess access;
    private TwcCacheManager cacheManager;
    private volatile Clock clock;
    private volatile long lastAutoSave;
    private volatile long lastModelAccess;
    private volatile long lastModelEdit;
    private TwcLockManager lockManager;
    private TwcParameters params;
    private TwcResource resource;
    private LoginStateEnum state = LoginStateEnum.UNCONNECTABLE;
    private TwcPackageRegistry twcPackageRegistry;
    private TwcResourceBridge resourceBridge;
    private static Boolean disableLock = Boolean.valueOf(System.getProperty("com.maplesoft.maplembse.twc.adapter.disablelock")) == false;
    private static boolean isDeletingUnsynchedPins = false;
    private boolean isCategoryFilterChanged = false;
    private static boolean isupdatingParameterDirection = false;
    private MagicDrawServices magicDrawServices;
    private int magicDrawServiceRetry = 5;
    private boolean tryConnection = true;

    public TwcAdapter() {
        this.clock = Clock.systemDefaultZone();
        try {
            this.setTransaction(true);
            this.registerAdditionalFeature();
        }
        catch (MPException e) {
            LOGGER.error((Object)e);
        }
    }

    private void registerAdditionalFeature() throws MPException {
        List<Class> features = Arrays.asList(MPMElementType.class, MPMActivityControlFlow.class, MPMActivityObjectFlow.class, MPMDependencies.Client.class, MPMDependencies.Supplier.class, MPMDurationConstraint.class, MPMMultiplicity.class, MPMNestedDirectedComposition.class, MPMNestedDirectedComposition.TargetBlockName.class, MPMOtherAssociationEnd.class, MPMVertexTransition.class, MPMAssociatedProperty.AssociatedProperty.class, MPMAssociatedProperty.DirectedAssociatedProperty.class, MPMAttachedFile.class, MPMConnectedPortOrProperty.class, MPMDependencyClientSupplier.Client.class, MPMDependencyClientSupplier.Supplier.class, MPMDiagram.MPMDiagramType.class, MPMDiagram.MPMDownloadDiagram.class, MPMEnumerationLabel.class, MPMEnumerationName.class, MPMFeatureImpact.class, MPMFeatureName.class, MPMGetAllProperties.class, MPMGetRecursively.class, MPMMultipleDependencies.class, MPMMultipleDependencies.MultipledepStereotype.class, MPMInstance.Recursive.class, MPMInstance.Regular.class, MPMInstanceTree.class, MPMMetaclassName.class, MPMMultipleInstance.ArrayName.class, MPMMultipleObjects.ClientDependency.class, MPMMultiplicityOfInstance.class, MPMOtherConnectorEnd.class, MPMOwnedComments.class, MPMPropertyDefaultValue.class, MPMRecursivePartProperties.class, MPMShareInstance.ShareInstance.class, MPMShareInstance.UnshareInstance.class, MPMSlots.class, MPMSlotValue.class, MPMSpecificClass.class, StereotypeNames.class, StereotypeNames.MPMUnofficialMetaclassName.class, MPMActivityPartitionAllocation.class, MPMActivitySwimlane.class, MPMActivitySync.Argument.class, MPMActivitySync.Behavior.class, MPMActivitySync.Direction.class, MPMActivitySync.Name.class, MPMActivitySync.Parameter.class, MPMActivitySync.Result.class, MPMActivitySync.Type.class, MPMConnectorEndRole.class, MPMDependency.MPMDependencyClient.class, MPMDependency.MPMDependencySupplier.class, MPMSpecificClass.GeneralizationGeneral.class, MPMOwnedConnector.class, MPMPartWithPort.class, MPMPackageElement.class, MPMID.class, ConnectedFormulaElement.class, ElementReach.class, ElementReach.ElementReachScope.class, FormulaLanguage.class, FormulaScopes.class, FormulaString.class, FormulaInstance.class, FormulaVariables.class, VariableValue.class, FormulaEvaluationContext.class, VariableStorage.class, MPMForeignFieldGroup.ElementPath.class, MPMForeignFieldGroup.SupportedType.class, MPMSetSlotOwner.class, MPMSharedInstanceTypeCheck.class, ElementName.class, ElementName.QualifiedElementName.class);
        List<MPModifier> featureModifiers = features.stream().map(c -> this.modifierSupplier((Class<? extends MPModifier>)c)).collect(Collectors.toList());
        this.registerModifiers(featureModifiers);
    }

    private void registerModifiers(List<MPModifier> modifiers) {
        for (MPModifier modifier : modifiers) {
            if (Objects.isNull(modifier)) continue;
            try {
                this.registerMPModifier(modifier);
            }
            catch (MPException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MPModifier modifierSupplier(Class<? extends MPModifier> c) {
        Constructor<? extends MPModifier> constructor = null;
        try {
            Constructor<? extends MPModifier> tmp;
            constructor = tmp = c.getDeclaredConstructor(MPBaseAdapter.class);
            constructor.setAccessible(true);
            MPModifier mPModifier = constructor.newInstance(new Object[]{this});
            return mPModifier;
        }
        catch (Exception e) {
            MPModifier mPModifier = null;
            return mPModifier;
        }
        finally {
            if (constructor != null) {
                constructor.setAccessible(false);
            }
        }
    }

    public synchronized void add(EObject owner, EStructuralFeature feature, Object value, int index) throws MPException {
        this.checkAdapterState();
        this.addNeededNotificationModifier(owner, feature);
        super.add(owner, feature, value, index);
        this.commitTx();
    }

    private void addNeededNotificationModifier(EObject owner, EStructuralFeature feature) {
        if (feature.equals(M2Element.Class$nestedClassifier)) {
            Util.addNotificationModifier((Object)owner, (MPNotificationModifier)MPANM_GetRecursively.nestedClassifierNotification);
        }
    }

    synchronized void autosave() {
        LOGGER.trace((Object)"Autosave method has been called.");
        try {
            this.checkAdapterState();
            this.getCacheManager().takeAutoSave(this.params.getUsername());
            this.updateLastAutoSave();
        }
        catch (MPException e) {
            LOGGER.error((Object)"Auto-save failed", (Throwable)e);
        }
    }

    private void checkAdapterState() throws MPDisconnectionException {
        if (this.access == null || this.resource == null || this.params == null) {
            throw new IllegalStateException();
        }
        doubleClickManager.clearClicked();
        try {
            this.access.ensureConnection();
        }
        catch (Throwable th) {
            throw new MPDisconnectionException(MessageUtil.msg(MessageEnum.FAILED_TO_CONNECT_ADAPTER_STATUS), th);
        }
    }

    public boolean checkRecursiveClassifierAdapter(EObject eobj) {
        return eobj.eAdapters().contains((Object)MPMInstance.RClassifierNM.getInstance());
    }

    private void cleanRef(EObject eo, EReference reference, Set<EObject> toBeDeleted) {
        Object oppsite = eo.eGet((EStructuralFeature)reference);
        if (reference.isContainment()) {
            if (reference.isMany() && oppsite instanceof Collection) {
                Collection collection = (Collection)oppsite;
                this.deleteElements(collection, toBeDeleted);
            } else if (Util.isInstanceOf((Object)oppsite, (EClass)M2Element.Element)) {
                this.deleteElement((EObject)oppsite, toBeDeleted);
            }
        }
        this.doUnset(eo, (EStructuralFeature)reference, oppsite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTx() throws MPException {
        try {
            if (disableLock.booleanValue()) {
                Set targets = this.getLockTargets();
                HashSet<UUID> lockElems = new HashSet<UUID>(targets.size());
                Set<EObject> addedObjects = this.resource.getAddedObjects();
                for (EObject eo : targets) {
                    UUID uuid = this.getLockManager().searchLockableElement(eo, addedObjects);
                    if (uuid == null) continue;
                    lockElems.add(uuid);
                    LOGGER.debug((Object)("Locking: " + uuid + " " + eo));
                }
                if (!lockElems.isEmpty()) {
                    this.getLockManager().lock(lockElems);
                }
            }
            super.commit();
            this.lastModelEdit = this.clock.millis();
            super.addUndoLog();
        }
        finally {
            super.clearTransaction();
        }
    }

    public void delete(EObject eObj) throws MPException {
        if (disableLock.booleanValue()) {
            this.getLockManager().lockParent(eObj);
        }
        if (eObj instanceof MultipleDependencies) {
            this.removeMultipleDependencies(eObj);
        } else {
            this.dispose(eObj);
        }
    }

    private void removeMultipleDependencies(EObject eObj) throws MPException {
        this.remove(eObj.eContainer(), (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_MultipleDependencies(), eObj);
    }

    public void deleteElement(EObject eObject) {
        isDeletingUnsynchedPins = Util.isInstanceOf((Object)eObject, (EClass)M2Element.CallBehaviorAction) || Util.isInstanceOf((Object)eObject, (EClass)M2Element.Activity);
        this.deleteElement(eObject, new LinkedHashSet<EObject>());
        isDeletingUnsynchedPins = false;
    }

    public void deleteElement(EObject eObject, Set<EObject> toBeDeleted) {
        if (!Util.isInstanceOf((Object)eObject, (EClass)M2Element.Element)) {
            return;
        }
        if (toBeDeleted.contains(eObject)) {
            return;
        }
        toBeDeleted.add(eObject);
        if (Util.isInstanceOf((Object)eObject, (EClass)TwcConstants.Diagram)) {
            this.doDelete(eObject, this.getResource());
            return;
        }
        this.deleteElements(Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Element$_relationshipOfRelatedElement), toBeDeleted);
        for (CleanStrategy s : CleanStrategy.getStrategies(eObject)) {
            this.deleteElements(s.clean(this, eObject), toBeDeleted);
        }
        List<EReference> allReferences = this.resourceBridge.allReferences(eObject);
        allReferences.stream().filter(reference -> reference.isChangeable() && !reference.isDerived() && eObject.eIsSet((EStructuralFeature)reference)).forEach(eRef -> this.cleanRef(eObject, (EReference)eRef, toBeDeleted));
    }

    public void deleteElements(Collection<EObject> eObjects, Set<EObject> toBeDeleted) {
        if (Objects.nonNull(eObjects) && !eObjects.isEmpty()) {
            eObjects.forEach(o -> this.deleteElement((EObject)o, toBeDeleted));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(TwcDialog dialog, Observable o) {
        if (o != null && dialog instanceof Observer) {
            o.addObserver((Observer)((Object)dialog));
        }
        TwcAdapter.getDialogManager().open(dialog, o);
        try {
            TwcAdapter.getDialogManager().stop();
        }
        catch (Throwable throwable) {
        }
        finally {
            dManager = null;
        }
    }

    public synchronized void dispose(EObject obj) throws MPException {
        this.checkAdapterState();
        if (!Util.isInstanceOf((Object)obj, (EClass)M2Element.Element)) {
            return;
        }
        this.deleteElement(obj);
        this.commitTx();
    }

    public synchronized Object get(EObject obj, EStructuralFeature feature) throws MPException {
        this.checkAdapterState();
        this.updateLastModelAccess();
        int i = 0;
        while (true) {
            try {
                Object object = super.get(obj, feature);
                return object;
            }
            catch (MPException e) {
                this.checkAdapterState();
                if (i >= 5) {
                    throw new MPDisconnectionException(e.getMessage());
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public List<EObject> getByEClass(EClass eCls) throws MPException {
        if (this.resource == null) {
            throw new MPIllegalStateException(MessageUtil.msg(MessageEnum.RECOURCE_LOAD_EXCEPTION));
        }
        List<EObject> r = this.resource.getObjectsByClass((EClassifier)eCls);
        if (r != null) {
            return r;
        }
        throw new MPAccessException(MessageUtil.msg(MessageEnum.RETRIEVE_MODEL_ELEMENT_EXCEPTION) + eCls);
    }

    public TwcCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = TwcBridge.getTwcManager().getCacheManager(this);
        }
        return this.cacheManager;
    }

    public Serializable getInformation(MPAdapter.InformationOption option) throws MPException {
        switch (option) {
            case NAME: {
                return "Teamwork Cloud MPAdapter";
            }
            case SPECIFICATIONS: {
                return TwcAdapter.specifications((String[])new String[]{"true,twc,,Teamwork Cloud URI"});
            }
        }
        return super.getInformation(option);
    }

    long getLastAutosave() {
        return this.lastAutoSave;
    }

    long getLastModelAccess() {
        return this.lastModelAccess;
    }

    long getLastModelEdit() {
        return this.lastModelEdit;
    }

    public TwcLockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = TwcBridge.getTwcManager().getTwcLockManager(this);
        }
        return this.lockManager;
    }

    public TwcPackageRegistry getPackageRegistry() {
        if (this.twcPackageRegistry == null) {
            this.twcPackageRegistry = new TwcPackageRegistry();
        }
        return this.twcPackageRegistry;
    }

    public Resource getResource() {
        return this.resource;
    }

    public TwcResourceBridge getTwcResourceBridge() {
        return this.resourceBridge;
    }

    public List<EObject> getRoots(String name) throws MPException {
        if (name.equals("Stereotypes")) {
            return this.resource.getStereotypes();
        }
        if (name.equals("Properties")) {
            return this.resource.getProperties();
        }
        return super.getRoots(name);
    }

    public TwcAccess getTwcAccess() {
        return this.access;
    }

    public URI getURI() {
        if ("".equals(this.params.getBranch())) {
            this.params.setBranch("trunk");
        }
        return this.params.getURI("host&port&project&username&branch#revision");
    }

    private void initializeAutosave() {
        long ct;
        this.lastModelEdit = ct = this.clock.millis();
        this.lastModelAccess = ct;
        this.lastAutoSave = ct;
        TwcAutosave.start(this);
    }

    void keepAlive() {
        try {
            this.resource.checkServerlatestRevision();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(URI uri, Map<MPAdapter.LoadOption, Object> option) throws MPException {
        block12: {
            CheckLicense.check((String)"MapleMBSETWCAdapter");
            if (uri == null || uri.isEmpty() || "twc://".equals(uri.toString())) {
                uri = this.loadSavedSettings();
            }
            try {
                this.params = new TwcParameters(uri);
            }
            catch (Exception e) {
                uri = URI.createURI((String)"twc://").appendQuery("");
                this.params = new TwcParameters(uri);
            }
            this.access = TwcBridge.getTwcManager().getTwcAccess(this);
            try {
                this.login(uri);
                long revision = this.params.getRevision();
                if (revision == -1L) {
                    this.params.updateToHeadRevision(this);
                }
            }
            catch (IllegalStateException e) {
                if (!MessageUtil.msg(MessageEnum.LOGIN_FAILED_EXCEPTION).equals(e.getMessage())) break block12;
                throw new MPInvalidException(MessageUtil.msg(MessageEnum.LOGIN_FAILED_EXCEPTION), e.getCause());
            }
        }
        if (this.resource != null) {
            try {
                if ("".equals(this.params.getUsername()) || !this.params.getUsername().equals(this.access.getActiveUserName()) && !this.access.getActiveUserName().isEmpty()) {
                    this.params.setUsername(this.access.getActiveUserName());
                }
                this.resource.applySnapshot(this.params.getUsername());
            }
            catch (MPException th) {
                LOGGER.error((Object)th);
            }
            if (this.params.isCacheEnabled()) {
                this.getCacheManager().createCache();
            }
        } else {
            throw new MPDataLoadException("TwcAdapter::load resource null");
        }
        this.initializeAutosave();
    }

    private URI loadSavedSettings() {
        Object object = Activator.getDefault().getDataObject(SETTINGS_NAME);
        if (!(object instanceof Settings)) {
            String[] segment = new String[]{""};
            return URI.createHierarchicalURI((String[])segment, (String)"", null);
        }
        Settings settings = (Settings)object;
        return settings.getURI();
    }

    public void login(URI uri) {
        boolean isFilterToBeSet;
        this.beforeLogin();
        String format = "host&port&project&username&password&branch&revision&ssl&cache&settings_saved&token&category";
        URI oldUri = this.params.getURI(format);
        boolean wasFilterPreviouslySet = this.params.isCategoryFiltered();
        String c1 = this.params.getCatergory();
        this.params.setURI(uri);
        this.resourceBridge = TwcBridge.getTwcManager().getTwcResourceBridge();
        boolean s = this.params.isCategoryFiltered();
        boolean c = uri.toString().contains("category");
        String category = this.params.getCatergory();
        boolean x = category != null && !category.isEmpty();
        boolean bl = isFilterToBeSet = c && x || !c && s;
        if (this.access.isOpened()) {
            this.params.setCategoryFiltered(isFilterToBeSet);
        }
        String c2 = null;
        c2 = c || !this.access.isOpened() ? this.params.getCatergory() : this.access.getCatergoryName(this.params.getProject());
        boolean toggle = isFilterToBeSet ^ wasFilterPreviouslySet;
        this.isCategoryFilterChanged = toggle || s && !Objects.equals(c1, c2);
        boolean isFirst = true;
        boolean isSameState = false;
        while (!isSameState) {
            oldUri = isFirst ? oldUri : this.params.getURI(format);
            LoginStateEnum tmp = this.state.login(this, oldUri);
            if (this.params.isLoaded() && this.state == LoginStateEnum.RESOURCE) break;
            isFirst = false;
            if (this.params.isCancelled()) {
                throw new IllegalStateException(MessageUtil.msg(MessageEnum.LOGIN_FAILED_EXCEPTION));
            }
            isSameState = tmp == this.state;
            this.state = tmp;
        }
        this.params.notifyObservers();
    }

    private void beforeLogin() {
        this.params.clearProjectListChange();
        this.params.clearCategoryListChange();
        this.params.clearLoaded();
    }

    public MPAdapter.ReloadResult reload() throws MPException {
        try {
            this.checkAdapterState();
            if (!this.resource.reload(this.params)) {
                return MPAdapter.ReloadResult.DONE;
            }
            this.clearUndoRedoStacks();
            if (this.params.isCacheEnabled()) {
                this.getCacheManager().updateLocalCache();
            }
            MPMMultipleDependencies.initalize();
            this.resetTryConnectionAndDiagramValues();
        }
        catch (Exception e) {
            if (e.getCause() instanceof OutOfMemoryError) {
                throw e;
            }
            if (e instanceof IllegalStateException) {
                LOGGER.warn((Object)(MessageUtil.msg(MessageEnum.INVALID_SESSON_TRY_AGAIN) + e));
            } else {
                LOGGER.warn((Object)(MessageUtil.msg(MessageEnum.COMMUNICATION_PROBLEM_TRY_AGAIN) + e));
            }
            try {
                this.access.login(this.params);
            }
            catch (Exception e2) {
                throw new MPDisconnectionException(MessageUtil.msg(MessageEnum.FAILDED_TO_RELOAD_DUE_CONNECTION));
            }
        }
        return MPAdapter.ReloadResult.NEED_REACTIVATE;
    }

    public synchronized void remove(EObject owner, EStructuralFeature feature, Object value) throws MPException {
        this.checkAdapterState();
        super.remove(owner, feature, value);
        this.commitTx();
    }

    public void save(Map<MPAdapter.SaveOption, Object> option) throws MPException {
        boolean isDoubleClicked = doubleClickManager.isDoubleClick();
        try {
            this.checkAdapterState();
        }
        catch (MPDisconnectionException e) {
            throw new MPDisconnectionException(MessageUtil.msg(MessageEnum.FAILED_TO_COMMIT_CONNECTION_EXCEPTION, this.getURI()), (Throwable)e);
        }
        if (isDoubleClicked) {
            if (this.resource.commit(this.params, option)) {
                this.clearUndoRedoStacks();
            }
        } else {
            this.getCacheManager().saveLocally(this.params.getUsername());
            doubleClickManager.justClicked();
        }
    }

    public void saveSettings(URI uri) {
        Settings settings = new Settings(new TwcParameters(uri));
        Activator.getDefault().saveDataObject(SETTINGS_NAME, settings);
    }

    public synchronized void set(EObject obj, EStructuralFeature feature, Object value) throws MPException {
        this.checkAdapterState();
        if (Util.isInstanceOf((Object)obj, (EClass)TwcConstants.LiteralSpecification) && value == null && "value".equals(feature.getName())) {
            this.deleteElement(obj);
        } else {
            super.set(obj, feature, value);
        }
        this.commitTx();
    }

    public MPAdapter.UndoResult undo() throws MPException {
        this.checkAdapterState();
        try {
            return super.undo();
        }
        catch (MPException error) {
            LOGGER.error((Object)error);
            TwcAdapter.getDialogManager().messageBoxErr(error.getMessage());
            throw error;
        }
    }

    public MPAdapter.RedoResult redo() throws MPException {
        this.checkAdapterState();
        try {
            return super.redo();
        }
        catch (MPException error) {
            LOGGER.error((Object)error);
            TwcAdapter.getDialogManager().messageBoxErr(error.getMessage());
            throw error;
        }
    }

    public void unload() throws MPException {
        if (this.access == null) {
            return;
        }
        try {
            if (this.resource != null) {
                if (this.lockManager != null) {
                    this.access.ensureConnection();
                    this.lockManager.release();
                }
                this.resource.unload();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        finally {
            this.lockManager = null;
            this.resource = null;
            this.cacheManager = null;
            this.access.close();
            this.access = null;
            TwcBridge.getTwcInject().restartInjection();
            TwcBridge.getTwcManager().unloadAllManagers();
            TwcBridge.clearTwcManager();
        }
    }

    public synchronized void unset(EObject obj, EStructuralFeature feature, Object value) throws MPException {
        this.checkAdapterState();
        if (TwcConstants.TaggedValue != null && Util.isInstanceOf((Object)obj, (EClass)TwcConstants.TaggedValue)) {
            this.delete(obj);
        } else {
            super.unset(obj, feature, value);
        }
        this.commitTx();
    }

    private void updateLastAutoSave() {
        this.lastAutoSave = this.clock.millis();
    }

    private void updateLastModelAccess() {
        this.lastModelAccess = this.clock.millis();
    }

    public static TwcDialogManager getDialogManager() {
        if (dManager != null) {
            return dManager;
        }
        dManager = new TwcDialogManager();
        return dManager;
    }

    public Set<Object> getAllCommitInfos() {
        if (this.resource == null) {
            return Collections.emptySet();
        }
        UUID id = this.resource.getResourceUUID();
        if (!this.access.isOpened() || id == null) {
            return Collections.emptySet();
        }
        return this.resourceBridge.getAllCommitInfos(this.access.getRepositoryManager(), id);
    }

    public Map<UUID, Object> getBranches() {
        UUID id = this.resource.getResourceUUID();
        if (!this.access.isOpened() || id == null) {
            return new HashMap<UUID, Object>();
        }
        return this.resourceBridge.getBranches(this.access.getRepositoryManager(), id);
    }

    public List<String> getUsernames() {
        if (!this.access.isOpened()) {
            return Collections.emptyList();
        }
        return this.resourceBridge.getAllUser(this.access.getUserManager());
    }

    private static String proccessParamsCategory(TwcParameters params) {
        String category = params.getCatergory();
        if (category == null || !params.isCategoryFiltered()) {
            return null;
        }
        String project = params.getProject();
        if (category.isEmpty() || !project.isEmpty() && !params.getProjectList().contains(project)) {
            params.setCategory(null);
            return null;
        }
        return category;
    }

    private void resetTryConnectionAndDiagramValues() {
        this.tryConnection = true;
        this.magicDrawServices = null;
        MPMDiagram.clearValues();
    }

    public Optional<MagicDrawServices> getMagicDrawConnection() throws MPException {
        for (int i = 0; this.tryConnection && i < this.magicDrawServiceRetry && this.magicDrawServices == null; ++i) {
            this.magicDrawServices = MagicDrawServiceUtil.getMagicDrawServiceConnection();
            if (this.magicDrawServices != null && this.tryConnection) {
                String branch = this.params.getBranch();
                if (branch.isEmpty()) {
                    branch = "trunk";
                }
                if (!MagicDrawServiceUtil.isConnectionHealthy(this.magicDrawServices, this.params.getUsername(), this.params.getProject(), branch)) {
                    this.magicDrawServices = null;
                }
            }
            this.tryConnection = this.magicDrawServices == null;
        }
        if (this.magicDrawServices == null && this.tryConnection) {
            TwcAdapter.getDialogManager().messageBoxErr("Unable to connect to the MapleMBSE plugin. Check the log file for more details.");
        }
        this.tryConnection = false;
        return Optional.ofNullable(this.magicDrawServices);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum LoginStateEnum {
        NO_RESOURCE{

            @Override
            LoginStateEnum login(TwcAdapter adapter, URI uri) {
                if (!adapter.params.hasSameSession(uri)) {
                    return this.disconnect(adapter);
                }
                String pCategory = TwcAdapter.proccessParamsCategory(adapter.params);
                String project = adapter.params.getProject();
                if (project == null || "".equals(project)) {
                    if (adapter.isCategoryFilterChanged) {
                        adapter.params.setProjectList(adapter.access.getProjects(pCategory));
                    }
                    return this.ensuredLoginDialogBox(adapter, "Select project", NO_RESOURCE);
                }
                if (!adapter.params.getProjectList().contains(project)) {
                    if (adapter.isCategoryFilterChanged) {
                        adapter.params.setProjectList(adapter.access.getProjects(pCategory));
                    }
                    return this.ensuredLoginDialogBox(adapter, MessageUtil.msg(MessageEnum.PROJECT_FAILED_TO_LOAD, project), NO_RESOURCE);
                }
                List<String> branches = adapter.access.getBranches(project);
                if (!branches.isEmpty()) {
                    adapter.params.setBranches(branches);
                    String branch = adapter.params.getBranch();
                    if (!branch.isEmpty() && !branches.contains(branch)) {
                        return this.ensuredLoginDialogBox(adapter, MessageUtil.msg(MessageEnum.SELECTED_BRANCH_DOESNOT_EXIST, branch), NO_RESOURCE);
                    }
                }
                try {
                    adapter.resource = adapter.resourceBridge.createTwcResource(adapter, adapter.params, adapter.access);
                }
                catch (Exception e) {
                    if (TwcAdapter.CATEGORY_DELIMITER.equals(adapter.params.getProject())) {
                        adapter.params.setProject("");
                        adapter.params.setCategory("");
                        adapter.params.setRevision(-1L);
                        return NO_RESOURCE;
                    }
                    adapter.params.clearBranches();
                    if (adapter.params.getRevision() > 1L) {
                        adapter.params.setBranch("UNSPECIFIED");
                    }
                    return this.ensuredLoginDialogBox(adapter, e.getMessage(), NO_RESOURCE);
                }
                String rCategory = adapter.resource.getCategory();
                adapter.params.setCategory(rCategory);
                if (!adapter.params.isCategoryFiltered()) {
                    rCategory = null;
                }
                if (adapter.isCategoryFilterChanged) {
                    adapter.params.setProjectList(adapter.access.getProjects(rCategory));
                }
                adapter.params.setMessage(MessageUtil.msg(MessageEnum.SELECT_BRANCH));
                return RESOURCE;
            }
        }
        ,
        RESOURCE{

            @Override
            LoginStateEnum login(TwcAdapter adapter, URI uri) {
                if (!adapter.params.hasSameSession(uri)) {
                    return this.disconnect(adapter);
                }
                String rCategory = adapter.resource.getCategory();
                String pCategory = TwcAdapter.proccessParamsCategory(adapter.params);
                if (pCategory != null && !Objects.equals(pCategory, rCategory) && !pCategory.isEmpty()) {
                    adapter.params.setProject("");
                    adapter.params.setCategory(pCategory);
                    return NO_RESOURCE;
                }
                if (!adapter.params.hasSameResource(uri)) {
                    adapter.params.setCategory("");
                    adapter.resource.unload();
                    adapter.resource = null;
                    adapter.params.setBranches(Collections.emptyList());
                    return NO_RESOURCE;
                }
                if (adapter.isCategoryFilterChanged) {
                    adapter.params.setProjectList(adapter.access.getProjects(pCategory));
                }
                adapter.params.setCategory(rCategory);
                adapter.params.setLoaded();
                return RESOURCE;
            }
        }
        ,
        UNCONNECTABLE{

            @Override
            LoginStateEnum login(TwcAdapter adapter, URI uri) {
                adapter.access.close();
                if (adapter.params.isConnectable()) {
                    return UNLOGGED;
                }
                try {
                    adapter.access.login(adapter.params);
                }
                catch (Throwable th) {
                    adapter.params.setMessage(th.getMessage());
                    return this.disconnect(adapter);
                }
                return UNLOGGED;
            }
        }
        ,
        UNLOGGED{

            @Override
            LoginStateEnum login(TwcAdapter adapter, URI uri) {
                if (!adapter.params.hasSameSession(uri)) {
                    return this.disconnect(adapter);
                }
                if (!adapter.params.canLogin()) {
                    return UNLOGGED;
                }
                try {
                    adapter.access.login(adapter.params);
                    String category = TwcAdapter.proccessParamsCategory(adapter.params);
                    adapter.params.setProjectList(adapter.access.getProjects(category));
                    adapter.params.setCategoryList(adapter.access.getCategories());
                    return NO_RESOURCE;
                }
                catch (Throwable th) {
                    LOGGER.error((Object)th);
                    adapter.params.setMessage(th.getMessage());
                    return UNLOGGED;
                }
            }
        };

        URI uri;

        LoginStateEnum disconnect(TwcAdapter adapter) {
            adapter.params.setProjectList(Collections.emptyList());
            adapter.params.setCategoryList(Collections.emptyList());
            adapter.params.setBranches(Collections.emptyList());
            return UNCONNECTABLE;
        }

        LoginStateEnum ensuredLoginDialogBox(TwcAdapter adapter, String msg, LoginStateEnum expectedState) {
            adapter.params.setMessage(msg);
            if (TwcAdapter.getDialogManager().getTargetDialog() != null) {
                return expectedState;
            }
            if ("main".equals(Thread.currentThread().getName())) {
                adapter.display(adapter.access.getDialog(), adapter.params);
            }
            return UNCONNECTABLE;
        }

        abstract LoginStateEnum login(TwcAdapter var1, URI var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum CleanStrategy {
        ACTIVITY_NODE(M2Element.ActivityNode){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                HashSet<EObject> edges = new HashSet<EObject>();
                edges.addAll(Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.ActivityNode$outgoing));
                edges.addAll(Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.ActivityNode$incoming));
                return edges;
            }
        }
        ,
        ASSOCIATION(M2Element.Association){

            List<EObject> clean(TwcAdapter adapter, EObject eObject) {
                return Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Association$memberEnd);
            }
        }
        ,
        CONNECTABLE_ELEMENT(M2Element.ConnectableElement){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                return Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.ConnectableElement$end).stream().filter(Objects::nonNull).map(EObject::eContainer).collect(Collectors.toSet());
            }
        }
        ,
        CONNECTOR(M2Element.Connector){

            List<EObject> clean(TwcAdapter adapter, EObject eObject) {
                return Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Connector$end);
            }
        }
        ,
        CONNECTOR_END(M2Element.ConnectorEnd){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                EObject connector = eObject.eContainer();
                if (connector == null) {
                    return Collections.emptySet();
                }
                return Collections.singleton(connector);
            }
        }
        ,
        DEPENDENCY(M2Element.Dependency){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                return CleanStrategy.cleanDependecy(adapter, eObject);
            }
        }
        ,
        DURATION_CONSTRAINT(M2Element.DurationConstraint){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                EObject maxDuration;
                HashSet<EObject> relatedElement = new HashSet<EObject>();
                EObject interval = (EObject)eObject.eGet(M2Element.Constraint$specification);
                if (interval == null) {
                    return relatedElement;
                }
                EObject minDuration = (EObject)interval.eGet(M2Element.Interval$min);
                if (minDuration != null) {
                    EObject minTimeExpr = minDuration.eContainer();
                    EObject minTimeEvent = minTimeExpr.eContainer();
                    relatedElement.add(minTimeEvent);
                    relatedElement.addAll(Util.getEList((EObject)minDuration, (EStructuralFeature)M2Element.Duration$observation));
                }
                if ((maxDuration = (EObject)interval.eGet(M2Element.Interval$max)) != null) {
                    EObject maxTimeExpr = maxDuration.eContainer();
                    EObject maxTimeEvent = maxTimeExpr.eContainer();
                    relatedElement.add(maxTimeEvent);
                    relatedElement.addAll(Util.getEList((EObject)maxDuration, (EStructuralFeature)M2Element.Duration$observation));
                }
                return relatedElement;
            }
        }
        ,
        ELEMENT_VALUE(TwcConstants.ElementValue){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                EObject slot = eObject.eContainer();
                if (!Util.isInstanceOf((Object)slot, (EClass)TwcConstants.Slot)) {
                    return Collections.emptySet();
                }
                List values = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value);
                if (values.size() > 1) {
                    return Collections.emptySet();
                }
                return Collections.singleton(slot);
            }
        }
        ,
        INSTANCE_SPECIFICATION(TwcConstants.InstanceSpecification){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                if (adapter.checkRecursiveClassifierAdapter(eObject)) {
                    List classifiers = Util.getEList((EObject)eObject, (EStructuralFeature)TwcConstants.InstanceSpecification$classifier);
                    ArrayList list = new ArrayList();
                    list.addAll(classifiers);
                    for (EObject classifier : list) {
                        try {
                            adapter.remove(eObject, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_RecursiveInstanceWithSlots(), classifier);
                        }
                        catch (Exception exception) {}
                    }
                }
                return Collections.emptySet();
            }
        }
        ,
        INSTANCE_VALUE(TwcConstants.InstanceValue){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                EObject eobj = eObject.eContainer();
                if (!Util.isInstanceOf((Object)eobj, (EClass)TwcConstants.Slot)) {
                    return Collections.emptySet();
                }
                return Collections.singleton(eobj);
            }
        }
        ,
        LITERAL_SPECIFICATION(TwcConstants.LiteralSpecification){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                EObject slot = eObject.eContainer();
                if (!Util.isInstanceOf((Object)slot, (EClass)TwcConstants.Slot)) {
                    return Collections.emptySet();
                }
                List values = Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value);
                if (values.size() > 1) {
                    return Collections.emptySet();
                }
                return Collections.singleton(slot);
            }
        }
        ,
        PARAMETER(M2Element.Parameter){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                HashSet<EObject> set = new HashSet<EObject>();
                List syncElements = Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Element$_elementOfSyncElement);
                for (EObject pin : syncElements) {
                    if (!Util.isInstanceOf((Object)pin, (EClass)M2Element.Pin)) continue;
                    set.add(pin);
                }
                set.addAll(Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Parameter$_activityParameterNodeOfParameter));
                return set;
            }
        }
        ,
        PIN(M2Element.Pin){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                if (isupdatingParameterDirection || MPMActivitySync.Direction.isSetting || isDeletingUnsynchedPins) {
                    return Collections.emptySet();
                }
                HashSet<EObject> set = new HashSet<EObject>();
                EObject parameter = (EObject)eObject.eGet(M2Element.Element$syncElement);
                if (!Util.isInstanceOf((Object)parameter, (EClass)M2Element.Parameter)) {
                    return set;
                }
                Object oldDirection = parameter.eGet(M2Element.Parameter$direction);
                if (MPMActivitySync.PARAMETER_INOUT.equals(oldDirection)) {
                    Enumerator direction = Util.isInstanceOf((Object)eObject, (EClass)M2Element.InputPin) ? MPMActivitySync.PARAMETER_OUT : MPMActivitySync.PARAMETER_IN;
                    try {
                        MPMActivitySync.Direction tmp = new MPMActivitySync.Direction(adapter);
                        isupdatingParameterDirection = true;
                        tmp.set(parameter, M2Element.Parameter$direction, direction, oldDirection);
                        isupdatingParameterDirection = false;
                    }
                    catch (MPException e) {
                        LOGGER.warn((Object)e);
                    }
                } else {
                    set.add(parameter);
                }
                return set;
            }
        }
        ,
        PROPERTY(M2Element.Property){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                HashSet<EObject> result = new HashSet<EObject>();
                EObject assoc = (EObject)eObject.eGet(M2Element.Property$association);
                if (assoc != null) {
                    result.add(assoc);
                }
                return result;
            }
        }
        ,
        SLOT(TwcConstants.Slot){

            @Override
            Collection<EObject> clean(TwcAdapter adapter, EObject eObject) {
                if (StereotypeUtil.isPartProperty((EObject)eObject.eGet(TwcConstants.Slot$definingFeature))) {
                    HashSet<EObject> result = new HashSet<EObject>();
                    List instanceValues = Util.getEList((EObject)eObject, (EStructuralFeature)TwcConstants.Slot$value);
                    for (EObject instanceValue : instanceValues) {
                        result.add((EObject)instanceValue.eGet(TwcConstants.InstanceValue$instance));
                    }
                    return result;
                }
                return Collections.emptySet();
            }
        }
        ,
        VERTEX(M2Element.Vertex){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                HashSet<EObject> transitions = new HashSet<EObject>();
                transitions.addAll(Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Vertex$incoming));
                transitions.addAll(Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Vertex$outgoing));
                return transitions;
            }
        }
        ,
        NO_OP(M2Element.Element){

            Set<EObject> clean(TwcAdapter adapter, EObject eObject) {
                return Collections.emptySet();
            }
        };

        EClass eClass;

        private CleanStrategy(EClass eClass) {
            this.eClass = eClass;
        }

        abstract Collection<EObject> clean(TwcAdapter var1, EObject var2);

        private static Set<EObject> cleanDependecy(TwcAdapter adapter, EObject eObject) {
            HashSet<EObject> eo = new HashSet<EObject>();
            List clients = Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Dependency$client);
            List suppliers = Util.getEList((EObject)eObject, (EStructuralFeature)M2Element.Dependency$supplier);
            if (clients.size() == 1 && suppliers.size() == 1) {
                EObject supplier;
                EObject client = (EObject)clients.get(0);
                if (client.equals(supplier = (EObject)suppliers.get(0))) {
                    return Collections.emptySet();
                }
                Util.addNotificationModifier((Object)eObject, (MPNotificationModifier)MPMDependencyClientSupplier.PackageOwningElement.getInstance(adapter));
                Util.addNotificationModifier((Object)eObject, (MPNotificationModifier)MPMDependencyClientSupplier.ClientNM.getInstance(adapter));
                Util.addNotificationModifier((Object)eObject, (MPNotificationModifier)MPMDependencyClientSupplier.SupplierNM.getInstance(adapter));
                Util.addNotificationModifier((Object)eObject, (MPNotificationModifier)MPMDependencyClientSupplier.PackagedElementDependencyNM.getInstnace(adapter));
                try {
                    if (StereotypeUtil.hasStereotype(eObject, "SysML::Requirements::Satisfy") != null) {
                        CleanStrategy.cleanDependency(adapter, supplier, MPMDependency.getSatisfyByDefiningFeature(adapter), client, eo);
                    } else if (StereotypeUtil.hasStereotype(eObject, "SysML::Requirements::Verify") != null) {
                        CleanStrategy.cleanDependency(adapter, supplier, MPMDependency.getVerifiedByDefiningFeature(adapter), client, eo);
                    } else if (StereotypeUtil.hasStereotype(eObject, "SysML::Requirements::Refine") != null) {
                        CleanStrategy.cleanDependency(adapter, supplier, MPMDependency.getRefinedByDefiningFeature(adapter), client, eo);
                    } else if (StereotypeUtil.hasStereotype(eObject, "SysML::Requirements::DeriveReqt") != null) {
                        CleanStrategy.cleanDependency(adapter, supplier, MPMDependency.getDerivedDefiningFeature(adapter), client, eo);
                        CleanStrategy.cleanDependency(adapter, client, MPMDependency.getDerivedFromDefiningFeature(adapter), supplier, eo);
                    } else if (StereotypeUtil.hasStereotype(eObject, "SysML::Requirements::Trace") != null) {
                        CleanStrategy.cleanDependency(adapter, client, MPMDependency.getTracedToDefiningFeature(adapter), supplier, eo);
                    } else if (StereotypeUtil.hasStereotype(eObject, "MBPLE Profile::FeatureImpact") != null) {
                        adapter.remove(eObject, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_FeatureImpact(), client);
                    }
                }
                catch (MPException e) {
                    LOGGER.error((Object)e);
                }
            }
            return eo;
        }

        private static void cleanDependency(TwcAdapter adapter, EObject supplier, EObject definingFeature, EObject client, Set<EObject> eo) {
            if (TwcConstants.Element$appliedStereotypeInstance != null) {
                EObject is = (EObject)supplier.eGet(TwcConstants.Element$appliedStereotypeInstance);
                EObject slot = ElementUtil.getSlot(is, definingFeature);
                if (slot == null) {
                    return;
                }
                Util.getEList((EObject)slot, (EStructuralFeature)TwcConstants.Slot$value).stream().forEach(s -> {
                    Object o = s.eGet(TwcConstants.ElementValue$element);
                    if (o != null && o.equals(client)) {
                        eo.add((EObject)s);
                    }
                });
            } else if (TwcConstants.Element$appliedStereotype != null) {
                EObject tag = ElementUtil.getTagValue(supplier, definingFeature);
                if (tag == null) {
                    return;
                }
                List values = Util.getEList((EObject)tag, (EStructuralFeature)TwcConstants.ElementTaggedValue$value);
                if (values.size() == 1 && values.contains(client)) {
                    eo.add(tag);
                } else {
                    adapter.doRemove(tag, TwcConstants.ElementTaggedValue$value, client);
                }
            }
        }

        static List<CleanStrategy> getStrategies(EObject eObject) {
            return Arrays.asList(CleanStrategy.values()).stream().filter(o -> o.eClass.isSuperTypeOf(eObject.eClass())).collect(Collectors.toList());
        }
    }

    private static final class Settings
    implements Serializable {
        private static final long serialVersionUID = -6980654074153920940L;
        private final String branch;
        private final boolean cache;
        private final String host;
        private final String port;
        private final String project;
        private final String category;
        private final String ssl;
        private final String username;

        public Settings(TwcParameters params) {
            this.branch = params.getBranch();
            this.cache = params.isCacheEnabled();
            this.host = params.getHost();
            this.port = params.getPort();
            this.project = params.getProject();
            this.ssl = params.getSSLKeyName();
            this.username = params.getUsername();
            this.category = params.getCatergory() != null ? params.getCatergory() : "";
        }

        public URI getURI() {
            TwcParameters params = new TwcParameters(null);
            params.setBranch(this.branch);
            params.setCacheEnabled(this.cache);
            params.setHost(this.host);
            params.setPort(this.port);
            params.setProject(this.project);
            params.setCategory(this.category);
            params.setSSLKeyName(this.ssl);
            params.setUsername(this.username);
            params.setSettingsSaved(true);
            return params.getURI("host&port&project&username&branch&ssl&cache&settings_saved&category");
        }
    }
}

