/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.special.twc.adapter.MessageEnum;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageUtil {
    private ResourceBundle resourceBundle;
    private static final MessageUtil messageUtil = new MessageUtil("com.maplesoft.maplembse.special.twc.adapter.message.Messages");

    private MessageUtil(String pkgName) {
        ResourceBundle rb;
        try {
            rb = ResourceBundle.getBundle(pkgName);
        }
        catch (MissingResourceException e) {
            rb = null;
        }
        this.resourceBundle = rb;
    }

    private String getFormat(String propName) {
        String format;
        if (this.resourceBundle == null) {
            return propName;
        }
        try {
            format = this.resourceBundle.getString(propName);
        }
        catch (MissingResourceException e) {
            return propName;
        }
        if (format != null) {
            return format;
        }
        return propName;
    }

    public static String msg(String prop) {
        return messageUtil.getFormat(prop);
    }

    public static String msg(MessageEnum msg) {
        return messageUtil.getFormat(msg.name());
    }

    public static String msg(String prop, Object ... arg) {
        String msessage = messageUtil.getFormat(prop);
        return MessageFormat.format(msessage, arg);
    }

    public static String msg(MessageEnum prop, Object ... arg) {
        String msessage = messageUtil.getFormat(prop.name());
        return MessageFormat.format(msessage, arg);
    }
}

