/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import com.maplesoft.maplembse.magicdraw.plugin.api.DiagramInfo;
import com.maplesoft.maplembse.magicdraw.plugin.api.MagicDrawServices;
import com.maplesoft.maplembse.magicdraw.plugin.api.SerializationUtils;
import com.maplesoft.maplembse.special.twc.adapter.TwcConstants;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;

public class MagicDrawServiceUtil {
    public static final Logger LOGGER = Logger.getLogger(MagicDrawServiceUtil.class);
    private static String port;

    private static int getPort() {
        if (port == null) {
            Properties properties = new Properties();
            String localAppData = System.getenv("LOCALAPPDATA");
            File localAppDataFile = new File(localAppData);
            File pluginPropertiesFile = new File(localAppDataFile.getAbsolutePath() + "\\MapleMBSEPlugin\\MapleMBSEPlugin.properties");
            try {
                properties.load(new FileInputStream(pluginPropertiesFile));
                port = properties.getProperty("com.maplesoft.maplembse.plugin.port");
            }
            catch (Exception e) {
                port = null;
            }
        }
        try {
            return Integer.valueOf(port);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return 0;
        }
    }

    public static MagicDrawServices getMagicDrawServiceConnection() throws MPInvalidException {
        try {
            int port = MagicDrawServiceUtil.getPort();
            Registry registry = LocateRegistry.getRegistry(port);
            MagicDrawServices drawInterface = (MagicDrawServices)registry.lookup("MagicDrawServices");
            if (drawInterface == null) {
                LOGGER.error((Object)"Unable to find the service class. Make sure the MapleMBSE plugin enabled.");
            }
            return drawInterface;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to find the service class. Make sure the MapleMBSE plugin enabled.", (Throwable)e);
            return null;
        }
    }

    public static boolean isConnectionHealthy(MagicDrawServices drawServices, String username, String project, String branch) {
        try {
            String connectedUser = drawServices.getConnectedUser();
            String projectInfo = drawServices.getActiveProjectInfo();
            if (connectedUser == null || !username.equals(connectedUser)) {
                LOGGER.error((Object)"The  MapleMBSE username does not match the modelling software user name.");
            } else if (projectInfo == null || !projectInfo.contains(project)) {
                LOGGER.error((Object)"The MapleMBSE project does not match the modeling software project.");
            } else if (!projectInfo.contains(branch)) {
                LOGGER.error((Object)"The MapleMBSE branch does not match the modeling software branch.");
            }
            return connectedUser != null && projectInfo != null && connectedUser.equals(username) && projectInfo.contains(project) && projectInfo.contains(branch);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public static DiagramInfo downloadDiagram(MagicDrawServices drawServices, EObject eobj) throws MPException {
        try {
            Object id = eobj.eGet(TwcConstants.ModelObject$ID);
            byte[] re = drawServices.downloadDiagramWithDiagramID(id);
            Object dia = SerializationUtils.deserialize((byte[])re);
            DiagramInfo diagramInfo = (DiagramInfo)dia;
            return diagramInfo;
        }
        catch (Throwable e) {
            throw new MPInvalidException("unable to download the diagram", e);
        }
    }
}

