/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.special.twc.adapter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final Logger LOGGER = Logger.getLogger(Activator.class);
    public static final String PLUGIN_ID = "com.maplesoft.maplembse.special.twc.adapter";
    private static Activator plugin;
    private Bundle thisBundle;

    public boolean clearDataObject(String name) {
        File f = this.getDataFile(name);
        if (f == null) {
            return false;
        }
        LOGGER.info((Object)("Remove the data object file: " + f.getAbsolutePath()));
        return f.delete();
    }

    public Object getDataObject(String name) {
        Object object;
        block8: {
            ObjectInputStream ois = this.getDataObjectInputStream(name);
            try {
                object = ois.readObject();
                if (ois == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            ois.close();
        }
        return object;
    }

    public ObjectInputStream getDataObjectInputStream(String name) throws IOException {
        File f = this.getDataFile(name);
        if (f == null) {
            throw new IOException("Datafile: " + name + " could not be obtained");
        }
        if (!f.canRead()) {
            String mes = f + " cannot be read";
            LOGGER.error((Object)mes);
            throw new IOException(mes);
        }
        LOGGER.info((Object)("Get the data object file: " + f.getAbsolutePath()));
        return new ObjectInputStream(new FileInputStream(f));
    }

    public static Bundle getBundle() {
        return Activator.getDefault().thisBundle;
    }

    public void saveDataObject(String name, Object obj) {
        try (ObjectOutputStream oos = this.getDataObjectOutputStream(name);){
            oos.writeObject(obj);
        }
        catch (Exception e) {
            System.out.println();
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        plugin = this;
        try {
            this.thisBundle = bundleContext.getBundle();
        }
        catch (IllegalStateException e) {
            this.thisBundle = null;
        }
    }

    public void stop(BundleContext arg0) throws Exception {
        plugin = null;
    }

    private File getDataFile(String name) {
        String localAppData = System.getenv("LOCALAPPDATA");
        if (localAppData == null) {
            LOGGER.error((Object)"LOCALAPPDATA is not found");
            return null;
        }
        File d1 = new File(localAppData);
        if (!d1.isDirectory()) {
            LOGGER.error((Object)("LOCALAPPDATA: " + localAppData + " is not a directory"));
            return null;
        }
        File d2 = new File(d1, "MapleMBSE");
        if (!d2.exists() && !d2.mkdir()) {
            LOGGER.error((Object)("Failed to make a new directory: " + d2));
            return null;
        }
        if (!d2.isDirectory()) {
            LOGGER.error((Object)("MapleMBSE configuration area is not a directory:" + d2));
            return null;
        }
        return new File(d2, name);
    }

    private ObjectOutputStream getDataObjectOutputStream(String name) throws IOException {
        File f = this.getDataFile(name);
        if (f == null) {
            throw new IOException("Datafile: " + name + " could not be obtained");
        }
        if (f.exists() && !f.canWrite()) {
            String mes = f + " cannot be written";
            LOGGER.error((Object)mes);
            throw new IOException(mes);
        }
        LOGGER.info((Object)("Get the data object file: " + f.getAbsolutePath()));
        return new ObjectOutputStream(new FileOutputStream(f));
    }

    public static Activator getDefault() {
        return plugin;
    }
}

