/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.action;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ui.toolkit.browser.action.SemanticBrowserHistoryAction;

public class BrowserHistory {
    private static final int MAX_SIZE = 10;
    private List<SemanticBrowserHistoryAction> _actionAsListeners;
    private int _currentEntryIndex = -1;
    private List<BrowserNavigationHistoryEntry> _entries = new ArrayList<BrowserNavigationHistoryEntry>(10);
    private boolean _shouldDoUpdate = true;

    public BrowserHistory() {
        this._actionAsListeners = new ArrayList<SemanticBrowserHistoryAction>(2);
    }

    public void addActionAsListener(SemanticBrowserHistoryAction action) {
        this._actionAsListeners.add(action);
    }

    public Collection<BrowserNavigationHistoryEntry> getAllNavigationEntries() {
        return Collections.unmodifiableCollection(this._entries);
    }

    private void cleanInvalidEntries() {
        Iterator<BrowserNavigationHistoryEntry> iterator = this._entries.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            BrowserNavigationHistoryEntry historyEntry = iterator.next();
            if (!historyEntry.isValid()) {
                iterator.remove();
                if (this._currentEntryIndex == i) {
                    --this._currentEntryIndex;
                }
            }
            ++i;
        }
        if (this._currentEntryIndex >= this._entries.size()) {
            this._currentEntryIndex = this._entries.size() - 1;
        } else if (this._currentEntryIndex < 0) {
            this._currentEntryIndex = 0;
        }
    }

    public void dispose() {
        if (this._entries != null) {
            this._entries.clear();
            this._entries = null;
        }
        if (this._actionAsListeners != null) {
            this._actionAsListeners.clear();
            this._actionAsListeners = null;
        }
        this._currentEntryIndex = -1;
    }

    public List<BrowserNavigationHistoryEntry> getBackwardNavigationEntries() {
        List<BrowserNavigationHistoryEntry> result = Collections.emptyList();
        if (!this._entries.isEmpty()) {
            result = new ArrayList<BrowserNavigationHistoryEntry>(this._entries.subList(0, this._currentEntryIndex));
        }
        return result;
    }

    public List<BrowserNavigationHistoryEntry> getForwardNavigationEntries() {
        List<BrowserNavigationHistoryEntry> result = Collections.emptyList();
        if (this._currentEntryIndex < this._entries.size() - 1) {
            result = new ArrayList<BrowserNavigationHistoryEntry>(this._entries.subList(this._currentEntryIndex + 1, this._entries.size()));
        }
        return result;
    }

    public void goTo(BrowserNavigationHistoryEntry navigationEntry) {
        this._currentEntryIndex = this._entries.indexOf(navigationEntry);
    }

    protected void notifyActionListeners() {
        for (SemanticBrowserHistoryAction action : this._actionAsListeners) {
            action.updateControlState();
        }
    }

    public void setDoUpdate(boolean doUpdate) {
        this._shouldDoUpdate = doUpdate;
    }

    private void removeForwardEntries() {
        int length = this._entries.size();
        int i = this._currentEntryIndex + 1;
        while (i < length) {
            this._entries.remove(this._currentEntryIndex + 1);
            ++i;
        }
    }

    public void update(Object realObject) {
        this.cleanInvalidEntries();
        if (this._shouldDoUpdate && realObject != null) {
            if (this._entries.size() == 10) {
                this._entries.remove(0);
            }
            this.removeForwardEntries();
            this._entries.add(new BrowserNavigationHistoryEntry(realObject));
            this._currentEntryIndex = this._entries.size() - 1;
        }
        this.notifyActionListeners();
    }

    public class BrowserNavigationHistoryEntry {
        private WeakReference<Object> _referencedObject;
        private boolean valid = true;

        protected BrowserNavigationHistoryEntry(Object realObject) {
            this._referencedObject = new WeakReference<Object>(realObject);
        }

        public Object getRealObject() {
            return this._referencedObject.get();
        }

        public boolean isValid() {
            Object realObject;
            boolean result = this.valid;
            if (result && ((realObject = this.getRealObject()) == null || realObject instanceof EObject && ((EObject)realObject).eIsProxy())) {
                result = false;
            }
            return result;
        }

        public void invalidate() {
            this.valid = false;
        }
    }
}

