/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.twc.editor;

import com.maplesoft.maplembse.special.twc.adapter.TwcParameters;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class ConfigParameters
extends TwcParameters {
    public final URI modelFileURI;
    public final URI serverURI;
    public final String userName;
    public final String password;
    public final String project;

    public boolean isLocalFile() {
        return this.modelFileURI != null;
    }

    public ConfigParameters(IFile file) throws CoreException {
        super(null);
        InputStream is = file.getContents();
        Properties ps = new Properties();
        try {
            ps.load(new InputStreamReader(is, "UTF-8"));
        }
        catch (Exception e) {
            Status st = new Status(4, ((Object)((Object)this)).getClass().getName(), e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)st);
        }
        String modelFile = ps.getProperty("modelFile");
        if (modelFile != null) {
            this.modelFileURI = URI.createFileURI((String)modelFile);
            this.serverURI = null;
            this.userName = null;
            this.password = null;
            this.project = null;
        } else {
            this.modelFileURI = null;
            String su = ps.getProperty("serverURI");
            this.serverURI = URI.createURI((String)su);
            this.userName = ps.getProperty("userName");
            this.password = ps.getProperty("password");
            this.project = ps.getProperty("project");
        }
    }

    public URI getURI() {
        return this.serverURI;
    }

    public String getHostPort() {
        return this.serverURI.host() + ":" + this.serverURI.port();
    }

    public String getUsername() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranchName() {
        return null;
    }

    public void setProjectList(List<String> projectList) {
    }

    public void setBranchList(List<String> branchList) {
    }

    public boolean isAccountChanged() {
        return false;
    }

    public void resetAccountChanged() {
    }

    public String getSSLKeyName() {
        return "cert";
    }

    public boolean isSSLEnabled() {
        return false;
    }

    public boolean isCacheEnabled() {
        return false;
    }

    public boolean isConnectable() {
        return false;
    }

    public void setProject(String project) {
    }

    public void setBranchName(String branchName) {
    }

    public void setUsername(String username) {
    }

    public void setPassword(String password) {
    }

    public void setHostPort(String hostPort) {
    }

    public void setSSLKeyName(String sslKeyName) {
    }

    public void setSSLEnabled(boolean sslEnabled) {
    }

    public void setCacheEnabled(boolean cacheEnabled) {
    }

    public List<String> getBranchList() {
        return null;
    }

    public List<String> getProjectList() {
        return null;
    }

    public long getRevision() {
        return 0L;
    }

    public void setRevision(long revision) {
    }

    public boolean isHeadRevision() {
        return false;
    }

    public void setHeadRevision(boolean headRevision) {
    }
}

