/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.commandline.core.IFileImporter;

public class ImporterRegistry {
    public static final String PLUGIN_ID = "org.polarsys.capella.core.commandline.core";
    static final String CONTRIBUTION_EXTENSION_ID = "fileimporter";
    private static ImporterRegistry __instance;
    private Map<String, List<IFileImporter>> _importerContributions = new HashMap<String, List<IFileImporter>>(0);

    public static ImporterRegistry getInstance() {
        if (__instance == null) {
            __instance = new ImporterRegistry();
        }
        return __instance;
    }

    private ImporterRegistry() {
        IConfigurationElement[] contributors;
        IConfigurationElement[] iConfigurationElementArray = contributors = ExtensionPointHelper.getConfigurationElements((String)PLUGIN_ID, (String)CONTRIBUTION_EXTENSION_ID);
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contributorElement = iConfigurationElementArray[n2];
            String extension = contributorElement.getAttribute("extension");
            IFileImporter importer = (IFileImporter)ExtensionPointHelper.createInstance((IConfigurationElement)contributorElement, (String)"class");
            List<IFileImporter> contributionsForRelatedExtension = this._importerContributions.get(extension);
            if (contributionsForRelatedExtension == null) {
                contributionsForRelatedExtension = new ArrayList<IFileImporter>(1);
                this._importerContributions.put(extension, contributionsForRelatedExtension);
            }
            contributionsForRelatedExtension.add(importer);
            ++n2;
        }
    }

    public List<IFileImporter> getImporters(String extension) {
        ArrayList<IFileImporter> result = new ArrayList<IFileImporter>();
        for (Map.Entry<String, List<IFileImporter>> entry : this._importerContributions.entrySet()) {
            String currentExtension = entry.getKey();
            if (!currentExtension.equals(extension)) continue;
            result.addAll((Collection<IFileImporter>)entry.getValue());
        }
        return result;
    }
}

