/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.security.impl;

import com.nomagic.magicdraw.security.Action;
import com.nomagic.magicdraw.security.Application;
import com.nomagic.magicdraw.security.EveryonePrincipal;
import com.nomagic.magicdraw.security.GroupPrincipal;
import com.nomagic.magicdraw.security.PackageAccessPermission;
import com.nomagic.magicdraw.security.PackagePermissions;
import com.nomagic.magicdraw.security.ProjectSecurity;
import com.nomagic.magicdraw.security.RolePrincipal;
import com.nomagic.magicdraw.security.SecurityFactory;
import com.nomagic.magicdraw.security.SecurityPackage;
import com.nomagic.magicdraw.security.UserPrincipal;
import com.nomagic.magicdraw.security.impl.EveryonePrincipalImpl;
import com.nomagic.magicdraw.security.impl.GroupPrincipalImpl;
import com.nomagic.magicdraw.security.impl.PackageAccessPermissionImpl;
import com.nomagic.magicdraw.security.impl.PackagePermissionsImpl;
import com.nomagic.magicdraw.security.impl.ProjectSecurityImpl;
import com.nomagic.magicdraw.security.impl.RolePrincipalImpl;
import com.nomagic.magicdraw.security.impl.StringToPackagePermissionsMapImpl;
import com.nomagic.magicdraw.security.impl.UserPrincipalImpl;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class SecurityFactoryImpl
extends EFactoryImpl
implements SecurityFactory {
    public static SecurityFactory init() {
        try {
            SecurityFactory theSecurityFactory = (SecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.nomagic.com/ns/magicdraw/security/1.1");
            if (theSecurityFactory != null) {
                return theSecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProjectSecurity();
            }
            case 1: {
                return this.createPackageAccessPermission();
            }
            case 2: {
                return (EObject)this.createStringToPackagePermissionsMap();
            }
            case 3: {
                return this.createPackagePermissions();
            }
            case 5: {
                return this.createUserPrincipal();
            }
            case 6: {
                return this.createGroupPrincipal();
            }
            case 7: {
                return this.createRolePrincipal();
            }
            case 8: {
                return this.createEveryonePrincipal();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.createActionFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createApplicationFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.convertActionToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertApplicationToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ProjectSecurity createProjectSecurity() {
        ProjectSecurityImpl projectSecurity = new ProjectSecurityImpl();
        return projectSecurity;
    }

    @Override
    public PackageAccessPermission createPackageAccessPermission() {
        PackageAccessPermissionImpl packageAccessPermission = new PackageAccessPermissionImpl();
        return packageAccessPermission;
    }

    public Map.Entry<String, PackagePermissions> createStringToPackagePermissionsMap() {
        StringToPackagePermissionsMapImpl stringToPackagePermissionsMap = new StringToPackagePermissionsMapImpl();
        return stringToPackagePermissionsMap;
    }

    @Override
    public PackagePermissions createPackagePermissions() {
        PackagePermissionsImpl packagePermissions = new PackagePermissionsImpl();
        return packagePermissions;
    }

    @Override
    public UserPrincipal createUserPrincipal() {
        UserPrincipalImpl userPrincipal = new UserPrincipalImpl();
        return userPrincipal;
    }

    @Override
    public GroupPrincipal createGroupPrincipal() {
        GroupPrincipalImpl groupPrincipal = new GroupPrincipalImpl();
        return groupPrincipal;
    }

    @Override
    public RolePrincipal createRolePrincipal() {
        RolePrincipalImpl rolePrincipal = new RolePrincipalImpl();
        return rolePrincipal;
    }

    @Override
    public EveryonePrincipal createEveryonePrincipal() {
        EveryonePrincipalImpl everyonePrincipal = new EveryonePrincipalImpl();
        return everyonePrincipal;
    }

    public Action createActionFromString(EDataType eDataType, String initialValue) {
        Action result = Action.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertActionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Application createApplicationFromString(EDataType eDataType, String initialValue) {
        Application result = Application.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertApplicationToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public SecurityPackage getSecurityPackage() {
        return (SecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static SecurityPackage getPackage() {
        return SecurityPackage.eINSTANCE;
    }
}

