/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Application implements Enumerator
{
    PACKAGE(0, "PACKAGE", "PACKAGE"),
    PACKAGE_AND_SUBPACKAGES(1, "PACKAGE_AND_SUBPACKAGES", "PACKAGE_AND_SUBPACKAGES");

    public static final int PACKAGE_VALUE = 0;
    public static final int PACKAGE_AND_SUBPACKAGES_VALUE = 1;
    private static final Application[] VALUES_ARRAY;
    public static final List<Application> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Application[]{PACKAGE, PACKAGE_AND_SUBPACKAGES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Application get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Application result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Application getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Application result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Application get(int value) {
        switch (value) {
            case 0: {
                return PACKAGE;
            }
            case 1: {
                return PACKAGE_AND_SUBPACKAGES;
            }
        }
        return null;
    }

    private Application(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

