/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.communication.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.core.data.information.communication.CommunicationFactory;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.information.communication.CommunicationPackage;
import org.polarsys.capella.core.data.information.communication.Exception;
import org.polarsys.capella.core.data.information.communication.Message;
import org.polarsys.capella.core.data.information.communication.MessageReference;
import org.polarsys.capella.core.data.information.communication.Signal;
import org.polarsys.capella.core.data.information.communication.SignalInstance;
import org.polarsys.capella.core.data.information.communication.impl.CommunicationLinkImpl;
import org.polarsys.capella.core.data.information.communication.impl.ExceptionImpl;
import org.polarsys.capella.core.data.information.communication.impl.MessageImpl;
import org.polarsys.capella.core.data.information.communication.impl.MessageReferenceImpl;
import org.polarsys.capella.core.data.information.communication.impl.SignalImpl;
import org.polarsys.capella.core.data.information.communication.impl.SignalInstanceImpl;

public class CommunicationFactoryImpl
extends EFactoryImpl
implements CommunicationFactory {
    public static CommunicationFactory init() {
        try {
            CommunicationFactory theCommunicationFactory = (CommunicationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/capella/core/information/communication/5.0.0");
            if (theCommunicationFactory != null) {
                return theCommunicationFactory;
            }
        }
        catch (java.lang.Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CommunicationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createException();
            }
            case 2: {
                return this.createMessage();
            }
            case 3: {
                return this.createMessageReference();
            }
            case 5: {
                return this.createSignal();
            }
            case 6: {
                return this.createSignalInstance();
            }
            case 7: {
                return this.createCommunicationLink();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.createCommunicationLinkKindFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createCommunicationLinkProtocolFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.convertCommunicationLinkKindToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertCommunicationLinkProtocolToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Exception createException() {
        ExceptionImpl exception = new ExceptionImpl();
        exception.setId(IdGenerator.createId());
        return exception;
    }

    @Override
    public Message createMessage() {
        MessageImpl message = new MessageImpl();
        message.setId(IdGenerator.createId());
        return message;
    }

    @Override
    public MessageReference createMessageReference() {
        MessageReferenceImpl messageReference = new MessageReferenceImpl();
        messageReference.setId(IdGenerator.createId());
        return messageReference;
    }

    @Override
    public Signal createSignal() {
        SignalImpl signal = new SignalImpl();
        signal.setId(IdGenerator.createId());
        return signal;
    }

    @Override
    public SignalInstance createSignalInstance() {
        SignalInstanceImpl signalInstance = new SignalInstanceImpl();
        signalInstance.setId(IdGenerator.createId());
        return signalInstance;
    }

    @Override
    public CommunicationLink createCommunicationLink() {
        CommunicationLinkImpl communicationLink = new CommunicationLinkImpl();
        communicationLink.setId(IdGenerator.createId());
        return communicationLink;
    }

    public CommunicationLinkKind createCommunicationLinkKindFromString(EDataType eDataType, String initialValue) {
        CommunicationLinkKind result = CommunicationLinkKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCommunicationLinkKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public CommunicationLinkProtocol createCommunicationLinkProtocolFromString(EDataType eDataType, String initialValue) {
        CommunicationLinkProtocol result = CommunicationLinkProtocol.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertCommunicationLinkProtocolToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CommunicationPackage getCommunicationPackage() {
        return (CommunicationPackage)this.getEPackage();
    }

    @Deprecated
    public static CommunicationPackage getPackage() {
        return CommunicationPackage.eINSTANCE;
    }

    @Override
    public Exception createException(String name_p) {
        Exception exception = this.createException();
        exception.setName(name_p);
        return exception;
    }

    @Override
    public Message createMessage(String name_p) {
        Message message = this.createMessage();
        message.setName(name_p);
        return message;
    }

    @Override
    public Signal createSignal(String name_p) {
        Signal signal = this.createSignal();
        signal.setName(name_p);
        return signal;
    }

    @Override
    public SignalInstance createSignalInstance(String name_p) {
        SignalInstance signalInstance = this.createSignalInstance();
        signalInstance.setName(name_p);
        return signalInstance;
    }
}

