/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.service.actorsystem;

import akka.actor.ActorSystem;
import com.nomagic.esi.common.a.h;
import com.nomagic.esi.config.EsiConfigService;
import com.nomagic.esi.helper.a.a.d;
import com.nomagic.esi.serializer.ClassRegistrarSerializer;
import com.nomagic.esi.service.IActorSystemFactory;
import com.nomagic.esi.service.IServerStatus;
import com.nomagic.esi.service.actorsystem.BundleStatus;
import com.nomagic.esi.service.actorsystem.EsiOsgiActorSystemFactory;
import com.nomagic.esi.service.actorsystem.a.a;
import com.nomagic.esi.service.actorsystem.a.b;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorSystemFactory
implements IActorSystemFactory {
    private static ActorSystem system;
    private static final Logger LOG;
    private ServiceRegistration<IServerStatus> bundleStatusService;
    private EsiConfigService configService;

    static {
        LOG = LoggerFactory.getLogger(ActorSystemFactory.class);
        BundleStatus.getInstance().setStatus(IServerStatus.ServerStatus.STARTING);
    }

    public ActorSystem getActorSystem() {
        return system;
    }

    public void setSerializer(ClassRegistrarSerializer classRegistrarSerializer) {
    }

    protected void activate(BundleContext bundleContext) {
        if (system == null) {
            try {
                system = Boolean.getBoolean("esi.nosgi.platform") ? ActorSystem.create((String)this.getActorSystemName(bundleContext), (Config)a.a(this.configService)) : EsiOsgiActorSystemFactory.createOsgiActorSystemFactory(bundleContext, this.configService).createActorSystem(this.getActorSystemName(bundleContext));
            }
            catch (ConfigException configException) {
                LOG.error("Incorrect server configuration", (Throwable)configException);
                this.shutdown();
            }
            catch (Exception exception) {
                block11: {
                    block10: {
                        if (!exception.getClass().getName().equals("org.jboss.netty.channel.ChannelException")) break block10;
                        LOG.error(exception.getMessage());
                        break block11;
                    }
                    LOG.error("Unable to create the actorSystem.", (Throwable)exception);
                }
                this.shutdown();
            }
            if (system != null) {
                try {
                    BundleStatus.getInstance().setMaxMessages(system.settings().config().getInt("esi.server.status.maxLine"));
                }
                catch (ConfigException configException) {
                    LOG.error("Unable to maximum messages for server's status from configuration file.", (Throwable)configException);
                }
                this.bundleStatusService = bundleContext.registerService(IServerStatus.class, (Object)BundleStatus.getInstance(), null);
                this.printActorSystemConfiguration();
            }
        } else {
            LOG.debug("Multiple activation of ActorSystemFactory");
            BundleStatus.getInstance().addMessage("Multiple activation of ActorSystemFactory");
        }
        BundleStatus.getInstance().setStatus(IServerStatus.ServerStatus.RUNNING);
        LOG.info(String.valueOf(ActorSystemFactory.class.getSimpleName()) + " activated");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deactivate(BundleContext bundleContext) {
        BundleStatus.getInstance().setStatus(IServerStatus.ServerStatus.STOPING);
        if (this.bundleStatusService != null) {
            this.bundleStatusService.unregister();
            if (LOG != null) {
                LOG.info("Unregister BundleStatus Service.");
            }
        }
        if (system != null) {
            b.a(system.terminate(), h.b);
        }
        BundleStatus.getInstance().setStatus(IServerStatus.ServerStatus.STOPPED);
        LOG.info(String.valueOf(ActorSystemFactory.class.getSimpleName()) + " deactivated");
    }

    public String getActorSystemName(BundleContext bundleContext) {
        return this.configService.getConfig().getString("esi.system.name");
    }

    private void printActorSystemConfiguration() {
        Config config = system.settings().config();
        String string = config.getString(a.b);
        int n = config.getInt(a.c);
        LOG.info("Actor system: {}, Address: {}:{}", new Object[]{system.name(), string, Integer.toString(n)});
        LOG.info("Cluster seeds: " + config.getList(a.a));
    }

    public void shutdown() {
        try {
            try {
                ActorSystem actorSystem = this.getActorSystem();
                if (actorSystem != null) {
                    b.a(actorSystem.terminate(), h.b);
                }
                d.j().n();
            }
            catch (Exception exception) {
                LOG.error("Error while shutdow", (Throwable)exception);
                System.exit(0);
            }
        }
        finally {
            System.exit(0);
        }
    }

    public void setEsiConfigService(EsiConfigService esiConfigService) {
        this.configService = esiConfigService;
    }
}

