/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ef.internal.command;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.AbstractTransactionalCommandStack;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TriggerCommandTransaction;
import org.eclipse.emf.transaction.util.TriggerCommand;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.impl.EMFOperationTransaction;
import org.eclipse.emf.workspace.internal.EMFWorkspacePlugin;
import org.eclipse.emf.workspace.internal.Tracing;
import org.eclipse.emf.workspace.internal.l10n.Messages;

public class WorkspaceCommandStackImpl
extends AbstractTransactionalCommandStack
implements IWorkspaceCommandStack {
    private final IOperationHistory history;
    private DomainListener domainListener;
    private IUndoContext defaultContext;
    private IUndoContext savedContext;
    private Set affectedResources;
    private IUndoableOperation mostRecentOperation;

    public WorkspaceCommandStackImpl(IOperationHistory history) {
        this.history = history;
        this.domainListener = new DomainListener();
    }

    protected IUndoContext getUndoContext() {
        return null;
    }

    public void setEditingDomain(InternalTransactionalEditingDomain domain) {
        InternalTransactionalEditingDomain oldDomain = this.getDomain();
        if (oldDomain != null) {
            oldDomain.removeResourceSetListener((ResourceSetListener)this.domainListener);
            this.history.removeOperationHistoryListener((IOperationHistoryListener)this.domainListener);
        }
        super.setEditingDomain(domain);
        if (domain != null) {
            this.history.addOperationHistoryListener((IOperationHistoryListener)this.domainListener);
            domain.addResourceSetListener((ResourceSetListener)this.domainListener);
        }
    }

    public final IOperationHistory getOperationHistory() {
        return this.history;
    }

    public final IUndoContext getDefaultUndoContext() {
        if (this.defaultContext == null) {
            IUndoContext undoContext = this.getUndoContext();
            if (undoContext == null) {
                undoContext = new UndoContext();
            }
            this.defaultContext = undoContext;
        }
        return this.defaultContext;
    }

    private final IUndoContext getSavedContext() {
        if (this.savedContext == null) {
            this.savedContext = new UndoContext();
        }
        return this.savedContext;
    }

    protected void doExecute(Command command, Map options) throws InterruptedException, RollbackException {
        EMFCommandOperation oper = new EMFCommandOperation((TransactionalEditingDomain)this.getDomain(), command, options);
        oper.addContext(this.getDefaultUndoContext());
        try {
            IStatus status = this.history.execute((IUndoableOperation)oper, (IProgressMonitor)new NullProgressMonitor(), null);
            if (status.getSeverity() >= 4) {
                RollbackException exc = new RollbackException(status);
                Tracing.throwing(WorkspaceCommandStackImpl.class, (String)"execute", (Throwable)exc);
                throw exc;
            }
            this.notifyListeners();
        }
        catch (ExecutionException e) {
            Tracing.catching(WorkspaceCommandStackImpl.class, (String)"execute", (Throwable)e);
            command.dispose();
            if (e.getCause() instanceof RollbackException) {
                RollbackException exc = (RollbackException)e.getCause();
                Tracing.throwing(WorkspaceCommandStackImpl.class, (String)"execute", (Throwable)exc);
                throw exc;
            }
            if (e.getCause() instanceof RuntimeException) {
                RuntimeException exc = (RuntimeException)e.getCause();
                Tracing.throwing(WorkspaceCommandStackImpl.class, (String)"execute", (Throwable)exc);
                throw exc;
            }
            this.handleError((Exception)((Object)e));
        }
    }

    public boolean canUndo() {
        return this.getOperationHistory().canUndo(this.getDefaultUndoContext());
    }

    public void undo() {
        try {
            try {
                this.getOperationHistory().undo(this.getDefaultUndoContext(), (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Tracing.catching(WorkspaceCommandStackImpl.class, (String)"undo", (Throwable)e);
                this.handleError((Exception)((Object)e));
                this.notifyListeners();
            }
        }
        finally {
            this.notifyListeners();
        }
    }

    public boolean canRedo() {
        return this.getOperationHistory().canRedo(this.getDefaultUndoContext());
    }

    public void redo() {
        try {
            try {
                this.getOperationHistory().redo(this.getDefaultUndoContext(), (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Tracing.catching(WorkspaceCommandStackImpl.class, (String)"redo", (Throwable)e);
                this.handleError((Exception)((Object)e));
                this.notifyListeners();
            }
        }
        finally {
            this.notifyListeners();
        }
    }

    public void flush() {
        this.getOperationHistory().dispose(this.getDefaultUndoContext(), true, true, true);
        if (this.savedContext != null) {
            this.getOperationHistory().dispose(this.getSavedContext(), true, true, true);
            this.savedContext = null;
        }
        super.flush();
        this.mostRecentOperation = null;
    }

    public Command getMostRecentCommand() {
        Command result = null;
        if (this.mostRecentOperation instanceof EMFCommandOperation) {
            result = ((EMFCommandOperation)this.mostRecentOperation).getCommand();
        }
        return result;
    }

    public Command getUndoCommand() {
        Command result = null;
        IUndoableOperation topOperation = this.getOperationHistory().getUndoOperation(this.getDefaultUndoContext());
        if (topOperation instanceof EMFCommandOperation) {
            result = ((EMFCommandOperation)topOperation).getCommand();
        }
        return result;
    }

    public Command getRedoCommand() {
        Command result = null;
        IUndoableOperation topOperation = this.getOperationHistory().getRedoOperation(this.getDefaultUndoContext());
        if (topOperation instanceof EMFCommandOperation) {
            result = ((EMFCommandOperation)topOperation).getCommand();
        }
        return result;
    }

    public EMFCommandTransaction createTransaction(Command command, Map options) throws InterruptedException {
        Object result = command instanceof TriggerCommand ? new TriggerCommandTransaction((TriggerCommand)command, this.getDomain(), options) : new EMFOperationTransaction(command, this.getDomain(), options);
        result.start();
        return result;
    }

    public void executeTriggers(Command command, List triggers, Map options) throws InterruptedException, RollbackException {
        if (!triggers.isEmpty()) {
            TriggerCommand trigger = command == null ? new TriggerCommand(triggers) : new TriggerCommand(command, triggers);
            EMFCommandTransaction tx = this.createTransaction((Command)trigger, WorkspaceCommandStackImpl.makeTriggerTransactionOptions((Map)options));
            try {
                try {
                    trigger.execute();
                    InternalTransaction parent = (InternalTransaction)tx.getParent();
                    if (parent != null) {
                        parent.addTriggers(trigger);
                    }
                    tx.commit();
                }
                catch (RuntimeException e) {
                    Tracing.catching(WorkspaceCommandStackImpl.class, (String)"executeTriggers", (Throwable)e);
                    Object status = e instanceof OperationCanceledException ? Status.CANCEL_STATUS : new Status(4, EMFWorkspacePlugin.getPluginId(), 43, Messages.precommitFailed, (Throwable)e);
                    RollbackException rbe = new RollbackException(status);
                    Tracing.throwing(WorkspaceCommandStackImpl.class, (String)"executeTriggers", (Throwable)rbe);
                    throw rbe;
                }
            }
            finally {
                if (tx != null && tx.isActive()) {
                    this.rollback((Transaction)tx);
                }
            }
        }
    }

    public void dispose() {
        this.setEditingDomain(null);
        this.domainListener = null;
        this.affectedResources = null;
        this.mostRecentOperation = null;
    }

    public boolean isSaveNeeded() {
        IUndoableOperation nextUndoableOperation = this.history.getUndoOperation(this.getDefaultUndoContext());
        if (nextUndoableOperation == null) {
            return false;
        }
        return this.savedContext != null ? !nextUndoableOperation.hasContext(this.getSavedContext()) : true;
    }

    public void saveIsDone() {
        IUndoableOperation nextUndoableOperation;
        if (this.savedContext != null) {
            IUndoableOperation[] undoableOperations = this.history.getUndoHistory(this.getSavedContext());
            int i = 0;
            while (i < undoableOperations.length) {
                undoableOperations[i].removeContext(this.getSavedContext());
                ++i;
            }
            IUndoableOperation[] redoableOperations = this.history.getRedoHistory(this.getSavedContext());
            int i2 = 0;
            while (i2 < redoableOperations.length) {
                redoableOperations[i2].removeContext(this.getSavedContext());
                ++i2;
            }
        }
        if ((nextUndoableOperation = this.history.getUndoOperation(this.getDefaultUndoContext())) == null) {
            return;
        }
        nextUndoableOperation.addContext(this.getSavedContext());
    }

    private class DomainListener
    extends ResourceSetListenerImpl
    implements IOperationHistoryListener {
        private DomainListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            IUndoableOperation operation = event.getOperation();
            if (!operation.hasContext(WorkspaceCommandStackImpl.this.getDefaultUndoContext())) {
                return;
            }
            switch (event.getEventType()) {
                case 1: {
                    WorkspaceCommandStackImpl.this.affectedResources = new HashSet();
                    break;
                }
                case 4: {
                    if (WorkspaceCommandStackImpl.this.affectedResources != null && !WorkspaceCommandStackImpl.this.affectedResources.isEmpty()) {
                        Iterator iter = WorkspaceCommandStackImpl.this.affectedResources.iterator();
                        while (iter.hasNext()) {
                            operation.addContext((IUndoContext)new ResourceUndoContext((TransactionalEditingDomain)WorkspaceCommandStackImpl.this.getDomain(), (Resource)iter.next()));
                        }
                    }
                    WorkspaceCommandStackImpl.this.affectedResources = null;
                    if (!operation.hasContext(WorkspaceCommandStackImpl.this.getDefaultUndoContext())) break;
                    WorkspaceCommandStackImpl.this.mostRecentOperation = operation;
                    break;
                }
                case 7: {
                    WorkspaceCommandStackImpl.this.affectedResources = null;
                    break;
                }
                case 9: 
                case 10: {
                    if (!operation.hasContext(WorkspaceCommandStackImpl.this.getDefaultUndoContext())) break;
                    WorkspaceCommandStackImpl.this.mostRecentOperation = operation;
                    break;
                }
                case 8: {
                    if (operation != WorkspaceCommandStackImpl.this.mostRecentOperation) break;
                    WorkspaceCommandStackImpl.this.mostRecentOperation = null;
                }
            }
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Set unloaded;
            Set resources = ResourceUndoContext.getAffectedResources((List)event.getNotifications());
            ResourceSet resourceSet = WorkspaceCommandStackImpl.this.getDomain().getResourceSet();
            for (Resource resource : resources) {
                if (resourceSet == resource.getResourceSet()) continue;
                return;
            }
            if (WorkspaceCommandStackImpl.this.affectedResources != null) {
                WorkspaceCommandStackImpl.this.affectedResources.addAll(resources);
            }
            if ((unloaded = this.getUnloadedResources(event.getNotifications())) != null) {
                if (WorkspaceCommandStackImpl.this.affectedResources != null) {
                    WorkspaceCommandStackImpl.this.affectedResources.removeAll(unloaded);
                }
                Iterator iter = unloaded.iterator();
                while (iter.hasNext()) {
                    WorkspaceCommandStackImpl.this.getOperationHistory().dispose((IUndoContext)new ResourceUndoContext((TransactionalEditingDomain)WorkspaceCommandStackImpl.this.getDomain(), (Resource)iter.next()), true, true, true);
                }
            }
        }

        private Set getUnloadedResources(Collection notifications) {
            HashSet<Object> result = null;
            for (Notification next : notifications) {
                if (!NotificationFilter.RESOURCE_UNLOADED.matches(next)) continue;
                if (result == null) {
                    result = new HashSet<Object>();
                }
                result.add(next.getNotifier());
            }
            return result;
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }
}

