/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;

public class ChannelUriStringBuilder {
    private StringBuilder sb = new StringBuilder(64);
    private String prefix;
    private String media;
    private String endpoint;
    private String networkInterface;
    private String controlEndpoint;
    private String controlMode;
    private Boolean reliable;
    private Integer ttl;
    private Integer mtu;
    private Integer termLength;
    private Integer initialTermId;
    private Integer termId;
    private Integer termOffset;

    public ChannelUriStringBuilder clear() {
        this.prefix = null;
        this.media = null;
        this.endpoint = null;
        this.networkInterface = null;
        this.controlEndpoint = null;
        this.controlMode = null;
        this.reliable = null;
        this.ttl = null;
        this.mtu = null;
        this.termLength = null;
        this.initialTermId = null;
        this.termId = null;
        this.termOffset = null;
        return this;
    }

    public ChannelUriStringBuilder validate() {
        if (null == this.media) {
            throw new IllegalStateException("media type is mandatory");
        }
        if ("udp".equals(this.media) && null == this.endpoint && null == this.controlEndpoint) {
            throw new IllegalStateException("Either 'endpoint' or 'control' must be specified for UDP.");
        }
        int count = 0;
        count += null == this.initialTermId ? 0 : 1;
        count += null == this.termId ? 0 : 1;
        if ((count += null == this.termOffset ? 0 : 1) > 0 && count < 3) {
            throw new IllegalStateException("If any of then a complete set of 'initialTermId', 'termId', and 'termOffset' must be provided");
        }
        return this;
    }

    public ChannelUriStringBuilder prefix(String prefix) {
        if (null != prefix && !prefix.equals("") && !prefix.equals("aeron-spy")) {
            throw new IllegalArgumentException("Invalid prefix: " + prefix);
        }
        this.prefix = prefix;
        return this;
    }

    public String prefix() {
        return this.prefix;
    }

    public ChannelUriStringBuilder media(String media) {
        switch (media) {
            case "udp": 
            case "ipc": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid media: " + media);
            }
        }
        this.media = media;
        return this;
    }

    public String media() {
        return this.media;
    }

    public ChannelUriStringBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public ChannelUriStringBuilder networkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
    }

    public String networkInterface() {
        return this.networkInterface;
    }

    public ChannelUriStringBuilder controlEndpoint(String controlEndpoint) {
        this.controlEndpoint = controlEndpoint;
        return this;
    }

    public String controlEndpoint() {
        return this.controlEndpoint;
    }

    public ChannelUriStringBuilder controlMode(String controlMode) {
        if (null != controlMode && !controlMode.equals("manual") && !controlMode.equals("dynamic")) {
            throw new IllegalArgumentException("Invalid control mode: " + controlMode);
        }
        this.controlMode = controlMode;
        return this;
    }

    public String controlMode() {
        return this.controlMode;
    }

    public ChannelUriStringBuilder reliable(Boolean isReliable) {
        this.reliable = isReliable;
        return this;
    }

    public Boolean reliable() {
        return this.reliable;
    }

    public ChannelUriStringBuilder ttl(Integer ttl) {
        if (null != ttl && (ttl < 0 || ttl > 255)) {
            throw new IllegalArgumentException("TTL not in range 0-255: " + ttl);
        }
        this.ttl = ttl;
        return this;
    }

    public Integer ttl() {
        return this.ttl;
    }

    public ChannelUriStringBuilder mtu(Integer mtu) {
        if (null != mtu) {
            if (mtu < 32 || mtu > 65504) {
                throw new IllegalArgumentException("MTU not in range 32-65504: " + mtu);
            }
            if ((mtu & 0x1F) != 0) {
                throw new IllegalArgumentException("MTU not a multiple of FRAME_ALIGNMENT: mtu=" + mtu);
            }
        }
        this.mtu = mtu;
        return this;
    }

    public Integer mtu() {
        return this.mtu;
    }

    public ChannelUriStringBuilder termLength(Integer termLength) {
        if (null != termLength) {
            LogBufferDescriptor.checkTermLength(termLength);
        }
        this.termLength = termLength;
        return this;
    }

    public Integer termLength() {
        return this.termLength;
    }

    public ChannelUriStringBuilder initialTermId(Integer initialTermId) {
        this.initialTermId = initialTermId;
        return this;
    }

    public Integer initialTermId() {
        return this.initialTermId;
    }

    public ChannelUriStringBuilder termId(Integer termId) {
        this.termId = termId;
        return this;
    }

    public Integer termId() {
        return this.termId;
    }

    public ChannelUriStringBuilder termOffset(Integer termOffset) {
        if (null != termOffset) {
            if (termOffset < 0 || termOffset > 0x40000000) {
                throw new IllegalArgumentException("Term offset not in range 0-1g: " + termOffset);
            }
            if (0 != (termOffset & 0x1F)) {
                throw new IllegalArgumentException("Term offset not multiple of FRAME_ALIGNMENT: " + termOffset);
            }
        }
        this.termOffset = termOffset;
        return this;
    }

    public Integer termOffset() {
        return this.termOffset;
    }

    public String build() {
        char lastChar;
        this.sb.setLength(0);
        if (null != this.prefix && !"".equals(this.prefix)) {
            this.sb.append(this.prefix).append(':');
        }
        this.sb.append("aeron").append(':').append(this.media).append('?');
        if (null != this.endpoint) {
            this.sb.append("endpoint").append('=').append(this.endpoint).append('|');
        }
        if (null != this.networkInterface) {
            this.sb.append("interface").append('=').append(this.networkInterface).append('|');
        }
        if (null != this.controlEndpoint) {
            this.sb.append("control").append('=').append(this.controlEndpoint).append('|');
        }
        if (null != this.controlMode) {
            this.sb.append("control-mode").append('=').append(this.controlMode).append('|');
        }
        if (null != this.reliable) {
            this.sb.append("reliable").append('=').append(this.reliable).append('|');
        }
        if (null != this.ttl) {
            this.sb.append("ttl").append('=').append(this.ttl).append('|');
        }
        if (null != this.mtu) {
            this.sb.append("mtu").append('=').append(this.mtu).append('|');
        }
        if (null != this.termLength) {
            this.sb.append("term-length").append('=').append(this.termLength).append('|');
        }
        if (null != this.initialTermId) {
            this.sb.append("init-term-id").append('=').append(this.initialTermId).append('|');
        }
        if (null != this.termId) {
            this.sb.append("term-id").append('=').append(this.termId).append('|');
        }
        if (null != this.termOffset) {
            this.sb.append("term-offset").append('=').append(this.termOffset).append('|');
        }
        if ((lastChar = this.sb.charAt(this.sb.length() - 1)) == '|' || lastChar == '?') {
            this.sb.setLength(this.sb.length() - 1);
        }
        return this.sb.toString();
    }
}

