/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import java.util.HashMap;
import java.util.Map;

public class ChannelUri {
    public static final String AERON_SCHEME = "aeron";
    public static final String SPY_QUALIFIER = "aeron-spy";
    private static final String AERON_PREFIX = "aeron:";
    private final String prefix;
    private final String media;
    private final Map<String, String> params;

    public ChannelUri(String prefix, String media, Map<String, String> params) {
        this.prefix = prefix;
        this.media = media;
        this.params = params;
    }

    public ChannelUri(String media, Map<String, String> params) {
        this("", media, params);
    }

    public String prefix() {
        return this.prefix;
    }

    public String media() {
        return this.media;
    }

    public String scheme() {
        return AERON_SCHEME;
    }

    public String get(String key) {
        return this.params.get(key);
    }

    public String get(String key, String defaultValue) {
        String value = this.params.get(key);
        if (null != value) {
            return value;
        }
        return defaultValue;
    }

    public String put(String key, String value) {
        return this.params.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.params.containsKey(key);
    }

    public String toString() {
        StringBuilder sb;
        if (this.prefix == null || "".equals(this.prefix)) {
            sb = new StringBuilder(this.params.size() * 20 + 10);
        } else {
            sb = new StringBuilder(this.params.size() * 20 + 20);
            sb.append("aeron-spy:");
        }
        sb.append(AERON_PREFIX).append(this.media);
        if (this.params.size() > 0) {
            sb.append('?');
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                sb.append(entry.getKey()).append('=').append(entry.getValue()).append('|');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static ChannelUri parse(CharSequence cs) {
        String prefix;
        int position = 0;
        if (ChannelUri.startsWith(cs, "aeron-spy:")) {
            prefix = SPY_QUALIFIER;
            position = "aeron-spy:".length();
        } else {
            prefix = "";
        }
        if (!ChannelUri.startsWith(cs, position, AERON_PREFIX)) {
            throw new IllegalArgumentException("Aeron URIs must start with 'aeron:', found: '" + cs + "'");
        }
        position += AERON_PREFIX.length();
        StringBuilder builder = new StringBuilder();
        HashMap<String, String> params = new HashMap<String, String>();
        String media = null;
        String key = null;
        State state = State.MEDIA;
        block19: for (int i = position; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            switch (state) {
                case MEDIA: {
                    switch (c) {
                        case '?': {
                            media = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block19;
                        }
                        case ':': {
                            throw new IllegalArgumentException("Encountered ':' within media definition");
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                case PARAMS_KEY: {
                    switch (c) {
                        case '=': {
                            key = builder.toString();
                            builder.setLength(0);
                            state = State.PARAMS_VALUE;
                            continue block19;
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                case PARAMS_VALUE: {
                    switch (c) {
                        case '|': {
                            params.put(key, builder.toString());
                            builder.setLength(0);
                            state = State.PARAMS_KEY;
                            continue block19;
                        }
                    }
                    builder.append(c);
                    continue block19;
                }
                default: {
                    throw new IllegalStateException("Que? state=" + (Object)((Object)state));
                }
            }
        }
        switch (state) {
            case MEDIA: {
                media = builder.toString();
                break;
            }
            case PARAMS_VALUE: {
                params.put(key, builder.toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("No more input found, but was in state: " + (Object)((Object)state));
            }
        }
        return new ChannelUri(prefix, media, params);
    }

    private static boolean startsWith(CharSequence input, int position, CharSequence prefix) {
        if (input.length() - position < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (input.charAt(position + i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWith(CharSequence input, CharSequence prefix) {
        return ChannelUri.startsWith(input, 0, prefix);
    }

    private static enum State {
        MEDIA,
        PARAMS_KEY,
        PARAMS_VALUE;

    }
}

