/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.session;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.session.Messages;

public class GitConflictHelper {
    private GitConflictHelper() {
    }

    public static Set<IFile> getFilesInConflict(IProject project) {
        return GitConflictHelper.getFiles(project, GitConflictHelper::hasConflict);
    }

    public static Set<IFile> getFiles(IProject project, final Predicate<IFile> predicate) {
        final HashSet<IFile> conflictFiles = new HashSet<IFile>();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile && (CapellaResourceHelper.isAirdResource((IResource)resource, (boolean)false) || CapellaResourceHelper.isCapellaResource((IResource)resource) || CapellaResourceHelper.isAfmResource((IResource)resource)) && predicate.test((IFile)resource)) {
                        conflictFiles.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return conflictFiles;
    }

    private static Set<IFile> getRelatedFiles(Resource resource) {
        EObject rootEObj;
        HashSet<IFile> relatedFiles = new HashSet<IFile>();
        IFile file = EcoreUtil2.getFile((Resource)resource);
        if (file != null) {
            relatedFiles.add(file);
        }
        if (resource instanceof AirdResource && (rootEObj = (EObject)resource.getContents().get(0)) instanceof DAnalysis) {
            ((DAnalysis)rootEObj).getSemanticResources().stream().map(GitConflictHelper::getFile).filter(Objects::nonNull).forEach(x -> {
                boolean bl = relatedFiles.add((IFile)x);
            });
        }
        return relatedFiles;
    }

    private static IFile getFile(ResourceDescriptor descriptor) {
        URI resourceURI;
        if (descriptor != null && (resourceURI = descriptor.getResourceURI()) != null && resourceURI.isPlatformResource()) {
            IFile semanticFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourceURI.toPlatformString(true)));
            return semanticFile;
        }
        return null;
    }

    public static boolean isInGitRepository(Resource res) {
        EObject rootEObj;
        IFile file = EcoreUtil2.getFile((Resource)res);
        if (GitConflictHelper.isInGitRepository(file)) {
            return true;
        }
        if (res instanceof AirdResource && (rootEObj = (EObject)res.getContents().get(0)) instanceof DAnalysis) {
            for (ResourceDescriptor resDesc : ((DAnalysis)rootEObj).getSemanticResources()) {
                IFile resfile = GitConflictHelper.getFile(resDesc);
                if (!GitConflictHelper.isInGitRepository(resfile)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasConflict(IFile file) {
        if (file != null) {
            java.nio.file.Path filePath = Paths.get(file.getLocationURI());
            Repository[] repositoryArray = Activator.getDefault().getRepositoryCache().getAllRepositories();
            int n = repositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo = repositoryArray[n2];
                java.nio.file.Path repoPath = Paths.get(repo.getWorkTree().toURI());
                if (filePath.startsWith(repoPath)) {
                    java.nio.file.Path relativizedPath = repoPath.relativize(filePath);
                    try {
                        DirCacheEntry entry;
                        DirCache readDirCache = repo.readDirCache();
                        if (readDirCache != null && (entry = readDirCache.getEntry(relativizedPath.toString().replace("\\", "/"))) != null) {
                            return entry.getStage() > 0;
                        }
                    }
                    catch (IOException | NoWorkTreeException throwable) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isInGitRepository(IFile file) {
        if (file != null) {
            java.nio.file.Path filePath = Paths.get(file.getLocationURI());
            Repository[] repositoryArray = Activator.getDefault().getRepositoryCache().getAllRepositories();
            int n = repositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo = repositoryArray[n2];
                java.nio.file.Path repoPath = Paths.get(repo.getWorkTree().toURI());
                if (filePath.startsWith(repoPath)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static IStatus checkConflictFiles(Session session) {
        Set<IFile> inConflictFiles = GitConflictHelper.getFilesInConflict(session);
        if (!inConflictFiles.isEmpty()) {
            return new Status(4, CapellaActionsActivator.getDefault().getPluginId(), NLS.bind((String)Messages.GitConflictHelper_ResourcesInConflictState, (Object)inConflictFiles.stream().map(IFile::getName).collect(Collectors.joining(", "))));
        }
        return Status.OK_STATUS;
    }

    public static boolean isInGitRepository(Session session) {
        return session.getAllSessionResources().stream().anyMatch(GitConflictHelper::isInGitRepository);
    }

    public static Set<IFile> getFiles(Session session, Predicate<IFile> file) {
        Set sessionRelatedFiles = session.getAllSessionResources().stream().flatMap(x -> GitConflictHelper.getRelatedFiles(x).stream()).collect(Collectors.toSet());
        Stream<IProject> relatedProjects = sessionRelatedFiles.stream().map(IResource::getProject).distinct();
        Stream conflictsFromRelatedProjects = relatedProjects.flatMap(x -> GitConflictHelper.getFiles(x, (IFile c) -> true).stream());
        return Stream.concat(sessionRelatedFiles.stream(), conflictsFromRelatedProjects).filter(file).collect(Collectors.toSet());
    }

    public static Set<IFile> getFilesInConflict(Session session) {
        return GitConflictHelper.getFiles(session, GitConflictHelper::hasConflict);
    }

    public static IStatus checkConflictFiles(IProject project) {
        Set<IFile> inConflictFiles = GitConflictHelper.getFilesInConflict(project);
        if (!inConflictFiles.isEmpty()) {
            return new Status(4, CapellaActionsActivator.getDefault().getPluginId(), NLS.bind((String)Messages.GitConflictHelper_ResourcesInConflictState, (Object)inConflictFiles.stream().map(IFile::getName).collect(Collectors.joining(", "))));
        }
        return Status.OK_STATUS;
    }
}

