/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.raw;

import com.nomagic.esi.api.raw.AttributeType;
import java.util.Arrays;
import java.util.List;

public class Attribute {
    private Object[] arrayValue;
    private AttributeType type;
    private Object value;

    public Attribute(AttributeType attributeType, boolean bl, Object object) {
        this.type = attributeType;
        this.value = object;
        this.arrayValue = bl ? (Object[])object : null;
    }

    public AttributeType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public List<Object> getWrappedValue() {
        List<Object> list = this.isArray() ? Arrays.asList(this.arrayValue) : Arrays.asList(this.value);
        return list;
    }

    public boolean isArray() {
        return this.arrayValue != null;
    }

    public String toString() {
        String string;
        if (this.arrayValue != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            while (n < this.arrayValue.length) {
                stringBuilder.append(this.arrayValue[n]);
                if (n != this.arrayValue.length - 1) {
                    stringBuilder.append(",");
                }
                ++n;
            }
            stringBuilder.append("]");
            string = stringBuilder.toString();
        } else {
            string = String.valueOf(this.value);
        }
        return string;
    }
}

