/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.config;

import com.nomagic.esi.api.config.SslClientConfig;
import com.nomagic.esi.api.messages.config.SslServerConfig;
import com.nomagic.esi.api.messages.config.UserManagementConfig;
import com.nomagic.esi.api.messages.exceptions.InvalidConfigurationException;
import com.nomagic.esi.helper.a.d;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFactory {
    private static final String DEFAULT_KEYSTORE_PASSWORD = "1234567890";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int MAX_PORT_NUMBER = 65535;

    public static SslServerConfig createServerConfig(int n, boolean bl, String string, byte[] byArray, String string2) {
        return ConfigFactory.createServerConfig(n, bl, string, byArray, string2, null);
    }

    public static SslServerConfig createServerConfig(int n, boolean bl, String string, byte[] byArray, String string2, String string3) {
        SslServerConfig sslServerConfig = new SslServerConfig(n, bl, string, byArray, string2, string3);
        ConfigFactory.validateSslServerConfig(sslServerConfig);
        return sslServerConfig;
    }

    public static SslServerConfig createServerConfig(int n, boolean bl, String string, String string2, String string3) throws IOException {
        byte[] byArray = Files.readAllBytes(new File(string2).toPath());
        return ConfigFactory.createServerConfig(n, bl, string, byArray, string3);
    }

    public static SslServerConfig createServerConfig(int n, boolean bl, String string, String string2, String string3, String string4) throws IOException {
        byte[] byArray = Files.readAllBytes(new File(string2).toPath());
        return ConfigFactory.createServerConfig(n, bl, string, byArray, string3, string4);
    }

    @Deprecated
    public static SslClientConfig createSslClientConfig(String string, String string2) {
        try {
            return new SslClientConfig(string, string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Deprecated
    public static UserManagementConfig createUserManagementConfig(boolean bl) {
        return new UserManagementConfig(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void validateSslServerConfig(SslServerConfig sslServerConfig) {
        if (!sslServerConfig.isEnabled()) return;
        try {
            if (sslServerConfig.getServerKeystore() == null) {
                throw new NullPointerException("The server keystore cannot be null");
            }
            if (!ConfigFactory.isValidPort(sslServerConfig.getPort())) {
                String string = String.format("Invalid port number %s, the valid range is 0-%s", Integer.toString(sslServerConfig.getPort()), Integer.toString(65535));
                throw new IllegalArgumentException(string);
            }
            if (sslServerConfig.getServerKeystoreName() == null) throw new IllegalArgumentException("The server keystore name must be the name of keystore file name");
            if (sslServerConfig.getServerKeystoreName().trim().length() == 0) {
                throw new IllegalArgumentException("The server keystore name must be the name of keystore file name");
            }
            d.a((byte[])sslServerConfig.getServerKeystore(), (char[])sslServerConfig.getServerPass().toCharArray());
            return;
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
            throw new InvalidConfigurationException("Unable to construct TLS configuration: " + exception.getMessage() + ".", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidPort(int n) {
        return n >= 0 && n <= 65535;
    }

    SslClientConfig createSslClientConfig(byte[] byArray, String string) {
        return new SslClientConfig(byArray, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore createKeyStoreFromCertificates(File ... fileArray) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("x509");
        String string = "alias%s";
        int n = 0;
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray2[n3];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Load certificates from {}", (Object)file.getName());
            }
            Throwable throwable = null;
            Object var10_11 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Collection<? extends Certificate> collection = certificateFactory.generateCertificates(fileInputStream);
                for (Certificate certificate : collection) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found certificate {}", (Object)x509Certificate.getSubjectDN().getName());
                    }
                    keyStore.setCertificateEntry(String.format(string, Integer.toString(n++)), x509Certificate);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            ++n3;
        }
        return keyStore;
    }

    public static SslClientConfig createSslClientConfigFromCertificates(File ... fileArray) throws IOException {
        try {
            KeyStore keyStore = ConfigFactory.createKeyStoreFromCertificates(fileArray);
            Object object = new ByteArrayOutputStream();
            keyStore.store((OutputStream)object, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            ((ByteArrayOutputStream)object).close();
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            object = new SslClientConfig(byArray, DEFAULT_KEYSTORE_PASSWORD);
            return object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }
}

