/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api;

import com.nomagic.esi.api.info.LdapInfo;
import com.nomagic.esi.api.info.RoleAssignmentLatestInfo;
import com.nomagic.esi.api.info.RoleInfo;
import com.nomagic.esi.api.info.SessionInfo;
import com.nomagic.esi.api.info.UserInfo;
import com.nomagic.esi.api.messages.OperationResult;
import com.nomagic.esi.api.messages.exceptions.InvalidObjectAssignmentException;
import com.nomagic.esi.api.messages.exceptions.LdapException;
import com.nomagic.esi.api.messages.exceptions.LdapNotFoundException;
import com.nomagic.esi.api.messages.exceptions.RoleNotFoundException;
import com.nomagic.esi.api.messages.exceptions.TwcException;
import com.nomagic.esi.api.messages.exceptions.UserGroupNotFoundException;
import com.nomagic.esi.api.messages.info.LdapAccountInfo;
import com.nomagic.esi.api.messages.info.ProtectedObjectInfo;
import com.nomagic.esi.api.messages.info.UserGroupInfo;
import com.nomagic.esi.helper.annotation.Since;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface UserManager {
    public UserInfo createUser(String var1, String var2, boolean var3, Map<String, String> var4);

    public UserInfo createExternalUser(String var1, boolean var2, String var3, Map<String, String> var4);

    public void enableUser(String var1);

    public void disableUser(String var1) throws TwcException;

    public void changePassword(String var1, String var2);

    public void resetPassword(String var1, String var2);

    public UserInfo updateUserInfo(String var1, Map<String, String> var2);

    public void updateUserRealm(String var1, String var2);

    public List<UserInfo> getUsers();

    public UserInfo getUserInfo(String var1);

    public Map<String, OperationResult<UserInfo>> getUserInfos(List<String> var1);

    public List<String> getUserNamesByRegex(String var1);

    public LdapInfo addLdapInfo(String var1, String var2, String var3, String var4, String var5, String var6, Map<String, String> var7);

    public void removeLdapInfo(UUID var1);

    public void updateLdapInfo(UUID var1, String var2, String var3, String var4, String var5, String var6, String var7, Map<String, String> var8);

    public List<LdapInfo> getLdapInfos();

    public void assignRole(String var1, UUID var2, List<ProtectedObjectInfo> var3, boolean var4) throws RoleNotFoundException, InvalidObjectAssignmentException;

    @Deprecated
    public void assignRolesToUsers(List<String> var1, Map<UUID, List<ProtectedObjectInfo>> var2, boolean var3) throws RoleNotFoundException, InvalidObjectAssignmentException;

    public void assignRolesToUsers(ArrayList<String> var1, HashMap<UUID, ArrayList<ProtectedObjectInfo>> var2, boolean var3) throws RoleNotFoundException, InvalidObjectAssignmentException;

    public void unAssignRole(String var1, UUID var2);

    public void unAssignRoles(String var1);

    public void unAssignObjects(String var1, UUID var2, List<ProtectedObjectInfo> var3);

    public List<String> getUserNamesByRole(UUID var1);

    public List<String> getUserNamesByResourceScopeRole(UUID var1);

    public List<SessionInfo> getActiveSessions();

    public List<RoleAssignmentLatestInfo> getAssignedRoleAssignments(UUID var1);

    public void copyRoleAssignmentByResource(UUID var1, UUID var2);

    public List<UUID> getRoleIDs(UUID var1);

    public List<LdapAccountInfo> searchLdapAccount(String var1, String var2, String var3, String var4, String var5, String var6, Map<String, String> var7, String var8) throws LdapException;

    public List<LdapAccountInfo> searchLdapAccount(UUID var1, String var2) throws LdapException, LdapNotFoundException;

    public UserGroupInfo createUserGroup(String var1, String var2, String var3, HashSet<String> var4, HashMap<UUID, ArrayList<ProtectedObjectInfo>> var5);

    public UserGroupInfo getUserGroup(UUID var1);

    public List<UserGroupInfo> getUserGroupsByUser(String var1);

    public List<UserGroupInfo> getAllUserGroups();

    public void deleteUserGroup(UUID var1) throws UserGroupNotFoundException;

    public void updateUserGroupInfo(UUID var1, String var2, String var3, String var4) throws UserGroupNotFoundException;

    public void addUserIntoUserGroup(UUID var1, HashSet<String> var2) throws UserGroupNotFoundException;

    public void removeUserFromUserGroup(UUID var1, HashSet<String> var2) throws UserGroupNotFoundException;

    public void addRoleAssignmentIntoUserGroup(UUID var1, HashMap<UUID, ArrayList<ProtectedObjectInfo>> var2) throws UserGroupNotFoundException;

    public void removeRoleAssignmentFromUserGroup(UUID var1, ArrayList<UUID> var2) throws UserGroupNotFoundException;

    public void removeProtectedObjectFromUserGroup(UUID var1, HashMap<UUID, ArrayList<ProtectedObjectInfo>> var2) throws UserGroupNotFoundException;

    public List<UserGroupInfo> getOwnUserGroups();

    @Since(value="19.0.3")
    public List<RoleInfo> getOwnRoles();

    public Map<String, OperationResult<LdapAccountInfo>> lookupLdapAccounts(UUID var1, ArrayList<String> var2) throws LdapException;

    @Since(value="19.0.3")
    public List<UserInfo> findUsersModifiedAfter(Date var1);

    @Since(value="19.0.3")
    public Map<UUID, OperationResult<UserGroupInfo>> findUserGroupsModifiedAfter(List<UUID> var1, boolean var2, Date var3);
}

