/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api;

import com.nomagic.esi.api.info.BranchInfo;
import com.nomagic.esi.api.info.CategoryInfo;
import com.nomagic.esi.api.info.CommitInfo;
import com.nomagic.esi.api.info.ResourceInfo;
import com.nomagic.esi.api.info.TagInfo;
import com.nomagic.esi.api.messages.OperationResult;
import com.nomagic.esi.api.messages.info.IdAndRev;
import com.nomagic.esi.api.messages.info.ResourceAndBranch;
import com.nomagic.esi.helper.annotation.Since;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public interface RepositoryManager {
    public ResourceInfo getResourceInfo(UUID var1);

    @Deprecated
    public List<ResourceInfo> getResourceInfos(boolean var1);

    public List<ResourceInfo> getResourceInfos(UUID var1, boolean var2);

    @Since(value="19.0.3")
    public List<ResourceInfo> findResourcesModifiedAfter(UUID var1, Date var2);

    public ResourceInfo updateResourceInfo(UUID var1, Map<String, ?> var2, UUID var3);

    public void removeResource(UUID var1);

    public CommitInfo commitRevisionAsLatest(UUID var1, UUID var2, long var3, String var5, String var6);

    public BranchInfo getBranchInfo(UUID var1, UUID var2);

    public List<BranchInfo> getBranchInfos(UUID var1);

    public List<BranchInfo> getBranchInfos(Collection<ResourceAndBranch> var1);

    public BranchInfo createBranch(UUID var1, long var2, String var4, String var5, String var6);

    public BranchInfo updateBranchInfo(UUID var1, UUID var2, String var3, String var4);

    public void removeBranch(UUID var1, UUID var2);

    public TagInfo getTagInfo(UUID var1, UUID var2);

    public List<TagInfo> getTagInfos(UUID var1);

    public TagInfo createTag(UUID var1, long var2, String var4, String var5);

    public TagInfo updateTagInfo(UUID var1, UUID var2, String var3, String var4);

    public void removeTag(UUID var1, UUID var2);

    public CommitInfo getCommitInfo(UUID var1, long var2);

    public List<CommitInfo> getCommitInfos(Collection<IdAndRev> var1);

    public CommitInfo getLatestCommitInfo(UUID var1, UUID var2);

    public List<CommitInfo> getCommitInfosFromRevision(UUID var1, long var2, int var4);

    public List<CommitInfo> getCommitInfosFromBranch(UUID var1, UUID var2, int var3);

    public List<CategoryInfo> getCategoryInfos();

    @Since(value="19.0.3")
    public Map<UUID, OperationResult<CategoryInfo>> findCategoriesModifiedAfter(List<UUID> var1, boolean var2, Date var3);

    public CategoryInfo getCategoryInfo(UUID var1);

    public void removeCategory(UUID var1);

    public CategoryInfo updateCategoryInfo(UUID var1, String var2, String var3, List<UUID> var4);

    public CategoryInfo createCategory(String var1, String var2, List<UUID> var3);

    public boolean ePackageExists(String var1);

    public Set<String> getEPackageNsURIs();
}

