/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.util;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.proxy.resource.ProxySupporterResource;
import com.nomagic.ci.persistence.local.spi.IExtendedResource;
import com.nomagic.ci.persistence.local.spi.IExtendedResourceSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;

public class ResourceUtil {
    private static final Pattern PATTERN = Pattern.compile("[:/?\\#\\[\\]@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]");
    private static final Logger LOGGER = Logger.getLogger(ResourceUtil.class);

    private ResourceUtil() {
    }

    public static boolean isLoaded(Resource resource) {
        if (ResourceUtil.isProxySupportEnabled(resource)) {
            return ((ProxySupporterResource)resource).isActuallyLoaded();
        }
        return resource.isLoaded();
    }

    public static boolean isProxySupportEnabled(Resource resource) {
        return resource instanceof ProxySupporterResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isProxyContainer(Resource resource) {
        return ResourceUtil.isProxySupportEnabled(resource) && ((ProxySupporterResource)resource).isProxyContainer();
    }

    public static void setProxyContainer(Resource resource, boolean bl) {
        ((ProxySupporterResource)resource).setProxyContainer(bl);
    }

    public static String toID(URI uRI) {
        String string = uRI.toString();
        return PATTERN.matcher(string).replaceAll("_");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Resource getActuallyLoadedResource(ResourceSet resourceSet, URI uRI, boolean bl) {
        Resource resource = resourceSet.getResource(uRI, bl);
        if (!bl) return resource;
        if (ResourceUtil.isLoaded(resource)) return resource;
        if (!resourceSet.getURIConverter().exists(resource.getURI(), null)) return resource;
        try {
            try {
                resource.unload();
                ResourceUtil.safelyLoadResource(resource, resourceSet.getLoadOptions());
                return resource;
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
        finally {
            ResourceUtil.logResourceUnknownFeatures(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, Object> createSafeResourceLoadOptions(Map<?, ?> map) {
        Map<Object, Object> map2;
        if (map == null) {
            map2 = ResourceUtil.privateCreateSafeResourceLoadOptions(map);
        } else {
            Map<?, ?> map3 = map;
            synchronized (map3) {
                map2 = ResourceUtil.privateCreateSafeResourceLoadOptions(map);
            }
        }
        return map2;
    }

    private static Map<Object, Object> privateCreateSafeResourceLoadOptions(Map<?, ?> map) {
        HashMap<Object, Object> hashMap = map == null ? new HashMap() : new HashMap(map);
        if (hashMap.get("RECORD_UNKNOWN_FEATURE") != Boolean.TRUE) {
            hashMap.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static Map<EObject, AnyType> logResourceUnknownFeatures(Resource resource) {
        if (!(resource instanceof XMLResource)) return Collections.emptyMap();
        Map map = ((XMLResource)resource).getEObjectToExtensionMap();
        if (map.isEmpty()) return Collections.emptyMap();
        for (Map.Entry entry : map.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            LOGGER.warn((Object)("Element " + EcoreUtil.getIdentification((EObject)eObject) + " has the following invalid children:"));
            AnyType anyType = (AnyType)entry.getValue();
            FeatureMap featureMap = anyType.getAnyAttribute();
            int n2 = 0;
            int n3 = featureMap.size();
            while (n2 < n3) {
                LOGGER.warn((Object)("\t attribute: " + featureMap.getEStructuralFeature(n2).getName()));
                ++n2;
            }
            FeatureMap featureMap2 = anyType.getAny();
            n3 = 0;
            int n4 = featureMap2.size();
            while (n3 < n4) {
                LOGGER.warn((Object)("\t child element: " + featureMap2.getEStructuralFeature(n3).getName()));
                ++n3;
            }
        }
        return map;
    }

    public static void safelyLoadResource(Resource resource, Map<?, ?> map) throws IOException {
        block6: {
            try {
                Map<Object, Object> map2;
                block5: {
                    map2 = ResourceUtil.createSafeResourceLoadOptions(map);
                    if (!(resource instanceof IExtendedResource)) break block5;
                    ((IExtendedResource)resource).superLoad(map2);
                    break block6;
                }
                resource.load(map2);
            }
            finally {
                ResourceUtil.logResourceUnknownFeatures(resource);
            }
        }
    }

    public static Resource safelyFetchResource(ResourceSet resourceSet, URI uRI, boolean bl) {
        Map map;
        if (!bl) {
            return ResourceUtil.doFetchResource(resourceSet, uRI, bl);
        }
        Map map2 = map = resourceSet.getLoadOptions();
        synchronized (map2) {
            Resource resource;
            HashMap hashMap = new HashMap(map);
            Map<Object, Object> map3 = ResourceUtil.createSafeResourceLoadOptions(hashMap);
            map.putAll(map3);
            Resource resource2 = null;
            try {
                resource = resource2 = ResourceUtil.doFetchResource(resourceSet, uRI, bl);
            }
            catch (Throwable throwable) {
                ResourceUtil.logResourceUnknownFeatures(resource2);
                map.clear();
                map.putAll(hashMap);
                throw throwable;
            }
            ResourceUtil.logResourceUnknownFeatures(resource2);
            map.clear();
            map.putAll(hashMap);
            return resource;
        }
    }

    private static Resource doFetchResource(ResourceSet resourceSet, URI uRI, boolean bl) {
        if (resourceSet instanceof IExtendedResourceSet) {
            return ((IExtendedResourceSet)resourceSet).superGetResource(uRI, bl);
        }
        return resourceSet.getResource(uRI, bl);
    }
}

