/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class ResourceLoadAdapter
extends AdapterImpl {
    public abstract void onLoadStateChange(Resource var1, boolean var2);

    public void notifyChanged(Notification notification) {
        ResourceSet resourceSet;
        Object object = notification.getNotifier();
        if (object instanceof ResourceSet) {
            resourceSet = (ResourceSet)object;
            this.notifyResourceSet(notification, resourceSet);
        }
        if (object instanceof Resource) {
            resourceSet = (Resource)object;
            this.notifyResource(notification, (Resource)resourceSet);
        }
        super.notifyChanged(notification);
    }

    protected void notifyResourceSet(Notification notification, ResourceSet resourceSet) {
        switch (notification.getEventType()) {
            case 3: {
                Resource resource = (Resource)notification.getNewValue();
                this.onResourceAdd(resource);
                break;
            }
            case 4: {
                Resource resource = (Resource)notification.getOldValue();
                this.onResourceRemove(resource);
            }
        }
    }

    protected void onResourceAdd(Resource resource) {
        try {
            if (resource.isLoaded()) {
                this.onLoadStateChange(resource, true);
            }
        }
        finally {
            resource.eAdapters().add((Object)this);
        }
    }

    protected void onResourceRemove(Resource resource) {
        try {
            if (resource.isLoaded()) {
                this.onLoadStateChange(resource, false);
            }
        }
        finally {
            resource.eAdapters().remove((Object)this);
        }
    }

    protected void notifyResource(Notification notification, Resource resource) {
        if (notification.getFeatureID(Resource.class) == 4) {
            this.onLoadStateChange(resource, notification.getNewBooleanValue());
        }
    }
}

