/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.util;

import com.nomagic.ci.metamodel.local.project.ProjectUsage;
import com.nomagic.ci.metamodel.project.AbstractProjectUsage;
import com.nomagic.ci.metamodel.project.Project;
import com.nomagic.ci.metamodel.project.ProjectFeature;
import com.nomagic.ci.metamodel.project.util.DecompositionModelUtil;
import com.nomagic.ci.persistence.IPrimaryProject;
import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.IProjectResourceProvider;
import com.nomagic.ci.persistence.features.IProjectFeatureDescriptor;
import com.nomagic.ci.persistence.features.IProjectFeatureHandler;
import com.nomagic.ci.persistence.features.IProjectFeatureHandlerService;
import com.nomagic.ci.persistence.local.ILocalResourceDescriptor;
import com.nomagic.ci.persistence.local.internal.m.b;
import com.nomagic.ci.persistence.local.internal.w;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.IProjectInternal;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.spi.decomposition.AttachmentSet;
import com.nomagic.ci.persistence.spi.decomposition.IDecompositionModel;
import com.nomagic.ci.persistence.spi.decomposition.IProjectUsageManager;
import com.nomagic.ci.persistence.util.ProjectUtil;
import com.nomagic.ci.services.SingletonServiceDiscovery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class LocalProjectUtil
extends ProjectUtil {
    private static final AtomicInteger updatingThreadCount = new AtomicInteger(0);
    private static final ThreadLocal<Boolean> updatingInCurrentThread = new ThreadLocal();

    @CheckForNull
    public static IProject getProject(@CheckForNull Resource resource) {
        if (resource != null) {
            IProjectResourceProvider iProjectResourceProvider = (IProjectResourceProvider)SingletonServiceDiscovery.INSTANCE.getService(IProjectResourceProvider.class);
            IProject iProject = iProjectResourceProvider.getProject(resource);
            return iProject;
        }
        return null;
    }

    public static IProject getProject(IPrimaryProject iPrimaryProject, URI uRI) {
        if (iPrimaryProject != null) {
            for (IProject iProject : LocalProjectUtil.getProjects((IPrimaryProject)iPrimaryProject)) {
                AbstractProject abstractProject = (AbstractProject)iProject;
                if (abstractProject.getUriMapper().getResourceInfo(uRI) == null) continue;
                return iProject;
            }
        }
        return null;
    }

    public static IProject findProjectByURI(IPrimaryProject iPrimaryProject, URI uRI) {
        if (iPrimaryProject != null) {
            for (IProject iProject : LocalProjectUtil.getProjects((IPrimaryProject)iPrimaryProject)) {
                URI uRI2 = iProject.getLocationURI();
                if (uRI2.equals((Object)uRI)) {
                    return iProject;
                }
                URI uRI3 = ((IProjectInternal)iProject).getLoadedFrom();
                if (uRI3 == null || !uRI3.equals((Object)uRI)) continue;
                return iProject;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<Resource> getResources(@Nonnull IProject iProject, @Nonnull IProjectFeatureDescriptor iProjectFeatureDescriptor) {
        String string = iProjectFeatureDescriptor.getNamespace();
        HashSet<Resource> hashSet = new HashSet<Resource>(2);
        for (Resource resource : ((AbstractProject)iProject).getManagedResources()) {
            String string2 = ((AbstractProject)iProject).getResourceDescriptor(resource).getResourceFeatureDescriptor().getNamespace();
            if (!string.equals(string2)) continue;
            hashSet.add(resource);
        }
        return hashSet;
    }

    public static IProjectFeatureHandler getHandler(@Nonnull Resource resource) {
        IProject iProject = LocalProjectUtil.getProject(resource);
        if (iProject == null) {
            return null;
        }
        return LocalProjectUtil.getHandler(iProject, resource);
    }

    public static IProjectFeatureHandler getHandler(IProject iProject, Resource resource) {
        IProjectFeatureHandlerService iProjectFeatureHandlerService = (IProjectFeatureHandlerService)SingletonServiceDiscovery.INSTANCE.getService(IProjectFeatureHandlerService.class);
        IDecompositionModel iDecompositionModel = (IDecompositionModel)iProject.getService(IDecompositionModel.class);
        Project project = iDecompositionModel.getDecompositionProject();
        ResourceInfo resourceInfo = ((AbstractProject)iProject).getUriMapper().getResourceInfo(resource.getURI());
        if (resourceInfo == null) {
            throw new IllegalArgumentException("Given resource does not belong to the given project");
        }
        String string = resourceInfo.getNamespace();
        ProjectFeature projectFeature = DecompositionModelUtil.findProjectFeature((Project)project, (String)string);
        if (projectFeature == null) {
            return null;
        }
        return iProjectFeatureHandlerService.getHandler(projectFeature.getName());
    }

    public static IProjectFeatureDescriptor getResourceFeatureDescriptor(IProject iProject, Resource resource) {
        ILocalResourceDescriptor iLocalResourceDescriptor = ((AbstractProject)iProject).getResourceDescriptor(resource);
        IProjectFeatureDescriptor iProjectFeatureDescriptor = iLocalResourceDescriptor != null ? iLocalResourceDescriptor.getResourceFeatureDescriptor() : null;
        return iProjectFeatureDescriptor;
    }

    public static String getResourceName(IProject iProject, Resource resource) {
        ILocalResourceDescriptor iLocalResourceDescriptor = ((AbstractProject)iProject).getResourceDescriptor(resource);
        String string = iLocalResourceDescriptor != null ? iLocalResourceDescriptor.getResourceName() : null;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<IProject> getDirectlyUsingProjects(IProject iProject) {
        Set<IProject> set;
        HashSet<IProject> hashSet = null;
        for (IProject iProject2 : LocalProjectUtil.getProjects((IPrimaryProject)LocalProjectUtil.getPrimaryProject((IProject)iProject))) {
            IProjectUsageManager iProjectUsageManager;
            if (iProject2 == iProject || !(iProjectUsageManager = (IProjectUsageManager)iProject2.getService(IProjectUsageManager.class)).getUsedProjects().contains(iProject)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<IProject>();
            }
            hashSet.add(iProject2);
        }
        if (hashSet != null) {
            set = hashSet;
            return set;
        }
        set = Collections.emptySet();
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<IProject> getDirectlyUsedProjects(IProject iProject) {
        Set<IProject> set;
        HashSet<IProject> hashSet = null;
        IProjectUsageManager iProjectUsageManager = (IProjectUsageManager)iProject.getService(IProjectUsageManager.class);
        Collection collection = iProjectUsageManager.getProjectUsages();
        for (ProjectUsage projectUsage : collection) {
            IProject iProject2 = iProjectUsageManager.getProject((AbstractProjectUsage)projectUsage);
            if (hashSet == null) {
                hashSet = new HashSet<IProject>();
            }
            hashSet.add(iProject2);
        }
        if (hashSet != null) {
            set = hashSet;
            return set;
        }
        set = Collections.emptySet();
        return set;
    }

    public static void setUpdatingInCurrentThread(boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                updatingThreadCount.incrementAndGet();
                updatingInCurrentThread.set(Boolean.TRUE);
                break block3;
            }
            updatingThreadCount.decrementAndGet();
            updatingInCurrentThread.set(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isUpdatingInCurrentThread() {
        return updatingThreadCount.get() > 0 && Boolean.TRUE.equals(updatingInCurrentThread.get());
    }

    public static boolean calculateManuallyReachable(IProject iProject, IProject iProject2) {
        return b.a(iProject, iProject2, AttachmentSet.EMPTY_ATTACHMENT_SET, Collections.emptySet());
    }

    public static boolean calculateManuallyReachable(IProject iProject, IProject iProject2, IProject iProject3) {
        return b.a(iProject, iProject2, iProject3, AttachmentSet.EMPTY_ATTACHMENT_SET, Collections.emptySet());
    }

    public static boolean isApplicable(IProject iProject) {
        return iProject instanceof AbstractProject;
    }

    public static void registerAnticipatedUsage(IProjectUsageManager iProjectUsageManager, ProjectUsage projectUsage, IProject iProject) {
        if (iProjectUsageManager instanceof w) {
            w w2 = (w)iProjectUsageManager;
            w2.a(projectUsage, iProject);
        }
    }
}

