/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger LOGGER = Logger.getLogger(FileUtil.class);
    private static final String CREATE_FILE_RETRY_COUNT_SYSTEM_PROPERTY = "create.file.retry.count";
    private static final int FILE_CREATE_RETRY_COUNT = Integer.parseInt(System.getProperty("create.file.retry.count", "5"));
    private static int mCount;
    public static final int BUFFER_SIZE = 65536;

    static {
        LOGGER.info((Object)("File create retry count :" + FILE_CREATE_RETRY_COUNT));
    }

    public static void createDirectory(@Nonnull String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static boolean deleteDir(@Nonnull File file) {
        if (!file.exists()) {
            return true;
        }
        if (!FileUtil.makeEmptyDir(file)) {
            return false;
        }
        return file.delete();
    }

    public static boolean makeEmptyDir(@Nonnull File file) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                boolean bl;
                File file2 = new File(file, stringArray[n2]);
                boolean bl2 = bl = file2.isDirectory() ? FileUtil.deleteDir(file2) : file2.delete();
                if (!bl) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static void deleteTree(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file2 = fileArray[n2];
                FileUtil.deleteTree(file2);
                ++n2;
            }
        }
        file.delete();
    }

    public static synchronized File createTempDir(String string) {
        File file;
        String string2 = "java.io.tmpdir";
        File file2 = new File(System.getProperty(string2));
        do {
            file = new File(file2, String.valueOf(string) + mCount);
            ++mCount;
        } while (file.exists());
        file.mkdirs();
        return file;
    }

    public static List<File> listAllFiles(String string) {
        return FileUtil.listAllFiles(string, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> listAllFiles(String string, boolean bl) {
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            ArrayList<File> arrayList = new ArrayList<File>();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file2 = fileArray2[n3];
                    if (!file2.isHidden() || bl) {
                        List<File> list;
                        arrayList.add(file2);
                        if (file2.isDirectory() && (list = FileUtil.listAllFiles(file2.getAbsolutePath(), bl)) != null && list.size() != 0) {
                            arrayList.addAll(list);
                        }
                    }
                    ++n3;
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean unzip(String string, String string2) throws IOException {
        return FileUtil.unzip(string, string2, null);
    }

    /*
     * Exception decompiling
     */
    public static void unzip(InputStream var0, String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unzip(String string, String string2, String string3) throws IOException {
        string2 = String.valueOf(string2) + File.separator;
        File file = new File(string2);
        file.mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipFile zipFile = new ZipFile(string);){
            byte[] byArray = new byte[1024];
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                ZipEntry zipEntry = enumeration.nextElement();
                String string4 = zipEntry.getName();
                if (string3 != null && !string4.equals(string3)) continue;
                if (string4.lastIndexOf("/") != -1) {
                    serializable = new File(String.valueOf(string2) + string4.substring(0, string4.lastIndexOf("/")));
                    ((File)serializable).mkdirs();
                    if (string4.endsWith("/")) continue;
                }
                serializable = null;
                Object var12_15 = null;
                try {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    try {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string2) + string4);){
                            int n2;
                            while ((n2 = inputStream.read(byArray, 0, 1024)) > -1) {
                                fileOutputStream.write(byArray, 0, n2);
                            }
                        }
                        if (inputStream == null) continue;
                    }
                    catch (Throwable throwable3) {
                        if (serializable == null) {
                            serializable = throwable3;
                        } else if (serializable != throwable3) {
                            ((Throwable)serializable).addSuppressed(throwable3);
                        }
                        if (inputStream == null) throw serializable;
                        inputStream.close();
                        throw serializable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable4) {
                    if (serializable == null) {
                        serializable = throwable4;
                        throw serializable;
                    }
                    if (serializable == throwable4) throw serializable;
                    ((Throwable)serializable).addSuppressed(throwable4);
                    throw serializable;
                }
            }
            return true;
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    public static boolean zipAll(String string, String string2) throws IOException {
        return FileUtil.zipAll(string, string2, false);
    }

    public static boolean zipAll(String string, String string2, boolean bl) throws IOException {
        ZipOutputStream zipOutputStream;
        block10: {
            zipOutputStream = null;
            try {
                File file = new File(string2);
                FileUtil.createDirectory(file.getParent());
                zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
                if (bl) {
                    File file2 = new File(string);
                    FileUtil.zip(file2, "", zipOutputStream);
                    break block10;
                }
                File[] fileArray = new File(string).listFiles();
                int n2 = fileArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    File file3 = fileArray[n3];
                    FileUtil.zip(file3, "", zipOutputStream);
                    ++n3;
                }
            }
            catch (Throwable throwable) {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                throw throwable;
            }
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        return true;
    }

    public static boolean zipAll(File[] fileArray, String string) throws IOException {
        int n2;
        ZipOutputStream zipOutputStream = null;
        try {
            File file = new File(string);
            FileUtil.createDirectory(file.getParent());
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            File[] fileArray2 = fileArray;
            int n3 = fileArray.length;
            n2 = 0;
            while (n2 < n3) {
                File file2 = fileArray2[n2];
                if (FileUtil.zip(file2, "", zipOutputStream)) break block13;
            }
        }
        catch (Throwable throwable) {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            throw throwable;
        }
        {
            block13: {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                return false;
            }
            ++n2;
            continue;
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        return true;
    }

    public static boolean zip(String string, String string2) throws IOException {
        boolean bl;
        ZipOutputStream zipOutputStream = null;
        try {
            File file = new File(string2);
            FileUtil.createDirectory(file.getParent());
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
            bl = FileUtil.zip(new File(string), "", zipOutputStream);
        }
        catch (Throwable throwable) {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            throw throwable;
        }
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean zip(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            zipOutputStream.putNextEntry(new ZipEntry((String.valueOf(string) + file.getName()).replace('\\', '/')));
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                byte[] byArray = new byte[1024];
                while (true) {
                    int n2;
                    if ((n2 = fileInputStream.read(byArray)) <= 0) {
                        zipOutputStream.closeEntry();
                        return true;
                    }
                    zipOutputStream.write(byArray, 0, n2);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        String string2 = String.valueOf(string) + file.getName() + File.separator;
        File[] fileArray = file.listFiles();
        zipOutputStream.putNextEntry(new ZipEntry(string2.replace('\\', '/')));
        zipOutputStream.closeEntry();
        File[] fileArray2 = fileArray;
        int n3 = fileArray.length;
        int n4 = 0;
        while (n4 < n3) {
            File file2 = fileArray2[n4];
            if (!FileUtil.zip(file2, string2, zipOutputStream)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static void copy(String string, String string2, boolean bl) throws IOException {
        FileUtil.copy(new File(string), new File(string2), bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File file, File file2, boolean bl) throws IOException {
        File file3;
        Object object;
        String string2 = file.getPath();
        String string = file2.getPath();
        if (!file.exists()) {
            throw new IOException("FileCopy: no such source file: " + string2);
        }
        if (!file.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + string2);
        }
        if (!file.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + string2);
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (!file2.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + string);
            }
            if (!bl) {
                throw new IOException("FileCopy: existing file was not overwritten.");
            }
        } else {
            object = file2.getParent();
            if (object == null) {
                object = System.getProperty("user.dir");
            }
            if (!(file3 = new File((String)object)).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + (String)object);
            }
            if (file3.isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + (String)object);
            }
        }
        object = null;
        file3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    int n2;
                    byte[] byArray = new byte[4096];
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n2);
                    }
                }
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                if (fileInputStream == null) throw object;
                fileInputStream.close();
                throw object;
            }
            fileInputStream.close();
            return;
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
                throw object;
            }
            if (object == throwable) throw object;
            ((Throwable)object).addSuppressed(throwable);
            throw object;
        }
    }

    public static void copy(String string, String string2) throws IOException {
        FileUtil.copy(string, string2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyDirectory(File file, File file2) throws IOException {
        File[] fileArray;
        if (!file2.exists()) {
            file2.mkdir();
        }
        if ((fileArray = file.listFiles()) != null) {
            File[] fileArray2 = fileArray;
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File file3 = fileArray2[n3];
                String string = file3.getName();
                File file4 = new File(file2, string);
                if (file3.isDirectory()) {
                    FileUtil.copyDirectory(file3, file4);
                } else {
                    FileUtil.copy(file3.getAbsolutePath(), file4.getAbsolutePath());
                }
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[65536];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int copy(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[65536];
        int n3 = 0;
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static StringBuilder readText(InputStream inputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                StringBuilder stringBuilder;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                try {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder2.append(string);
                        stringBuilder2.append("\n");
                    }
                    bufferedReader.close();
                    stringBuilder = stringBuilder2;
                }
                catch (Throwable throwable2) {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    throw throwable2;
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                inputStream.close();
                return stringBuilder;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else {
                    if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            inputStream.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void compressZip(OutputStream outputStream, String string, Collection<String> collection, Collection<String> collection2) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            File file = new File(string);
            File[] fileArray = file.listFiles();
            int n2 = fileArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return;
                }
                File file2 = fileArray[n3];
                String string3 = file2.getAbsolutePath();
                String string2 = string3.substring(string.length() + 1);
                if (!(collection != null && !collection.contains(string2) || collection2 != null && collection2.contains(string2))) {
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                    Throwable throwable2 = null;
                    Object var15_18 = null;
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));){
                        int n4;
                        byte[] byArray = new byte[65536];
                        while ((n4 = ((InputStream)bufferedInputStream).read(byArray)) > 0) {
                            zipOutputStream.write(byArray, 0, n4);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                ++n3;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<String> extractZip(InputStream inputStream, String string, Collection<String> collection, Collection<String> collection2) throws IOException {
        ZipEntry zipEntry;
        HashSet<String> hashSet = new HashSet<String>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (collection != null && !collection.contains(zipEntry.getName()) || collection2 != null && collection2.contains(zipEntry.getName())) continue;
            if (zipEntry.isDirectory()) {
                new File(String.valueOf(string) + File.separator + zipEntry.getName()).mkdirs();
                continue;
            }
            String string2 = zipEntry.getName();
            long l2 = zipEntry.getCrc();
            hashSet.add(string2);
            FileUtil.copy(zipInputStream, string2, string, l2);
        }
        zipInputStream.close();
        return hashSet;
    }

    public static void copy(InputStream inputStream, String string, String string2, long l2) throws FileNotFoundException, IOException {
        File file = new File(string2, string);
        String string3 = file.getParent();
        if (string3 != null) {
            new File(string3).mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 65536);
            FileUtil.copy(bufferedInputStream, bufferedOutputStream, l2);
        }
        finally {
            FileUtil.closeQuietly(bufferedOutputStream);
            FileUtil.closeQuietly(fileOutputStream);
        }
    }

    public static FileOutputStream createFileOutputStreamWithRetry(File file) throws IOException {
        int n2 = FILE_CREATE_RETRY_COUNT;
        long l2 = 100L;
        while (true) {
            try {
                return new FileOutputStream(file);
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Failed to create FileOutputStream, retry left " + n2));
                LOGGER.error((Object)("Failed to create FileOutputStream waiting for " + l2 + " ms;" + iOException));
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {}
                l2 *= 2L;
                if (--n2 != 0) continue;
                throw iOException;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(File file, File file2, long l2) throws FileNotFoundException, IOException {
        String string = file2.getParent();
        if (string != null) {
            new File(string).mkdirs();
        }
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                block37: {
                    FileOutputStream fileOutputStream = FileUtil.createFileOutputStreamWithRetry(file2);
                    try {
                        block36: {
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 65536);
                            try {
                                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 65536);){
                                    FileUtil.copy(bufferedInputStream, bufferedOutputStream, l2);
                                }
                                if (bufferedOutputStream == null) break block36;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bufferedOutputStream == null) throw throwable;
                                bufferedOutputStream.close();
                                throw throwable;
                            }
                            bufferedOutputStream.close();
                        }
                        if (fileOutputStream == null) break block37;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fileOutputStream == null) throw throwable;
                        fileOutputStream.close();
                        throw throwable;
                    }
                    fileOutputStream.close();
                }
                if (fileInputStream == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, long l2) throws IOException {
        int n2;
        CRC32 cRC32 = null;
        if (l2 >= 0L) {
            cRC32 = new CRC32();
        }
        byte[] byArray = new byte[65536];
        while ((n2 = inputStream.read(byArray)) > 0) {
            if (cRC32 != null) {
                cRC32.update(byArray, 0, n2);
            }
            outputStream.write(byArray, 0, n2);
        }
        outputStream.flush();
        if (cRC32 != null && cRC32.getValue() != l2) {
            throw new IOException("CRC Check failed");
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void closeQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {}
    }
}

