/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.util;

import com.nomagic.ci.persistence.local.features.dependency.DependencyInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DependencyCrossReferencer
extends EcoreUtil.CrossReferencer {
    private static final long serialVersionUID = 1L;
    private Resource resource;
    private Set<DependencyInfo<?>> dependencies = new HashSet();
    private Set<EObject> roots = new HashSet<EObject>();
    private Set<EObject> visitedRoots = new HashSet<EObject>();
    private Object actualContainer;

    public DependencyCrossReferencer(Resource resource) {
        super((Collection)resource.getContents());
        this.resource = resource;
        this.roots = new HashSet<EObject>((Collection<EObject>)resource.getContents());
    }

    protected Object getActualContainer() {
        return this.actualContainer;
    }

    public Set<DependencyInfo<?>> findDependencies(IProgressMonitor iProgressMonitor) {
        this.crossReference();
        this.done();
        return this.dependencies;
    }

    protected void add(InternalEObject internalEObject, EReference eReference, EObject eObject) {
        DependencyInfo<EReference> dependencyInfo = new DependencyInfo<EReference>((EObject)internalEObject, eReference, eObject);
        this.dependencies.add(dependencyInfo);
    }

    protected boolean containment(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null && resource != this.resource) {
            EObject eObject2 = eObject.eContainer();
            EStructuralFeature eStructuralFeature = eObject.eContainingFeature();
            if (this.actualContainer instanceof EObject && ((EObject)this.actualContainer).eContents().contains((Object)eObject) && (eObject2 == null || !eObject2.eContents().contains((Object)eObject))) {
                System.err.println("CONTAINER BUG FOUND - containment reference that is not in sync with container reference: eObject.eContainer().eContents().contains(eObject) fails.");
                System.err.println("Actual container: " + this.actualContainer + " Contained object: " + eObject + " Reported container: " + eObject2);
                Thread.dumpStack();
                eObject2 = (EObject)this.actualContainer;
                for (EReference eReference : eObject2.eClass().getEAllContainments()) {
                    Object object = eObject2.eGet((EStructuralFeature)eReference);
                    if (eReference.isMany()) {
                        List list = (List)object;
                        if (!list.contains(eObject)) continue;
                        eStructuralFeature = eReference;
                        break;
                    }
                    if (object != eObject) continue;
                    eStructuralFeature = eReference;
                    break;
                }
            }
            if (this.isCrossReference(eStructuralFeature)) {
                EReference eReference;
                eReference = new DependencyInfo(eObject2, (EReference)eStructuralFeature, eObject);
                this.dependencies.add((DependencyInfo<?>)eReference);
            }
            return false;
        }
        return true;
    }

    protected void crossReference() {
        TreeIterator<Notifier> treeIterator = this.newContentsIterator();
        while (treeIterator.hasNext()) {
            this.actualContainer = this.getActualContainer(treeIterator);
            Object object = treeIterator.next();
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            if (this.roots.contains(eObject)) {
                if (this.visitedRoots.contains(eObject)) {
                    treeIterator.prune();
                    continue;
                }
                this.visitedRoots.add(eObject);
            }
            if (this.containment(eObject)) {
                this.handleCrossReference(eObject);
                continue;
            }
            treeIterator.prune();
        }
    }

    protected EContentsEList.FeatureIterator<EObject> getCrossReferences(EObject eObject) {
        EClass eClass = eObject.eClass();
        EClassImpl.FeatureSubsetSupplier featureSubsetSupplier = (EClassImpl.FeatureSubsetSupplier)eClass.getEAllStructuralFeatures();
        EStructuralFeature[] eStructuralFeatureArray = featureSubsetSupplier.features();
        if (eStructuralFeatureArray == null) {
            return (EContentsEList.FeatureIterator)ECrossReferenceEList.emptyContentsEList().iterator();
        }
        ArrayList<EStructuralFeature> arrayList = new ArrayList<EStructuralFeature>(eStructuralFeatureArray.length);
        int n2 = 0;
        while (n2 < eStructuralFeatureArray.length) {
            EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
            if (eStructuralFeature instanceof EReference && this.isCrossReference(eStructuralFeature)) {
                arrayList.add(eStructuralFeature);
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return (EContentsEList.FeatureIterator)ECrossReferenceEList.emptyContentsEList().iterator();
        }
        eStructuralFeatureArray = arrayList.toArray(new EStructuralFeature[arrayList.size()]);
        return (EContentsEList.FeatureIterator)new EContentsEList(eObject, eStructuralFeatureArray).iterator();
    }

    protected boolean isCrossReference(EStructuralFeature eStructuralFeature) {
        return !eStructuralFeature.isTransient();
    }

    protected boolean crossReference(EObject eObject, EReference eReference, EObject eObject2) {
        return eObject2.eResource() != this.resource;
    }

    protected TreeIterator<Notifier> newContentsIterator() {
        return new CrossReferenceTreeIterator(this.emfObjects);
    }

    private Object getActualContainer(TreeIterator<Notifier> treeIterator) {
        EcoreUtil.ContentTreeIterator contentTreeIterator;
        if (treeIterator instanceof EcoreUtil.ContentTreeIterator && (contentTreeIterator = (EcoreUtil.ContentTreeIterator)treeIterator).size() > 0 && contentTreeIterator.get(contentTreeIterator.size() - 1) instanceof IteratorWithContainer) {
            IteratorWithContainer iteratorWithContainer = (IteratorWithContainer)contentTreeIterator.get(contentTreeIterator.size() - 1);
            return iteratorWithContainer.getContainer();
        }
        return null;
    }

    private class CrossReferenceTreeIterator<E>
    extends EcoreUtil.ContentTreeIterator<E> {
        private static final long serialVersionUID = 3318827600718334642L;

        protected CrossReferenceTreeIterator(Collection<?> collection) {
            super(collection, true);
        }

        public Iterator<E> getChildren(Object object) {
            return new IteratorWithContainer(object, super.getChildren(object));
        }
    }

    private static class IteratorWithContainer<E>
    implements Iterator<E> {
        private Object container;
        private Iterator<E> delegate;

        IteratorWithContainer(Object object, Iterator<E> iterator) {
            this.container = object;
            this.delegate = iterator;
        }

        Object getContainer() {
            return this.container;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

