/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.resources;

import com.nomagic.ci.persistence.IProject;
import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.AbstractProject;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamContainer;
import com.nomagic.ci.persistence.local.spi.binary.IBinaryStreamStorage;
import com.nomagic.ci.persistence.local.spi.binary.IBinarySynchronizationService;
import com.nomagic.ci.persistence.local.spi.files.BinaryStreamContainer;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistenceProvider;
import com.nomagic.ci.persistence.local.spi.files.ReservedResourcePersistence;
import com.nomagic.ci.persistence.local.spi.resources.IProjectResourceFilter;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ResourcePersistenceHandler
implements IResourcePersistenceProvider,
IBinaryStreamStorage,
IBinarySynchronizationService {
    private static final Logger LOGGER = Logger.getLogger(ResourcePersistenceHandler.class);
    private final List<ResourcePersistenceBundle> list = new ArrayList<ResourcePersistenceBundle>();
    private final AbstractProject project;

    public ResourcePersistenceHandler(AbstractProject abstractProject) {
        this.project = abstractProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerResourcePersistence(ReservedResourcePersistence reservedResourcePersistence, IProjectResourceFilter iProjectResourceFilter, IResourceInfoEncoder iResourceInfoEncoder, IResourceInfoDecoder iResourceInfoDecoder) {
        if (reservedResourcePersistence == null) throw new NullPointerException();
        if (iResourceInfoEncoder == null) throw new NullPointerException();
        if (iResourceInfoDecoder == null) {
            throw new NullPointerException();
        }
        ResourcePersistenceBundle resourcePersistenceBundle = new ResourcePersistenceBundle();
        resourcePersistenceBundle.persistence = reservedResourcePersistence;
        resourcePersistenceBundle.filter = iProjectResourceFilter;
        resourcePersistenceBundle.encoder = iResourceInfoEncoder;
        resourcePersistenceBundle.decoder = iResourceInfoDecoder;
        resourcePersistenceBundle.binaries = new BinaryStreamContainer(this.project, reservedResourcePersistence, resourcePersistenceBundle);
        this.list.add(resourcePersistenceBundle);
        try {
            resourcePersistenceBundle.binaries.preloadIndex();
            return;
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateEncoderDecoder(ReservedResourcePersistence reservedResourcePersistence, IResourceInfoEncoder iResourceInfoEncoder, IResourceInfoDecoder iResourceInfoDecoder) {
        if (reservedResourcePersistence == null || iResourceInfoEncoder == null || iResourceInfoDecoder == null) {
            throw new NullPointerException();
        }
        ResourcePersistenceBundle resourcePersistenceBundle = this.findBundle(reservedResourcePersistence);
        if (resourcePersistenceBundle == null) {
            throw new IllegalArgumentException();
        }
        resourcePersistenceBundle.encoder = iResourceInfoEncoder;
        resourcePersistenceBundle.decoder = iResourceInfoDecoder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<ResourceInfo> getPersistedResources() {
        ArrayList<ResourceInfo> arrayList = new ArrayList<ResourceInfo>();
        for (ResourcePersistenceBundle resourcePersistenceBundle : this.list) {
            for (String string : resourcePersistenceBundle.persistence.getResources()) {
                ResourceInfo resourceInfo = resourcePersistenceBundle.decoder.getResourceInfo(string);
                if (resourceInfo == null) continue;
                arrayList.add(resourceInfo);
            }
        }
        return arrayList;
    }

    public IProject getProject() {
        return this.project;
    }

    public IResourcePersistence getPersistence(int n2) {
        return this.list.get((int)n2).persistence;
    }

    @Override
    public IResourcePersistence getPersistence(ResourceInfo resourceInfo) {
        ResourcePersistenceBundle resourcePersistenceBundle = this.findBundle(resourceInfo);
        this.debugGetPersistence(resourceInfo, resourcePersistenceBundle);
        ReservedResourcePersistence reservedResourcePersistence = resourcePersistenceBundle != null ? resourcePersistenceBundle.persistence : null;
        return reservedResourcePersistence;
    }

    private void debugGetPersistence(ResourceInfo resourceInfo, ResourcePersistenceBundle resourcePersistenceBundle) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Bundle for resource info ");
            stringBuilder.append(resourceInfo);
            stringBuilder.append(": ");
            stringBuilder.append(resourcePersistenceBundle);
            if (resourcePersistenceBundle != null) {
                stringBuilder.append(", persistence: ");
                stringBuilder.append(resourcePersistenceBundle.persistence);
            }
            LOGGER.debug((Object)stringBuilder.toString());
        }
    }

    @Override
    public IResourceInfoDecoder getResourceInfoDecoder(IResourcePersistence iResourcePersistence) {
        ResourcePersistenceBundle resourcePersistenceBundle = this.findBundle(iResourcePersistence);
        IResourceInfoDecoder iResourceInfoDecoder = resourcePersistenceBundle != null ? resourcePersistenceBundle.decoder : null;
        return iResourceInfoDecoder;
    }

    @Override
    public IResourceInfoEncoder getResourceInfoEncoder(IResourcePersistence iResourcePersistence) {
        ResourcePersistenceBundle resourcePersistenceBundle = this.findBundle(iResourcePersistence);
        IResourceInfoEncoder iResourceInfoEncoder = resourcePersistenceBundle != null ? resourcePersistenceBundle.encoder : null;
        return iResourceInfoEncoder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourcePersistenceBundle findBundle(ResourceInfo resourceInfo) {
        ResourcePersistenceBundle resourcePersistenceBundle = null;
        int n2 = this.list.size() - 1;
        while (n2 >= 0) {
            ResourcePersistenceBundle resourcePersistenceBundle2 = this.list.get(n2);
            if (resourcePersistenceBundle2.accepts(resourceInfo)) {
                resourcePersistenceBundle = resourcePersistenceBundle2;
                break;
            }
            --n2;
        }
        this.debugFindBundle(resourceInfo, resourcePersistenceBundle);
        return resourcePersistenceBundle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void debugFindBundle(ResourceInfo resourceInfo, ResourcePersistenceBundle resourcePersistenceBundle) {
        if (!LOGGER.isDebugEnabled()) return;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Searched resource bundle for ");
        stringBuilder.append(resourceInfo);
        stringBuilder.append(", found ");
        stringBuilder.append(resourcePersistenceBundle);
        stringBuilder.append(", all bundles: [");
        int n2 = this.list.size() - 1;
        while (n2 >= 0) {
            ResourcePersistenceBundle resourcePersistenceBundle2 = this.list.get(n2);
            stringBuilder.append(resourcePersistenceBundle2);
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            --n2;
        }
        stringBuilder.append("]");
        LOGGER.debug((Object)stringBuilder.toString());
    }

    private ResourcePersistenceBundle findBundle(IResourcePersistence iResourcePersistence) {
        for (ResourcePersistenceBundle resourcePersistenceBundle : this.list) {
            if (resourcePersistenceBundle.persistence != iResourcePersistence) continue;
            return resourcePersistenceBundle;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BinaryStreamContainer> getBinaryStreamContainers() {
        ArrayList<BinaryStreamContainer> arrayList = new ArrayList<BinaryStreamContainer>();
        for (ResourcePersistenceBundle resourcePersistenceBundle : this.list) {
            arrayList.add(resourcePersistenceBundle.binaries);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isClean() {
        return this.project.isReadOnly() || !this.project.isProjectAvailable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBinaryStreamContainer getContainerOf(String string) {
        int n2 = this.list.size() - 1;
        while (n2 >= 0) {
            ResourcePersistenceBundle resourcePersistenceBundle = this.list.get(n2);
            if (resourcePersistenceBundle.binaries.isStreamPresent(string)) {
                return resourcePersistenceBundle.binaries;
            }
            --n2;
        }
        return null;
    }

    @Override
    public IBinaryStreamContainer getContainerFor(ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            ResourcePersistenceBundle resourcePersistenceBundle = this.findBundle(resourceInfo);
            if (resourcePersistenceBundle != null) {
                return resourcePersistenceBundle.binaries;
            }
        }
        return null;
    }

    @Override
    public void beforeCommit(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            try {
                int n2 = 0;
                while (n2 < this.list.size()) {
                    BinaryStreamContainer binaryStreamContainer = this.list.get((int)n2).binaries;
                    binaryStreamContainer.beforeCommit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public void beforeUpdate(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            try {
                int n2 = 0;
                while (n2 < this.list.size()) {
                    BinaryStreamContainer binaryStreamContainer = this.list.get((int)n2).binaries;
                    binaryStreamContainer.beforeUpdate((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public void beforeUnload(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            try {
                int n2 = 0;
                while (n2 < this.list.size()) {
                    BinaryStreamContainer binaryStreamContainer = this.list.get((int)n2).binaries;
                    binaryStreamContainer.beforeRemove((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    @Override
    public void beforeRemove(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            try {
                int n2 = 0;
                while (n2 < this.list.size()) {
                    BinaryStreamContainer binaryStreamContainer = this.list.get((int)n2).binaries;
                    binaryStreamContainer.beforeRemove((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new PersistenceRuntimeException((Throwable)iOException);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            int n2 = 0;
            while (n2 < this.list.size()) {
                this.list.get((int)n2).persistence.update((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                ++n2;
            }
            this.preloadBinaryIndexes();
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            int n2 = 0;
            while (n2 < this.list.size()) {
                this.list.get((int)n2).persistence.commit((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                ++n2;
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 500 * this.list.size());
        try {
            int n2 = 0;
            while (n2 < this.list.size()) {
                this.list.get((int)n2).persistence.close((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
                ++n2;
            }
            return;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void preloadBinaryIndexes() throws PersistenceRuntimeException {
        try {
            int n2 = 0;
            while (n2 < this.list.size()) {
                BinaryStreamContainer binaryStreamContainer = this.list.get((int)n2).binaries;
                binaryStreamContainer.preloadIndex();
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new PersistenceRuntimeException((Throwable)iOException);
        }
    }

    private static class ResourcePersistenceBundle
    implements IProjectResourceFilter,
    IResourceInfoEncoder,
    IResourceInfoDecoder {
        ReservedResourcePersistence persistence;
        IProjectResourceFilter filter;
        IResourceInfoEncoder encoder;
        IResourceInfoDecoder decoder;
        BinaryStreamContainer binaries;

        private ResourcePersistenceBundle() {
        }

        @Override
        public boolean accepts(ResourceInfo resourceInfo) {
            return this.filter == null || this.filter.accepts(resourceInfo);
        }

        @Override
        public ResourceInfo getResourceInfo(String string) {
            return this.decoder.getResourceInfo(string);
        }

        @Override
        public String getStreamId(ResourceInfo resourceInfo) {
            return this.encoder.getStreamId(resourceInfo);
        }
    }
}

