/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.resources;

import com.nomagic.ci.persistence.local.spi.IResourceUriMapper;
import com.nomagic.ci.persistence.local.spi.URIQuery;
import com.nomagic.ci.persistence.local.spi.files.ProjectIDResource;
import com.nomagic.ci.persistence.local.spi.localproject.LocalProject;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class LocalURIMapper
implements IResourceUriMapper {
    private static final Logger LOGGER = Logger.getLogger(LocalURIMapper.class);
    private static final int CACHE_SIZE = 4000;
    private static final Map<URI, ResourceInfo> RCACHE = Collections.synchronizedMap(new LRUMap(4000));
    private static final MultiKeyMap UCACHE = MultiKeyMap.decorate((AbstractHashedMap)new LRUMap(4000));
    private static final String QRESOURCE = "resource";
    private static final String NAMESPACE_SEPARATOR = ".";
    private static final String USER_SEPARATOR = ",";
    private static final String ESCAPE = "|";
    private static final String NAMESPACE_SEPARATOR_ESCAPE = "|n";
    private static final String USER_SEPARATOR_ESCAPE = "|u";
    private static final String ESCAPE_ESCAPE = "|e";
    private LocalProject localProject;

    public LocalURIMapper(LocalProject localProject) {
        this.localProject = localProject;
    }

    @Override
    public ResourceInfo getResourceInfo(URI uRI) {
        ResourceInfo resourceInfo = null;
        if (LocalURIMapper.isLocalResourceURI(uRI)) {
            String string;
            String string2 = this.localProject.getProjectID();
            if (string2.equals(string = LocalURIMapper.parseLocalProjectID(uRI))) {
                resourceInfo = LocalURIMapper.extractResourceInfoCached(uRI);
            }
            this.debugGetLocalResourceInfo(uRI, resourceInfo, string2, string);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("URI " + uRI + " is not local"));
            }
        }
        return resourceInfo;
    }

    private void debugGetLocalResourceInfo(URI uRI, ResourceInfo resourceInfo, String string, String string2) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ResourceURI: ");
            stringBuilder.append(uRI);
            stringBuilder.append(", projectID: ");
            stringBuilder.append(string);
            stringBuilder.append(", parsedProjectID: ");
            stringBuilder.append(string2);
            stringBuilder.append(", resouceInfo: ");
            stringBuilder.append(resourceInfo);
            LOGGER.debug((Object)stringBuilder.toString());
        }
    }

    private static ResourceInfo extractResourceInfoCached(URI uRI) {
        ResourceInfo resourceInfo = RCACHE.get(uRI);
        if (resourceInfo == null) {
            resourceInfo = LocalURIMapper.extractResourceInfo(uRI);
            if (resourceInfo != null) {
                RCACHE.put(uRI, resourceInfo);
            }
        }
        return resourceInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResourceInfo extractResourceInfo(URI uRI) {
        int n2;
        URIQuery uRIQuery = URIQuery.parse(uRI);
        String string3 = uRIQuery.remove(QRESOURCE);
        if (string3 != null && string3.length() > 0 && (n2 = string3.lastIndexOf(NAMESPACE_SEPARATOR)) > 0 && n2 < string3.length() - 1) {
            String string2 = string3.substring(0, n2);
            String string = string3.substring(n2 + 1);
            if (!string.contains(USER_SEPARATOR)) {
                return new ResourceInfo(null, string2, LocalURIMapper.decode(string));
            }
            String[] stringArray = string.split(USER_SEPARATOR);
            if (stringArray[0].length() > 0 && stringArray[1].length() > 0) {
                return new ResourceInfo(LocalURIMapper.decode(stringArray[0]), string2, LocalURIMapper.decode(stringArray[1]));
            }
        }
        return null;
    }

    @Override
    public URI getResourceURI(String string, String string2) {
        LocalURIMapper.assureNotEmpty(string);
        LocalURIMapper.assureNotEmpty(string2);
        return LocalURIMapper.getResourceURI(this.localProject.getProjectID(), null, string, string2);
    }

    @Override
    public URI getPersonalResourceURI(String string, String string2, String string3) {
        LocalURIMapper.assureNotEmpty(string);
        LocalURIMapper.assureNotEmpty(string2);
        LocalURIMapper.assureNotEmpty(string3);
        return LocalURIMapper.getResourceURI(this.localProject.getProjectID(), string, string2, string3);
    }

    private static URI getResourceURI(String string, String string2, String string3, String string4) {
        URI uRI = (URI)UCACHE.get((Object)string, (Object)string2, (Object)string3, (Object)string4);
        if (uRI == null) {
            uRI = LocalURIMapper.createResourceURI(string, string2, string3, string4);
            UCACHE.put((Object)string, (Object)string2, (Object)string3, (Object)string4, (Object)uRI);
        }
        return uRI;
    }

    private static URI createResourceURI(String string, String string2, String string3, String string4) {
        String string5 = string2 != null ? LocalURIMapper.getPersonalResource(string2, string3, string4) : LocalURIMapper.getNonPersonalResource(string3, string4);
        String string6 = string5;
        URI uRI = URI.createURI((String)("local:/" + string));
        URIQuery uRIQuery = URIQuery.parse(uRI);
        uRIQuery.put(QRESOURCE, string6);
        URI uRI2 = uRI.appendQuery(uRIQuery.toAppendString()).appendFragment(null);
        return uRI2;
    }

    private static String getNonPersonalResource(String string, String string2) {
        String string3 = String.valueOf(string) + NAMESPACE_SEPARATOR + LocalURIMapper.encode(string2);
        return string3;
    }

    private static String getPersonalResource(String string, String string2, String string3) {
        String string4 = String.valueOf(string2) + NAMESPACE_SEPARATOR + LocalURIMapper.encode(string) + USER_SEPARATOR + LocalURIMapper.encode(string3);
        return string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void assureNotEmpty(String string) {
        if (string != null && string.length() != 0) {
            return;
        }
        throw new IllegalArgumentException("Parameter string is empty");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String encode(String string) {
        if (string == null) return string;
        if (string.isEmpty()) return string;
        String string2 = string.replace(ESCAPE, ESCAPE_ESCAPE);
        string2 = string2.replace(USER_SEPARATOR, USER_SEPARATOR_ESCAPE);
        return string2.replace(NAMESPACE_SEPARATOR, NAMESPACE_SEPARATOR_ESCAPE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String decode(String string) {
        if (string == null) return string;
        if (string.isEmpty()) return string;
        String string2 = string.replace(NAMESPACE_SEPARATOR_ESCAPE, NAMESPACE_SEPARATOR);
        string2 = string2.replace(USER_SEPARATOR_ESCAPE, USER_SEPARATOR);
        return string2.replace(ESCAPE_ESCAPE, ESCAPE);
    }

    public static ResourceInfo parseResourceInfo(URI uRI) {
        if (uRI != null) {
            String string = uRI.scheme();
            if ("local".equals(string)) {
                return LocalURIMapper.extractResourceInfoCached(uRI);
            }
        }
        return null;
    }

    public static String parseLocalProjectID(URI uRI) {
        block6: {
            if (uRI != null) {
                String string = uRI.scheme();
                if (!"local".equals(string) || uRI.segmentCount() <= 0) break block6;
                String string2 = uRI.segment(0);
                if (ProjectIDResource.isProjectID(string2)) {
                    return string2;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalResourceURI(URI uRI) {
        return uRI != null && uRI.fragment() == null && "local".equals(uRI.scheme());
    }
}

