/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.resources;

import com.nomagic.ci.persistence.local.spi.AbstractProjectURIHandler;
import com.nomagic.ci.persistence.local.spi.IProjectResourceURIHandler;
import com.nomagic.ci.persistence.local.spi.IResourceUriMapper;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoDecoder;
import com.nomagic.ci.persistence.local.spi.files.IResourceInfoEncoder;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.migration.InputStreamMigrator;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;

public abstract class AbstractResourcePersistenceURIHandler
extends AbstractProjectURIHandler
implements IProjectResourceURIHandler,
IResourceInfoEncoder,
IResourceInfoDecoder {
    private static final char USERID_SEPARATOR = ',';
    private static final char NAMESPACE_SEPARATOR = '.';
    private InputStreamMigrator migrator = new InputStreamMigrator();

    protected AbstractResourcePersistenceURIHandler(IResourceUriMapper iResourceUriMapper) {
        super(iResourceUriMapper);
    }

    protected abstract IResourcePersistence getResourcePersistence(URI var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(URI uRI, Map<?, ?> map) {
        IResourcePersistence iResourcePersistence = this.getResourcePersistence(uRI);
        String string = this.getStreamId(uRI);
        return iResourcePersistence != null && string != null && iResourcePersistence.isResourcePresent(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(URI uRI, Map<?, ?> map) throws IOException {
        IResourcePersistence iResourcePersistence = this.getResourcePersistence(uRI);
        String string = this.getStreamId(uRI);
        if (iResourcePersistence == null) return;
        if (string == null) return;
        iResourcePersistence.deleteResource(string);
    }

    public OutputStream createOutputStream(URI uRI, Map<?, ?> map) throws IOException {
        block5: {
            IResourcePersistence iResourcePersistence = this.getResourcePersistence(uRI);
            String string = this.getStreamId(uRI);
            if (iResourcePersistence == null || string == null) break block5;
            OutputStream outputStream = iResourcePersistence.getResourceAsOutputStream(string);
            if (outputStream != null) {
                return outputStream;
            }
        }
        throw new IllegalArgumentException("Output stream is not available for " + uRI);
    }

    public InputStream createInputStream(URI uRI, Map<?, ?> map) throws IOException {
        IResourcePersistence iResourcePersistence = this.getResourcePersistence(uRI);
        ResourceInfo resourceInfo = this.getResourceInfo(uRI);
        if (resourceInfo != null) {
            String string = this.getStreamId(resourceInfo);
            InputStream inputStream = iResourcePersistence.getResourceAsInputStream(string);
            if (inputStream != null) {
                return this.migrator.migrate(resourceInfo, inputStream);
            }
        }
        throw new IllegalArgumentException("Output stream is not available for " + uRI);
    }

    public final String getStreamId(URI uRI) {
        ResourceInfo resourceInfo = this.getResourceInfo(uRI);
        return this.getStreamId(resourceInfo);
    }

    @Override
    public String getStreamId(ResourceInfo resourceInfo) {
        if (resourceInfo.getUserId() != null) {
            return String.valueOf(resourceInfo.getNamespace()) + '.' + resourceInfo.getUserId() + ',' + resourceInfo.getResourceName();
        }
        return String.valueOf(resourceInfo.getNamespace()) + '.' + resourceInfo.getResourceName();
    }

    @Override
    public ResourceInfo getResourceInfo(String string) {
        block5: {
            if (string != null) {
                String string2;
                String string3;
                block6: {
                    int n2 = string.lastIndexOf(46);
                    if (n2 <= 0 || n2 >= string.length() - 1) break block5;
                    string3 = string.substring(0, n2);
                    string2 = string.substring(n2 + 1);
                    int n3 = string2.indexOf(44);
                    if (n3 <= 0 || n3 >= string2.length() - 1) break block6;
                    String string4 = string2.substring(0, n3);
                    String string5 = string2.substring(n3 + 1);
                    return new ResourceInfo(string4, string3, string5);
                }
                return new ResourceInfo(null, string3, string2);
            }
        }
        return null;
    }
}

