/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.query;

import com.nomagic.ci.persistence.local.query.IQueryParameters;
import com.nomagic.ci.persistence.local.spi.query.AbstractQuery;
import com.nomagic.ci.persistence.local.spi.query.IInternalQueryParams;
import com.nomagic.ci.persistence.local.spi.query.IQueryCache;
import com.nomagic.ci.persistence.local.spi.query.QueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class QueryCache
implements IQueryCache {
    private static final int MAX_QUERY_CACHE_SIZE = 1024;
    private final ConcurrentMap<EClass, Object> cacheByType = new ConcurrentHashMap<EClass, Object>();
    private final ConcurrentMap<EAttribute, ConcurrentMap<Object, Object>> cacheByAttr = new ConcurrentHashMap<EAttribute, ConcurrentMap<Object, Object>>();
    private final Map<Object, Object> cacheByQuery;
    private boolean cacheByQueryEnabled = true;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private static final long NOTIFY_PERIOD = 100L;

    public static QueryCache createEmptyQueryCache() {
        return new QueryCache(-1);
    }

    public QueryCache() {
        this(1024);
    }

    public QueryCache(int n2) {
        this.cacheByQuery = n2 == -1 ? Collections.emptyMap() : QueryHelper.createLinkedHashMapForCache(n2);
    }

    @Override
    public Object getQueryResults(IQueryParameters iQueryParameters, List<EObject> list, String[] stringArray) {
        Object object;
        this.r.lock();
        try {
            if (!this.cacheByQueryEnabled) {
                return null;
            }
            Object object2 = QueryHelper.createCacheByQueryKey(iQueryParameters, stringArray);
            object = this.cacheByQuery.get(object2);
            if (object instanceof List) {
                list.addAll(QueryCache.castToListOfEObject(object));
            } else if (object != null) {
                list.addAll(((CacheByQueryValue)object).getObjects());
            }
        }
        finally {
            this.r.unlock();
        }
        return object;
    }

    @Override
    public void putQueryResults(IQueryParameters iQueryParameters, List<EObject> list, String[] stringArray, int n2) {
        this.putQueryResults(iQueryParameters, list, stringArray, iQueryParameters.getOrderBy() != null, 0, n2);
    }

    @Override
    public void putQueryResults(IQueryParameters iQueryParameters, List<EObject> list, String[] stringArray, boolean bl, int n2, int n3) {
        this.w.lock();
        try {
            if (!this.cacheByQueryEnabled) {
                return;
            }
            this.cacheByQuery.put(QueryHelper.createCacheByQueryKey(((IInternalQueryParams)((Object)iQueryParameters)).getInternalParams(), stringArray), QueryCache.createCacheByQueryValue(list, bl, n2, n3));
        }
        finally {
            this.w.unlock();
        }
    }

    private static Object createCacheByQueryValue(List<EObject> list, boolean bl, int n2, int n3) {
        if (!bl && n2 == 0) {
            return list;
        }
        CacheByQueryValue cacheByQueryValue = new CacheByQueryValue(list, n3 != 0 && bl ? new AbstractQuery.QueryResult(AbstractQuery.QueryResult.Type.Sorted, n3) : AbstractQuery.QueryResult.Unsorted, n2);
        return cacheByQueryValue;
    }

    @Override
    public void invalidateCacheByQuery() {
        this.w.lock();
        try {
            if (!this.cacheByQueryEnabled) {
                return;
            }
            this.cacheByQuery.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void setCacheByQueryEnabled(boolean bl) {
        this.w.lock();
        try {
            if (this.cacheByQueryEnabled == bl) {
                return;
            }
            this.cacheByQueryEnabled = bl;
            this.cacheByQuery.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    @Override
    public void putObjectIntoCacheByType(EObject eObject) {
        EClass eClass = eObject.eClass();
        this.putObjectIntoCacheByType(eObject, eClass);
        this.invalidateCacheByQuery();
    }

    private void putObjectIntoCacheByType(EObject eObject, EClass eClass) {
        Object object = this.cacheByType.get(eClass);
        if (object == null) {
            object = eObject;
            Object object2 = this.cacheByType.putIfAbsent(eClass, object);
            if (object2 != null) {
                this.putObjectIntoCacheByType(eObject, eClass, object2);
            }
        } else {
            this.putObjectIntoCacheByType(eObject, eClass, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putObjectIntoCacheByType(EObject eObject, EClass eClass, Object object) {
        if (object instanceof Set) {
            Object object2 = object;
            synchronized (object2) {
                Set<EObject> set = QueryCache.castToSetOfEObject(object);
                set.add(eObject);
            }
        } else if (object != eObject) {
            HashSet<EObject> hashSet = new HashSet<EObject>();
            hashSet.add((EObject)object);
            hashSet.add(eObject);
            boolean bl = this.cacheByType.replace(eClass, object, hashSet);
            if (!bl) {
                this.putObjectIntoCacheByType(eObject, eClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObjectFromCacheByType(EObject eObject) {
        boolean bl = false;
        EClass eClass = eObject.eClass();
        Object v2 = this.cacheByType.get(eClass);
        if (v2 instanceof Set) {
            Set set = (Set)v2;
            Object v3 = v2;
            synchronized (v3) {
                bl = set.remove(eObject);
                if (set.size() == 1) {
                    EObject eObject2 = (EObject)set.iterator().next();
                    this.cacheByType.replace(eClass, eObject2);
                }
            }
        } else if (v2 == eObject && !(bl = this.cacheByType.remove(eClass, eObject))) {
            this.removeObjectFromCacheByType(eObject);
        }
        if (bl) {
            this.invalidateCacheByQuery();
        }
    }

    @Override
    public void getObjectsByType(EClass eClass, boolean bl, List<EObject> list) {
        this.getObjectsByType(eClass, bl, list, ALL_RESULTS_MATCHER);
    }

    @Override
    public void getObjectsByType(EClass eClass, boolean bl, List<EObject> list, IQueryCache.QueryResultsMatcher queryResultsMatcher) {
        if (bl) {
            this.fetchFromCacheByType(eClass, list, queryResultsMatcher);
        } else {
            for (Map.Entry entry : this.cacheByType.entrySet()) {
                EClass eClass2 = (EClass)entry.getKey();
                if (!eClass.isSuperTypeOf(eClass2)) continue;
                this.fetchFromCacheByType(eClass2, list, queryResultsMatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFromCacheByType(EClass eClass, List<EObject> list, IQueryCache.QueryResultsMatcher queryResultsMatcher) {
        EObject eObject;
        Object v2 = this.cacheByType.get(eClass);
        if (v2 instanceof Set) {
            ArrayList<EObject> arrayList;
            Object v3 = v2;
            synchronized (v3) {
                arrayList = new ArrayList<EObject>(QueryCache.castToSetOfEObject(v2));
            }
            QueryCache.addAllMatching(list, arrayList, queryResultsMatcher);
        } else if (v2 != null && queryResultsMatcher.matchesObject(eObject = (EObject)v2)) {
            List<EObject> list2 = list;
            synchronized (list2) {
                list.add(eObject);
                list.notifyAll();
            }
        }
    }

    private static List<EObject> castToListOfEObject(Object object) {
        return (List)object;
    }

    private static Set<EObject> castToSetOfEObject(Object object) {
        return (Set)object;
    }

    @Override
    public boolean hasEClassInCacheByType(EClass eClass) {
        return this.cacheByType.containsKey(eClass);
    }

    @Override
    public void invalidateCacheByType() {
        this.cacheByType.clear();
    }

    @Override
    public void putObjectIntoCacheByAttribute(EObject eObject, EAttribute eAttribute, Object object) {
        ConcurrentMap concurrentMap;
        ConcurrentMap<Object, Object> concurrentMap2 = (ConcurrentHashMap<Object, Object>)this.cacheByAttr.get(eAttribute);
        if (concurrentMap2 == null && (concurrentMap = (ConcurrentMap)this.cacheByAttr.putIfAbsent(eAttribute, concurrentMap2 = new ConcurrentHashMap<Object, Object>())) != null) {
            concurrentMap2 = concurrentMap;
        }
        this.putObjectIntoCacheByAttribute(eObject, object, concurrentMap2);
        this.invalidateCacheByQuery();
    }

    private void putObjectIntoCacheByAttribute(EObject eObject, Object object, ConcurrentMap<Object, Object> concurrentMap) {
        Object v2 = concurrentMap.get(object);
        if (v2 == null) {
            Object object2 = concurrentMap.putIfAbsent(object, eObject);
            if (object2 != null) {
                this.putObjectIntoCacheByAttribute(eObject, object, concurrentMap, object2);
            }
        } else {
            this.putObjectIntoCacheByAttribute(eObject, object, concurrentMap, v2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putObjectIntoCacheByAttribute(EObject eObject, Object object, ConcurrentMap<Object, Object> concurrentMap, Object object2) {
        if (object2 instanceof List) {
            Object object3 = object2;
            synchronized (object3) {
                List<EObject> list = QueryCache.castToListOfEObject(object2);
                if (!list.contains(eObject)) {
                    list.add(eObject);
                }
            }
        } else if (object2 != eObject) {
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            arrayList.add((EObject)object2);
            arrayList.add(eObject);
            boolean bl = concurrentMap.replace(object, object2, arrayList);
            if (!bl) {
                this.putObjectIntoCacheByAttribute(eObject, object, concurrentMap);
            }
        }
    }

    @Override
    public void removeObjectFromCacheByAttribute(EObject eObject, EAttribute eAttribute, Object object) {
        if (this.privateRemoveObjectFromCacheByAttribute(eObject, eAttribute, object)) {
            this.invalidateCacheByQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean privateRemoveObjectFromCacheByAttribute(EObject eObject, EAttribute eAttribute, Object object) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.cacheByAttr.get(eAttribute);
        if (concurrentMap == null) {
            return false;
        }
        Object v2 = concurrentMap.get(object);
        boolean bl = false;
        if (v2 instanceof List) {
            List list = (List)v2;
            Object v3 = v2;
            synchronized (v3) {
                bl = list.remove(eObject);
                if (list.size() == 1) {
                    EObject eObject2 = (EObject)list.get(0);
                    concurrentMap.replace(object, eObject2);
                }
            }
        } else if (v2 == eObject && !(bl = concurrentMap.remove(object, eObject))) {
            this.removeObjectFromCacheByAttribute(eObject, eAttribute, object);
        }
        return bl;
    }

    @Override
    public void updateCacheByAttribute(EObject eObject, EAttribute eAttribute, Object object, Object object2) {
        this.removeObjectFromCacheByAttribute(eObject, eAttribute, object);
        this.putObjectIntoCacheByAttribute(eObject, eAttribute, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectsByAttribute(EAttribute eAttribute, Object object) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.cacheByAttr.get(eAttribute);
        if (concurrentMap == null) {
            return null;
        }
        Object v2 = concurrentMap.get(object);
        if (v2 instanceof List) {
            Object v3 = v2;
            synchronized (v3) {
                return Collections.unmodifiableList(QueryCache.castToListOfEObject(v2));
            }
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getObjectsByAttributeByAdding(EAttribute eAttribute, Object object, List<EObject> list) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.cacheByAttr.get(eAttribute);
        if (concurrentMap == null) {
            return;
        }
        Object v2 = concurrentMap.get(object);
        if (v2 instanceof List) {
            Object v3 = v2;
            synchronized (v3) {
                list.addAll(QueryCache.castToListOfEObject(v2));
            }
        } else if (v2 != null) {
            list.add((EObject)v2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getObjectsByAttributeByRetaining(EAttribute eAttribute, Object object, List<EObject> list) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.cacheByAttr.get(eAttribute);
        if (concurrentMap == null) {
            return;
        }
        Object v2 = concurrentMap.get(object);
        if (v2 instanceof List) {
            Object v3 = v2;
            synchronized (v3) {
                list.retainAll(QueryCache.castToListOfEObject(v2));
            }
        } else if (v2 != null) {
            if (list.contains(v2)) {
                list.clear();
                list.add((EObject)v2);
            } else {
                list.clear();
            }
        }
    }

    @Override
    public void getAllObjects(Set<Object> set) {
        for (Map.Entry entry : this.cacheByAttr.entrySet()) {
            set.addAll(((ConcurrentMap)entry.getValue()).values());
        }
    }

    @Override
    public boolean hasEAttributeInCacheByAttr(EAttribute eAttribute) {
        return this.cacheByAttr.containsKey(eAttribute);
    }

    @Override
    public Collection<Object> getAllRegisteredValuesByAttribute(EAttribute eAttribute) {
        ConcurrentMap concurrentMap = (ConcurrentMap)this.cacheByAttr.get(eAttribute);
        if (concurrentMap == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(concurrentMap.keySet());
    }

    @Override
    public void invalidateCacheUniqueByAttribute() {
        this.cacheByAttr.clear();
    }

    @Override
    public void invalidateAll() {
        this.invalidateCacheByQuery();
        this.invalidateCacheByType();
        this.invalidateCacheUniqueByAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAllMatching(List<EObject> list, List<EObject> list2, IQueryCache.QueryResultsMatcher queryResultsMatcher) {
        long l2 = System.currentTimeMillis();
        boolean bl = true;
        for (Object object : list2) {
            if (!queryResultsMatcher.matchesObject((EObject)object)) continue;
            List<EObject> list3 = list;
            synchronized (list3) {
                list.add((EObject)object);
                long l3 = System.currentTimeMillis();
                if (list.size() == 1 || l3 - l2 > 100L) {
                    list.notify();
                    bl = true;
                    l2 = l3;
                } else {
                    bl = false;
                }
            }
        }
        if (!bl) {
            Object object;
            object = list;
            synchronized (object) {
                list.notify();
            }
        }
    }

    public static class CacheByQueryValue {
        private final List<EObject> list;
        private final AbstractQuery.QueryResult sorted;
        private final int alreadySorted;

        public CacheByQueryValue(List<EObject> list, AbstractQuery.QueryResult queryResult, int n2) {
            this.list = list;
            this.sorted = queryResult;
            this.alreadySorted = n2;
        }

        public List<EObject> getObjects() {
            return this.list;
        }

        public AbstractQuery.QueryResult getSorted() {
            return this.sorted;
        }

        public int getAlreadySorted() {
            return this.alreadySorted;
        }
    }
}

