/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.query;

import com.nomagic.ci.persistence.local.query.CloseableIterator;
import com.nomagic.ci.persistence.local.query.IQueryParameters;
import com.nomagic.ci.persistence.local.query.IQueryResultComparator;
import com.nomagic.ci.persistence.local.spi.query.CancelQueryException;
import com.nomagic.ci.persistence.local.spi.query.IQueryCache;
import com.nomagic.ci.persistence.local.spi.query.QueryResultComparatorWithMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class List2CloseableIterator<E>
implements CloseableIterator<E> {
    private boolean closed;
    private IQueryResultComparator comparator;
    private List<E> list;
    private int index;
    private int listFirst;
    private int alreadySorted;
    private boolean firstSet = true;
    private IQueryCache queryCache;
    private IQueryParameters parameters;
    private String[] configurableFilterRuleValues;
    private static final int N = 2000;
    private static final String[] EMTPTY_STRINGS = new String[0];
    private boolean[] finished;
    private int lastSize;
    private IProgressMonitor monitor;

    public List2CloseableIterator(List<E> list) {
        this(list, new boolean[]{true}, (IProgressMonitor)new NullProgressMonitor());
    }

    public List2CloseableIterator(List<E> list, boolean[] blArray, IProgressMonitor iProgressMonitor) {
        this(list, null, blArray, iProgressMonitor);
    }

    public List2CloseableIterator(List<E> list, IQueryResultComparator iQueryResultComparator) {
        this(list, iQueryResultComparator, new boolean[]{true}, (IProgressMonitor)new NullProgressMonitor());
    }

    public List2CloseableIterator(List<E> list, IQueryResultComparator iQueryResultComparator, boolean[] blArray, IProgressMonitor iProgressMonitor) {
        this(list, iQueryResultComparator, 0, null, null, EMTPTY_STRINGS, blArray, iProgressMonitor);
    }

    public List2CloseableIterator(List<E> list, IQueryResultComparator iQueryResultComparator, int n2, IQueryCache iQueryCache, IQueryParameters iQueryParameters, String[] stringArray, IProgressMonitor iProgressMonitor) {
        this(list, iQueryResultComparator, n2, iQueryCache, iQueryParameters, stringArray, new boolean[]{true}, iProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List2CloseableIterator(List<E> list, IQueryResultComparator iQueryResultComparator, int n2, IQueryCache iQueryCache, IQueryParameters iQueryParameters, String[] stringArray, boolean[] blArray, IProgressMonitor iProgressMonitor) {
        this.finished = blArray;
        this.monitor = iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
        this.comparator = iQueryResultComparator == null ? null : new QueryResultComparatorWithMonitor(iQueryResultComparator, iProgressMonitor);
        this.alreadySorted = n2;
        this.queryCache = iQueryCache;
        this.parameters = iQueryParameters;
        this.configurableFilterRuleValues = stringArray;
        if (blArray[0] && (list == null || list.isEmpty())) {
            this.closed = true;
            return;
        }
        if (this.comparator == null) {
            this.list = list;
            return;
        }
        this.list = new ArrayList<E>(list);
        this.listFirst = 0;
        try {
            this.refill(this.list);
            return;
        }
        catch (CancelQueryException cancelQueryException) {
            this.closed = true;
        }
    }

    private void refill(List<E> list) {
        int n2;
        block5: {
            n2 = this.listFirst + 2000;
            if (this.listFirst >= this.alreadySorted) {
                block4: {
                    List2CloseableIterator.quickfindFirstK(list, this.listFirst, list.size() - 1, 2000, this.comparator);
                    List<Object> list2 = list.subList(this.listFirst, Math.min(list.size(), n2));
                    list2.sort(this.comparator);
                    if (n2 >= list.size()) break block4;
                    this.putIntoQueryCache(false, n2, this.comparator.getCacheKey());
                    break block5;
                }
                this.putIntoQueryCache(true, 0, this.comparator.getCacheKey());
            } else {
                List<E> list3 = list.subList(this.listFirst, Math.min(list.size(), n2));
            }
        }
        this.listFirst = n2;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        if (this.comparator == null) {
            if (this.finished[0]) {
                return this.list != null && this.list.size() > this.index;
            }
            if (this.index >= this.lastSize) {
                do {
                    List<E> list;
                    try {
                        list = this.list;
                        synchronized (list) {
                            this.lastSize = this.list.size();
                            if (this.lastSize > this.index) {
                                break;
                            }
                            this.list.wait(this.firstSet ? 5 : 200);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        list = this.list;
                        synchronized (list) {
                            this.lastSize = this.list.size();
                            if (this.lastSize > this.index) {
                                break;
                            }
                        }
                    }
                } while (!this.finished[0] && !this.monitor.isCanceled());
                this.firstSet = false;
                if (this.finished[0] && this.index <= this.lastSize) {
                    this.lastSize = this.list.size();
                }
            }
            return this.list != null && this.lastSize > this.index;
        }
        if (this.list.size() > this.index) {
            return true;
        }
        if (this.listFirst >= this.list.size()) {
            this.putIntoQueryCache(true, 0, this.comparator.getCacheKey());
            return false;
        }
        try {
            this.refill(this.list);
            if (this.list.size() > this.index) {
                return true;
            }
        }
        catch (CancelQueryException cancelQueryException) {
            this.close();
            return false;
        }
        {
            this.putIntoQueryCache(true, 0, this.comparator.getCacheKey());
            return false;
        }
    }

    private void putIntoQueryCache(boolean bl, int n2, int n3) {
        if (this.queryCache != null) {
            this.queryCache.putQueryResults(this.parameters, this.list, this.configurableFilterRuleValues, bl, n2, n3);
        }
    }

    public List<E> getList() {
        return this.list;
    }

    public int getAlreadySorted() {
        int n2 = this.alreadySorted > this.listFirst ? this.alreadySorted : this.listFirst;
        return n2;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public E next() {
        return this.list.get(this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <E> void quickfindFirstK(List<E> list, int n2, int n3, int n4, Comparator<? super E> comparator) {
        if (n4 >= Math.abs(n3 - n2) + 1) {
            return;
        }
        n4 += n2;
        while (n3 > n2) {
            int n5 = List2CloseableIterator.quickselectPartition(list, n2, n3, comparator);
            if (n5 > n4) {
                n3 = n5 - 1;
                continue;
            }
            if (n5 >= n4) break;
            n2 = n5 + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <E> int quickselectPartition(List<E> list, int n2, int n3, Comparator<? super E> comparator) {
        int n4 = n2;
        int n5 = n3 + 1;
        E e2 = list.get(n2);
        while (true) {
            if (comparator.compare(list.get(++n4), e2) < 0) {
                if (n4 != n3) {
                    continue;
                }
            }
            while (comparator.compare(e2, list.get(--n5)) < 0) {
                if (n5 == n2) break;
            }
            if (n4 >= n5) {
                Collections.swap(list, n2, n5);
                return n5;
            }
            Collections.swap(list, n4, n5);
        }
    }
}

