/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.query;

import com.nomagic.ci.persistence.local.internal.j.s;
import com.nomagic.ci.persistence.local.internal.j.t;
import com.nomagic.ci.persistence.local.query.IQueryFilter;
import com.nomagic.ci.persistence.local.query.IQueryInRefRule;
import com.nomagic.ci.persistence.local.query.IQueryOutRefRule;
import com.nomagic.ci.persistence.local.query.IQueryParameters;
import com.nomagic.ci.persistence.local.query.IQueryRule;
import com.nomagic.ci.persistence.local.spi.query.QueryHelper;
import com.nomagic.ci.persistence.local.spi.query.QueryScopeFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CIQueryCondition {
    private final Set<EClass> types;
    private final boolean onlyThisType;
    private List<IQueryInRefRule> inFilterRules;
    private List<IQueryRule> outFilterRules;
    private final List<EObject> elementScopes;
    private final boolean checkAlternative;
    private final boolean checkTypes;
    private final boolean checkScopes;
    private final t scopeFinder;
    private static final CheckHasRef CHECK_HAS_REF_WITHOUT_CACHE = new CheckHasRef(){

        @Override
        public boolean check(EClass eClass, EReference eReference) {
            return eClass.getEAllReferences().contains((Object)eReference);
        }
    };
    private static final CheckHasRef CHECK_HAS_REF_WITH_CACHE = new CheckHasRef(){
        private final ThreadLocal<Map<EClass, Boolean>> cache = new ThreadLocal();

        @Override
        public boolean check(EClass eClass, EReference eReference) {
            Map<EClass, Boolean> map = this.cache.get();
            Boolean bl = map.get(eClass);
            if (bl == null) {
                bl = eClass.getEAllReferences().contains((Object)eReference);
                map.put(eClass, bl);
            }
            return bl;
        }

        @Override
        public void clear() {
            Map<EClass, Boolean> map = this.cache.get();
            map.clear();
        }

        @Override
        public void setCache(Map<EClass, Boolean> map) {
            this.cache.set(map);
        }

        @Override
        public void dispose() {
            this.cache.remove();
        }
    };

    public CIQueryCondition(List<IQueryRule> list) {
        this.presetQueryFilterRules(list);
        this.checkAlternative = false;
        this.elementScopes = null;
        this.onlyThisType = false;
        this.types = null;
        this.checkTypes = false;
        this.checkScopes = false;
        this.scopeFinder = null;
    }

    public CIQueryCondition(IQueryParameters iQueryParameters) {
        this(iQueryParameters, false);
    }

    public CIQueryCondition(IQueryParameters iQueryParameters, boolean bl) {
        this.types = iQueryParameters.getEClassTypes();
        this.onlyThisType = iQueryParameters.isOnlyThisType();
        this.elementScopes = iQueryParameters.getRootObjects();
        this.checkAlternative = bl;
        this.presetQueryFilterRules(iQueryParameters.getRules());
        this.checkTypes = this.types != null && !this.types.isEmpty();
        this.checkScopes = this.elementScopes != null && !this.elementScopes.isEmpty();
        this.scopeFinder = iQueryParameters.getScopeFinder() == null ? new QueryScopeFinder() : iQueryParameters.getScopeFinder();
    }

    private void presetQueryFilterRules(List<IQueryRule> list) {
        if (list != null) {
            for (IQueryRule iQueryRule : list) {
                if (iQueryRule.getRuleType() == IQueryRule.RuleType.OUT) {
                    if (this.outFilterRules == null) {
                        this.outFilterRules = new ArrayList<IQueryRule>();
                    }
                    this.outFilterRules.add(iQueryRule);
                    continue;
                }
                if (this.inFilterRules == null) {
                    this.inFilterRules = new ArrayList<IQueryInRefRule>();
                }
                this.inFilterRules.add((IQueryInRefRule)iQueryRule);
            }
        }
    }

    public boolean checkIsSatisfied(EObject eObject, String[] stringArray) {
        return this.checkIsSatisfied(eObject, true, stringArray);
    }

    public boolean checkIsSatisfied(EObject eObject, boolean bl, String[] stringArray) {
        return this.checkIsOfType(eObject) && this.checkIsSatisfiedWithoutTypeCheck(eObject, bl, stringArray);
    }

    public boolean checkIsSatisfiedWithoutTypeCheck(EObject eObject, boolean bl, String[] stringArray) {
        return this.checkIsUnderElementScope(eObject) && (!bl || this.passesFilters(eObject, stringArray));
    }

    private boolean checkIsOfType(EObject eObject) {
        if (this.checkTypes) {
            boolean bl = false;
            for (EClass eClass : this.types) {
                if (eObject.eClass() != eClass && (this.onlyThisType || !eObject.eClass().getEAllSuperTypes().contains((Object)eClass))) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return true;
    }

    private boolean checkIsUnderElementScope(EObject eObject) {
        if (this.checkScopes) {
            return this.scopeFinder.isElementUnderScope(eObject, this.elementScopes);
        }
        return true;
    }

    public boolean passesFilters(EObject eObject, String[] stringArray) {
        List<EObject> list;
        if (this.inFilterRules == null || this.inFilterRules.isEmpty()) {
            list = null;
        } else {
            list = this.fetchObjectsByRefChainIn(eObject);
            if (list.isEmpty()) {
                return false;
            }
        }
        if (this.outFilterRules == null || this.outFilterRules.isEmpty()) {
            return true;
        }
        if (list == null) {
            list = new ArrayList<EObject>();
            list.add(eObject);
        }
        this.fetchObjectsByRefChainOut(list, stringArray);
        return !list.isEmpty();
    }

    public void checkReferenceChainOut(List<EObject> list, String[] stringArray) {
        if (this.outFilterRules == null || this.outFilterRules.isEmpty()) {
            return;
        }
        this.fetchObjectsByRefChainOut(list, stringArray);
    }

    private void fetchObjectsByRefChainOut(List<EObject> list, String[] stringArray) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>(list);
        list.clear();
        ArrayList<EObject> arrayList2 = new ArrayList<EObject>();
        boolean bl = true;
        int n2 = 0;
        int n3 = arrayList.size();
        while (n2 < n3) {
            EObject eObject = (EObject)arrayList.get(n2);
            boolean bl2 = true;
            arrayList2.clear();
            for (IQueryRule iQueryRule : this.outFilterRules) {
                if (((s)((Object)iQueryRule)).a(eObject, arrayList2, this, stringArray, bl)) continue;
                bl2 = false;
                break;
            }
            bl = false;
            if (bl2) {
                list.add(eObject);
            }
            ++n2;
        }
    }

    public boolean checkFilterRuleOut(List<EObject> list, EObject eObject, IQueryOutRefRule iQueryOutRefRule, String[] stringArray) {
        boolean bl = true;
        for (EObject eObject2 : list) {
            bl = this.passesAttrFilterRules(eObject2, iQueryOutRefRule, stringArray);
            boolean bl2 = bl = bl ? this.passesValueTypes(eObject2, iQueryOutRefRule) : false;
            if (!bl) continue;
            return true;
        }
        return bl;
    }

    public boolean checkFilterRuleOutWithoutValueTypes(List<EObject> list, EObject eObject, IQueryOutRefRule iQueryOutRefRule, String[] stringArray) {
        boolean bl = true;
        for (EObject eObject2 : list) {
            bl = this.passesAttrFilterRules(eObject2, iQueryOutRefRule, stringArray);
            if (!bl) continue;
            return true;
        }
        return bl;
    }

    public void checkReferenceChain(List<EObject> list, EObject eObject, IQueryOutRefRule iQueryOutRefRule) {
        List<EReference> list2 = iQueryOutRefRule.getRefChain();
        this.checkReferenceChain(list, list2);
    }

    private boolean passesValueTypes(EObject eObject, IQueryOutRefRule iQueryOutRefRule) {
        boolean bl = true;
        Set<EClass> set = iQueryOutRefRule.getValueTypes();
        if (set != null && !set.isEmpty()) {
            IQueryOutRefRule.ValueTypeCheckType valueTypeCheckType = iQueryOutRefRule.getValueTypeCheckType();
            bl = false;
            EClass eClass = eObject.eClass();
            for (EClass eClass2 : set) {
                switch (valueTypeCheckType) {
                    case CHECK_EXACT: {
                        bl = eClass2 == eClass;
                        break;
                    }
                    case CHECK_DERIVED: {
                        bl = eClass2.isSuperTypeOf(eClass);
                    }
                }
                if (bl) break;
            }
        }
        return bl;
    }

    public List<EObject> fetchObjectsByRefChainIn(EObject eObject) {
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        if (this.inFilterRules != null) {
            for (IQueryInRefRule iQueryInRefRule : this.inFilterRules) {
                List<EReference> list = iQueryInRefRule.getRefChain();
                if (list == null || list.isEmpty()) continue;
                arrayList.clear();
                arrayList.add(eObject);
                this.checkReferenceChain(arrayList, list);
                if (arrayList.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            arrayList.add(eObject);
        }
        return arrayList;
    }

    private void checkReferenceChain(List<EObject> list, List<EReference> list2) {
        int n2 = list2.size();
        if (n2 > 0) {
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            if (list.size() > 3) {
                CHECK_HAS_REF_WITH_CACHE.setCache(new HashMap<EClass, Boolean>());
                this.checkReferenceChainPrivate(list, list2, n2, arrayList, CHECK_HAS_REF_WITH_CACHE);
                CHECK_HAS_REF_WITH_CACHE.dispose();
            } else {
                this.checkReferenceChainPrivate(list, list2, n2, arrayList, CHECK_HAS_REF_WITHOUT_CACHE);
            }
        }
    }

    private void checkReferenceChainPrivate(List<EObject> list, List<EReference> list2, int n2, List<EObject> list3, CheckHasRef checkHasRef) {
        int n3 = 0;
        while (n3 < n2) {
            EReference eReference = list2.get(n3);
            list3.clear();
            checkHasRef.clear();
            int n4 = 0;
            int n5 = list.size();
            while (n4 < n5) {
                EObject eObject = list.get(n4);
                EClass eClass = eObject.eClass();
                if (checkHasRef.check(eClass, eReference)) {
                    this.checkRefIsSet(list3, eReference, eObject);
                }
                ++n4;
            }
            list.clear();
            list.addAll(list3);
            ++n3;
        }
    }

    private void checkRefIsSet(List<EObject> list, EReference eReference, EObject eObject) {
        if (eObject.eIsSet((EStructuralFeature)eReference)) {
            Object object = eObject.eGet((EStructuralFeature)eReference);
            if (object instanceof List) {
                List list2 = (List)object;
                int n2 = 0;
                int n3 = list2.size();
                while (n2 < n3) {
                    list.add((EObject)list2.get(n2));
                    ++n2;
                }
            } else if (object != null) {
                list.add((EObject)object);
            }
        }
    }

    public boolean passesAttrFilterRules(EObject eObject, IQueryOutRefRule iQueryOutRefRule, String[] stringArray) {
        Set<IQueryFilter> set;
        boolean bl = true;
        if (this.checkAlternative && (set = iQueryOutRefRule.getAlternativeResultValidator()) != null) {
            return set.isValid(eObject);
        }
        set = iQueryOutRefRule.getFilters();
        if (set != null && !set.isEmpty()) {
            bl = false;
            for (IQueryFilter iQueryFilter : set) {
                EAttribute eAttribute;
                Object object;
                bl = this.isValueValid(iQueryFilter, object = QueryHelper.findEAttributeValue(eObject, eAttribute = iQueryFilter.getEAttribute(), null, false), stringArray);
                if (bl && iQueryOutRefRule.getFilterValidityType() == IQueryOutRefRule.FilterValidityType.AT_LEAST_ONE || !bl && iQueryOutRefRule.getFilterValidityType() == IQueryOutRefRule.FilterValidityType.ALL) break;
            }
        }
        return bl;
    }

    private boolean isValueValid(IQueryFilter iQueryFilter, Object object, String[] stringArray) {
        boolean bl = false;
        if (object != null) {
            if (object instanceof List) {
                for (Object e2 : (List)object) {
                    bl = iQueryFilter.matches(e2.toString(), stringArray);
                    if (!bl) {
                        continue;
                    }
                    break;
                }
            } else {
                bl = iQueryFilter.matches(object.toString(), stringArray);
            }
        }
        return bl;
    }

    public List<IQueryInRefRule> getInFilterRules() {
        return this.inFilterRules;
    }

    public List<IQueryRule> getOutFilterRules() {
        return this.outFilterRules;
    }

    private static abstract class CheckHasRef {
        private CheckHasRef() {
        }

        public void setCache(Map<EClass, Boolean> map) {
        }

        public abstract boolean check(EClass var1, EReference var2);

        public void clear() {
        }

        public void dispose() {
        }
    }
}

