/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.query;

import com.nomagic.ci.persistence.local.query.IQuery;
import com.nomagic.ci.persistence.local.query.IQueryFilter;
import com.nomagic.ci.persistence.local.query.IQueryInRefRule;
import com.nomagic.ci.persistence.local.query.IQueryOutRefRule;
import com.nomagic.ci.persistence.local.query.IQueryOutRefUnionRule;
import com.nomagic.ci.persistence.local.query.IQueryParameters;
import com.nomagic.ci.persistence.local.query.IQueryRefRule;
import com.nomagic.ci.persistence.local.query.IQueryRule;
import com.nomagic.ci.persistence.local.spi.query.CIQueryCondition;
import com.nomagic.ci.persistence.local.spi.query.CancelQueryException;
import com.nomagic.ci.persistence.local.spi.query.IQueryCache;
import com.nomagic.ci.persistence.local.spi.query.IQueryWithParameters;
import com.nomagic.ci.persistence.local.spi.query.QueryCache;
import com.nomagic.ci.persistence.local.spi.query.QueryHelper;
import com.nomagic.ci.persistence.local.spi.query.QueryScopeFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class AbstractQuery
implements IQuery<EObject>,
IQueryWithParameters {
    private static final String[] EMTPTY_STRINGS = new String[0];
    protected final IQueryParameters parameters;
    protected final IQueryCache queryCache;
    protected int alreadySorted;

    protected AbstractQuery(IQueryParameters iQueryParameters, IQueryCache iQueryCache) {
        this.parameters = iQueryParameters.toFinal();
        this.queryCache = iQueryCache;
    }

    @Override
    public IQueryParameters getParameters() {
        return this.parameters.toFinal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected QueryResult getLocalCacheResults(IQueryParameters iQueryParameters, List<EObject> list, boolean bl) {
        QueryType queryType = this.determineQueryType(iQueryParameters, bl);
        switch (queryType) {
            case ByType: {
                return this.fetchResultsByTypeOnly(iQueryParameters, list) ? QueryResult.Unsorted : QueryResult.Failed;
            }
            case ByAttribute: {
                return this.fetchResultsByAttributeOnly(iQueryParameters, list, bl) ? QueryResult.Unsorted : QueryResult.Failed;
            }
            case Complex: {
                Object object = this.queryCache.getQueryResults(iQueryParameters, list, this.getConfigurableFilterRuleValues());
                if (!(object instanceof QueryCache.CacheByQueryValue)) return QueryResult.Failed;
                QueryCache.CacheByQueryValue cacheByQueryValue = (QueryCache.CacheByQueryValue)object;
                this.alreadySorted = cacheByQueryValue.getAlreadySorted();
                return cacheByQueryValue.getSorted();
            }
        }
        return QueryResult.Failed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected QueryType determineQueryType(IQueryParameters iQueryParameters, boolean bl) {
        Object object;
        Set<EClass> set = iQueryParameters.getEClassTypes();
        if (set == null) {
            return QueryType.Empty;
        }
        List<IQueryRule> list = iQueryParameters.getRules();
        if (list == null || list.isEmpty()) {
            if (set.size() < 3) {
                return QueryType.ByType;
            }
            return QueryType.Complex;
        }
        if (list.size() != 1) {
            return QueryType.Complex;
        }
        IQueryRule iQueryRule = list.get(0);
        if (AbstractQuery.isReferenceChainPresent(iQueryRule)) {
            return QueryType.Complex;
        }
        if (iQueryRule.getRuleType() == IQueryRule.RuleType.IN || iQueryRule instanceof IQueryOutRefUnionRule) {
            return QueryType.Complex;
        }
        IQueryOutRefRule iQueryOutRefRule = (IQueryOutRefRule)iQueryRule;
        if (bl && (object = iQueryOutRefRule.getAlternativeResultValidator()) != null) {
            return QueryType.Complex;
        }
        object = iQueryOutRefRule.getFilters();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IQueryFilter iQueryFilter = (IQueryFilter)iterator.next();
            if (this.queryCache.hasEAttributeInCacheByAttr(iQueryFilter.getEAttribute())) continue;
            return QueryType.Complex;
        }
        return QueryType.ByAttribute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fetchResultsByAttributeOnly(IQueryParameters iQueryParameters, List<EObject> list, boolean bl) {
        boolean bl2 = true;
        List<IQueryRule> list2 = iQueryParameters.getRules();
        int n2 = 0;
        int n3 = list2.size();
        while (n2 < n3) {
            IQueryRule iQueryRule = list2.get(n2);
            IQueryOutRefRule iQueryOutRefRule = (IQueryOutRefRule)iQueryRule;
            Set<IQueryFilter> set = iQueryOutRefRule.getFilters();
            if (iQueryOutRefRule.getFilterValidityType() == IQueryOutRefRule.FilterValidityType.ALL) {
                this.fetchResultsByAttrByRetaining(list, set);
            } else {
                this.fetchResultsByAttrByAdding(list, set);
            }
            ++n2;
        }
        this.checkResultsByAttributeOnly(iQueryParameters, list);
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchResultsByAttrByRetaining(List<EObject> list, Set<IQueryFilter> set) {
        boolean bl = true;
        for (IQueryFilter iQueryFilter : set) {
            EAttribute eAttribute = iQueryFilter.getEAttribute();
            String string = QueryHelper.fetchAttributePattern(this.getConfigurableFilterRuleValues(), iQueryFilter);
            if (bl) {
                this.queryCache.getObjectsByAttributeByAdding(eAttribute, string, list);
                bl = false;
                continue;
            }
            this.queryCache.getObjectsByAttributeByRetaining(eAttribute, string, list);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchResultsByAttrByAdding(List<EObject> list, Set<IQueryFilter> set) {
        for (IQueryFilter iQueryFilter : set) {
            EAttribute eAttribute = iQueryFilter.getEAttribute();
            String string = QueryHelper.fetchAttributePattern(this.getConfigurableFilterRuleValues(), iQueryFilter);
            this.queryCache.getObjectsByAttributeByAdding(eAttribute, string, list);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean isReferenceChainPresent(IQueryRule iQueryRule) {
        if (!(iQueryRule instanceof IQueryRefRule)) {
            return false;
        }
        IQueryRefRule iQueryRefRule = (IQueryRefRule)((Object)iQueryRule);
        return iQueryRefRule.getRefChain() != null && !iQueryRefRule.getRefChain().isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkResultsByAttributeOnly(IQueryParameters iQueryParameters, List<EObject> list) {
        boolean bl;
        List<EObject> list2 = iQueryParameters.getRootObjects();
        boolean bl2 = list2 != null && !list2.isEmpty();
        Set<EClass> set = iQueryParameters.getEClassTypes();
        boolean bl3 = bl = set != null && !set.isEmpty();
        if (!bl2 && !bl) {
            return;
        }
        Iterator<EObject> iterator = list.iterator();
        while (iterator.hasNext()) {
            EObject eObject = iterator.next();
            if (bl) {
                if (iQueryParameters.isOnlyThisType()) {
                    if (!set.contains(eObject.eClass())) {
                        iterator.remove();
                        continue;
                    }
                } else {
                    boolean bl4 = false;
                    for (EClass eClass : set) {
                        if (!eClass.isSuperTypeOf(eObject.eClass())) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4) {
                        iterator.remove();
                        continue;
                    }
                }
            }
            if (!bl2 || EcoreUtil.isAncestor(list2, (EObject)eObject)) continue;
            iterator.remove();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fetchResultsByTypeOnly(IQueryParameters var1_1, List<EObject> var2_2) {
        block10: {
            block9: {
                var3_3 = false;
                this.prepareNoFiltersLocalCacheResults(var1_1);
                var4_4 = new ArrayList<EObject>();
                for (EClass var5_7 : var1_1.getEClassTypes()) {
                    if (!this.queryCache.hasEClassInCacheByType(var5_7)) continue;
                    this.queryCache.getObjectsByType(var5_7, var1_1.isOnlyThisType(), var4_4);
                    var3_3 = true;
                }
                var5_7 = var1_1.getRootObjects();
                if (var5_7 == null || var5_7.isEmpty()) break block9;
                var6_6 = 0;
                var7_8 = var4_4.size();
                if (true) ** GOTO lbl30
            }
            var2_2.addAll(var4_4);
            break block10;
            do {
                var8_9 = (EObject)var4_4.get(var6_6);
                var9_10 = 0;
                var10_11 = var5_7.size();
                while (var9_10 < var10_11) {
                    if (var1_1.getScopeFinder().isElementUnderScope(var8_9, (EObject)var5_7.get(var9_10))) {
                        var2_2.add(var8_9);
                        break;
                    }
                    ++var9_10;
                }
                ++var6_6;
lbl30:
                // 2 sources

            } while (var6_6 < var7_8);
        }
        if (var2_2.isEmpty() != false) return var3_3;
        this.queryCache.putQueryResults(var1_1, var2_2, this.getConfigurableFilterRuleValues(), 0);
        return var3_3;
    }

    protected void prepareNoFiltersLocalCacheResults(IQueryParameters iQueryParameters) {
    }

    protected final void searchAllCache(List<EObject> list, IProgressMonitor iProgressMonitor) {
        Set<EClass> set = this.parameters.getEClassTypes();
        if (set == null) {
            return;
        }
        this.doSearchAllCache(set, list, iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSearchAllCache(Set<EClass> set, List<EObject> list, IProgressMonitor iProgressMonitor) {
        CIQueryCondition cIQueryCondition = new CIQueryCondition(this.parameters, true);
        List<EClass> list2 = AbstractQuery.fetchNewTypes(cIQueryCondition);
        if (list2 == null) {
            this.searchAllCache(set, this.createQueryResultMatcher(cIQueryCondition, iProgressMonitor), list, iProgressMonitor);
            return;
        }
        ArrayList<EObject> arrayList = new ArrayList<EObject>();
        this.fetchObjectsOfNewTypes(list2, arrayList);
        for (EObject eObject : arrayList) {
            if (iProgressMonitor.isCanceled()) {
                throw new CancelQueryException();
            }
            List<EObject> list3 = cIQueryCondition.fetchObjectsByRefChainIn(eObject);
            cIQueryCondition.checkReferenceChainOut(list3, this.getConfigurableFilterRuleValues());
            for (EObject eObject2 : list3) {
                if (iProgressMonitor.isCanceled()) {
                    throw new CancelQueryException();
                }
                List<EObject> list4 = list;
                synchronized (list4) {
                    if (!list.contains(eObject2) && cIQueryCondition.checkIsSatisfied(eObject2, false, this.getConfigurableFilterRuleValues())) {
                        list.add(eObject2);
                        list.notifyAll();
                    }
                }
            }
        }
    }

    protected IQueryCache.QueryResultsMatcher createQueryResultMatcher(final CIQueryCondition cIQueryCondition, final IProgressMonitor iProgressMonitor) {
        return new IQueryCache.QueryResultsMatcher(){

            @Override
            public boolean matchesObject(EObject eObject) {
                if (iProgressMonitor.isCanceled()) {
                    throw new CancelQueryException();
                }
                return cIQueryCondition.checkIsSatisfiedWithoutTypeCheck(eObject, true, AbstractQuery.this.getConfigurableFilterRuleValues());
            }

            @Override
            public List<EObject> getRootObjects() {
                return AbstractQuery.this.parameters.getRootObjects();
            }

            @Override
            public QueryScopeFinder getScopeFinder() {
                return AbstractQuery.this.parameters.getScopeFinder();
            }

            @Override
            public boolean isSkipInternalProfilingElements() {
                return AbstractQuery.this.parameters.isSkipInternalProfilingElements();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fetchObjectsOfNewTypes(List<EClass> list, List<EObject> list2) {
        for (EClass eClass : list) {
            this.queryCache.getObjectsByType(eClass, false, list2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<EClass> fetchNewTypes(CIQueryCondition cIQueryCondition) {
        ArrayList<EClass> arrayList = null;
        List<IQueryInRefRule> list = cIQueryCondition.getInFilterRules();
        if (list != null) {
            for (IQueryRefRule iQueryRefRule : list) {
                List<EReference> list2 = iQueryRefRule.getRefChain();
                if (list2 == null || list2.isEmpty()) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<EClass>();
                }
                arrayList.add(list2.iterator().next().getEContainingClass());
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void searchAllCache(Set<EClass> set, IQueryCache.QueryResultsMatcher queryResultsMatcher, List<EObject> list, IProgressMonitor iProgressMonitor) {
        for (EClass eClass : set) {
            if (iProgressMonitor.isCanceled()) {
                throw new CancelQueryException();
            }
            this.queryCache.getObjectsByType(eClass, this.parameters.isOnlyThisType(), list, queryResultsMatcher);
        }
    }

    protected String[] getConfigurableFilterRuleValues() {
        return EMTPTY_STRINGS;
    }

    public static class QueryResult {
        public static final QueryResult Unsorted = new QueryResult(Type.Unsorted, 0);
        public static final QueryResult Failed = new QueryResult(Type.Failed, 0);
        private Type type;
        private int comparatorCacheKey;

        public QueryResult(Type type, int n2) {
            this.type = type;
            this.comparatorCacheKey = n2;
        }

        public Type getType() {
            return this.type;
        }

        public int getComparatorCacheKey() {
            return this.comparatorCacheKey;
        }

        public static enum Type {
            Sorted,
            Unsorted,
            Failed;

        }
    }

    private static enum QueryType {
        ByType,
        ByAttribute,
        Complex,
        Empty;

    }
}

