/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.PersistenceRuntimeException;
import com.nomagic.ci.persistence.local.spi.resources.ResourceInfo;
import com.nomagic.ci.persistence.util.MultiValueHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StreamLocatorMigrator {
    private final Map<String, String> migratedStreamIDs = new HashMap<String, String>();
    private final MultiValueHashMap<ResourceInfo, String> binaryIndex = new MultiValueHashMap();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteArrayInputStream migrate(InputStream inputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Node node;
        void var7_10;
        Object object4;
        Object object5;
        Document document = this.read(inputStream);
        NodeList nodeList = document.getElementsByTagName("features");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            object5 = (Element)nodeList.item(n2);
            String string = object5.getAttribute("xmi:id");
            object4 = object5.getAttribute("namespace");
            hashMap.put(string, (String)object4);
            ++n2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object5 = document.getElementsByTagName("binaries");
        boolean bl = false;
        while (var7_10 < object5.getLength()) {
            String string;
            object4 = (Element)object5.item((int)var7_10);
            node = (Element)object4.getParentNode();
            arrayList.add(object4);
            object3 = object4.getAttribute("xmi:id");
            String string2 = object4.getAttribute("_internalResource");
            object2 = StreamLocatorMigrator.migrateBinaryStreamID((String)object3);
            this.migratedStreamIDs.put(string2, (String)object2);
            object = node.getAttribute("name");
            String string3 = node.getAttribute("featuredBy");
            String string4 = (String)hashMap.get(string3);
            String string5 = node.getAttribute("belongsTo");
            String string6 = string = !string5.isEmpty() ? "default" : null;
            if (object != null && !((String)object).isEmpty() && string4 != null && !string4.isEmpty()) {
                this.binaryIndex.append((Object)new ResourceInfo(string, string4, (String)object), object2);
            }
            ++var7_10;
        }
        for (Element element : arrayList) {
            node = element.getParentNode();
            node.removeChild(element);
            node.normalize();
            object3 = node.getChildNodes();
            int n3 = 0;
            while (n3 < object3.getLength()) {
                object2 = object3.item(n3);
                if (object2 instanceof CharacterData && (object = (CharacterData)object2).getData().trim().isEmpty()) {
                    node.removeChild((Node)object);
                }
                ++n3;
            }
        }
        document.normalizeDocument();
        document.setXmlStandalone(true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(document, new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public Map<String, String> getStreamsToRename() {
        return this.migratedStreamIDs;
    }

    public Map<ResourceInfo, Set<String>> getStreamsLocation() {
        return this.binaryIndex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String migrateBinaryStreamID(String string) {
        string = string.replaceAll("_", "5F").replaceAll("-", "2D");
        StringBuilder stringBuilder = new StringBuilder(string);
        while (stringBuilder.length() < 32) {
            stringBuilder.append('0');
        }
        stringBuilder.insert(8, '-');
        stringBuilder.insert(13, '-');
        stringBuilder.insert(18, '-');
        stringBuilder.insert(23, '-');
        return "BINARY-" + stringBuilder.toString();
    }

    private Document read(InputStream inputStream) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new PersistenceRuntimeException((Throwable)exception);
        }
    }

    private void write(Document document, Writer writer) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            writer.flush();
        }
        catch (TransformerException | TransformerFactoryConfigurationError throwable) {
            throw new PersistenceRuntimeException(throwable);
        }
    }
}

