/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.ci.persistence.local.spi.migration;

import com.nomagic.ci.persistence.local.spi.files.IRenamingPersistence;
import com.nomagic.ci.persistence.local.spi.files.IResourcePersistence;
import com.nomagic.ci.persistence.local.spi.files.ResourceInfoEncoderDecoder;
import com.nomagic.ci.persistence.local.spi.migration.Migrator;
import com.nomagic.ci.persistence.local.spi.migration.ResourcePersistenceContext;
import java.io.InputStream;
import java.util.ArrayList;

public class ProxyResourceNameMigrator
implements Migrator {
    private static final String PROXY = "proxy.";

    @Override
    public String getPrintableName() {
        return "Proxy Resource Name Migrator";
    }

    @Override
    public void migrateResources(IRenamingPersistence iRenamingPersistence, ResourcePersistenceContext resourcePersistenceContext) {
        for (String string : new ArrayList<String>(iRenamingPersistence.getResources())) {
            int n2;
            if (!string.startsWith(PROXY) || (n2 = string.lastIndexOf(".")) <= PROXY.length()) continue;
            String string2 = string.substring(PROXY.length());
            String string3 = ResourceInfoEncoderDecoder.encodeResourceName(string2);
            String string4 = PROXY + string3;
            iRenamingPersistence.renameResource(string, string4);
        }
    }

    @Override
    public boolean isStreamMigrationNeeded(IResourcePersistence iResourcePersistence, String string, ResourcePersistenceContext resourcePersistenceContext) {
        return false;
    }

    @Override
    public InputStream migrateInputStream(IResourcePersistence iResourcePersistence, InputStream inputStream, String string, ResourcePersistenceContext resourcePersistenceContext) {
        return null;
    }
}

